/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.applicationautoscaling.Schedule;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.Ec2TaskDefinition;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskDefinitionOptions;
import software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskImageOptions;
import software.amazon.awscdk.services.ecs.patterns.ScheduledEc2TaskProps;
import software.amazon.awscdk.services.ecs.patterns.ScheduledTaskBase;
import software.amazon.awscdk.services.events.targets.EcsTask;
import software.amazon.awscdk.services.events.targets.Tag;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ecs_patterns.ScheduledEc2Task")
public class ScheduledEc2Task
extends ScheduledTaskBase {
    protected ScheduledEc2Task(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ScheduledEc2Task(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ScheduledEc2Task(@NotNull Construct scope, @NotNull String id, @NotNull ScheduledEc2TaskProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public EcsTask getTask() {
        return (EcsTask)Kernel.get((Object)((Object)this), (String)"task", (NativeType)NativeType.forClass(EcsTask.class));
    }

    @NotNull
    public Ec2TaskDefinition getTaskDefinition() {
        return (Ec2TaskDefinition)Kernel.get((Object)((Object)this), (String)"taskDefinition", (NativeType)NativeType.forClass(Ec2TaskDefinition.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ScheduledEc2Task> {
        private final Construct scope;
        private final String id;
        private final ScheduledEc2TaskProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ScheduledEc2TaskProps.Builder();
        }

        public Builder schedule(Schedule schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        public Builder desiredTaskCount(Number desiredTaskCount) {
            this.props.desiredTaskCount(desiredTaskCount);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.props.ruleName(ruleName);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        public Builder tags(List<? extends Tag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder scheduledEc2TaskDefinitionOptions(ScheduledEc2TaskDefinitionOptions scheduledEc2TaskDefinitionOptions) {
            this.props.scheduledEc2TaskDefinitionOptions(scheduledEc2TaskDefinitionOptions);
            return this;
        }

        public Builder scheduledEc2TaskImageOptions(ScheduledEc2TaskImageOptions scheduledEc2TaskImageOptions) {
            this.props.scheduledEc2TaskImageOptions(scheduledEc2TaskImageOptions);
            return this;
        }

        public ScheduledEc2Task build() {
            return new ScheduledEc2Task(this.scope, this.id, this.props.build());
        }
    }
}

