/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.amplify;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.amplify.CfnApp;
import software.amazon.awscdk.services.amplify.CfnAppProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_amplify.CfnApp")
public class CfnApp
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApp.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnApp(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApp(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApp(@NotNull Construct scope, @NotNull String id, @NotNull CfnAppProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrAppId() {
        return (String)Kernel.get((Object)this, (String)"attrAppId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrAppName() {
        return (String)Kernel.get((Object)this, (String)"attrAppName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDefaultDomain() {
        return (String)Kernel.get((Object)this, (String)"attrDefaultDomain", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getAccessToken() {
        return (String)Kernel.get((Object)this, (String)"accessToken", (NativeType)NativeType.forClass(String.class));
    }

    public void setAccessToken(@Nullable String value) {
        Kernel.set((Object)this, (String)"accessToken", (Object)value);
    }

    @Nullable
    public Object getAutoBranchCreationConfig() {
        return Kernel.get((Object)this, (String)"autoBranchCreationConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAutoBranchCreationConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"autoBranchCreationConfig", (Object)value);
    }

    public void setAutoBranchCreationConfig(@Nullable AutoBranchCreationConfigProperty value) {
        Kernel.set((Object)this, (String)"autoBranchCreationConfig", (Object)value);
    }

    @Nullable
    public Object getBasicAuthConfig() {
        return Kernel.get((Object)this, (String)"basicAuthConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setBasicAuthConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"basicAuthConfig", (Object)value);
    }

    public void setBasicAuthConfig(@Nullable BasicAuthConfigProperty value) {
        Kernel.set((Object)this, (String)"basicAuthConfig", (Object)value);
    }

    @Nullable
    public String getBuildSpec() {
        return (String)Kernel.get((Object)this, (String)"buildSpec", (NativeType)NativeType.forClass(String.class));
    }

    public void setBuildSpec(@Nullable String value) {
        Kernel.set((Object)this, (String)"buildSpec", (Object)value);
    }

    @Nullable
    public String getCustomHeaders() {
        return (String)Kernel.get((Object)this, (String)"customHeaders", (NativeType)NativeType.forClass(String.class));
    }

    public void setCustomHeaders(@Nullable String value) {
        Kernel.set((Object)this, (String)"customHeaders", (Object)value);
    }

    @Nullable
    public Object getCustomRules() {
        return Kernel.get((Object)this, (String)"customRules", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCustomRules(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"customRules", (Object)value);
    }

    public void setCustomRules(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof CustomRuleProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.amplify.CfnApp.CustomRuleProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"customRules", value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getEnableBranchAutoDeletion() {
        return Kernel.get((Object)this, (String)"enableBranchAutoDeletion", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnableBranchAutoDeletion(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableBranchAutoDeletion", (Object)value);
    }

    public void setEnableBranchAutoDeletion(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enableBranchAutoDeletion", (Object)value);
    }

    @Nullable
    public Object getEnvironmentVariables() {
        return Kernel.get((Object)this, (String)"environmentVariables", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnvironmentVariables(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"environmentVariables", (Object)value);
    }

    public void setEnvironmentVariables(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof EnvironmentVariableProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.amplify.CfnApp.EnvironmentVariableProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"environmentVariables", value);
    }

    @Nullable
    public String getIamServiceRole() {
        return (String)Kernel.get((Object)this, (String)"iamServiceRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setIamServiceRole(@Nullable String value) {
        Kernel.set((Object)this, (String)"iamServiceRole", (Object)value);
    }

    @Nullable
    public String getOauthToken() {
        return (String)Kernel.get((Object)this, (String)"oauthToken", (NativeType)NativeType.forClass(String.class));
    }

    public void setOauthToken(@Nullable String value) {
        Kernel.set((Object)this, (String)"oauthToken", (Object)value);
    }

    @Nullable
    public String getPlatform() {
        return (String)Kernel.get((Object)this, (String)"platform", (NativeType)NativeType.forClass(String.class));
    }

    public void setPlatform(@Nullable String value) {
        Kernel.set((Object)this, (String)"platform", (Object)value);
    }

    @Nullable
    public String getRepository() {
        return (String)Kernel.get((Object)this, (String)"repository", (NativeType)NativeType.forClass(String.class));
    }

    public void setRepository(@Nullable String value) {
        Kernel.set((Object)this, (String)"repository", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_amplify.CfnApp.CustomRuleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomRuleProperty
    extends JsiiSerializable {
        @NotNull
        public String getSource();

        @NotNull
        public String getTarget();

        @Nullable
        default public String getCondition() {
            return null;
        }

        @Nullable
        default public String getStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomRuleProperty> {
            String source;
            String target;
            String condition;
            String status;

            public Builder source(String source) {
                this.source = source;
                return this;
            }

            public Builder target(String target) {
                this.target = target;
                return this;
            }

            public Builder condition(String condition) {
                this.condition = condition;
                return this;
            }

            public Builder status(String status) {
                this.status = status;
                return this;
            }

            public CustomRuleProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_amplify.CfnApp.EnvironmentVariableProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnvironmentVariableProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnvironmentVariableProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public EnvironmentVariableProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApp> {
        private final Construct scope;
        private final String id;
        private final CfnAppProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnAppProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder accessToken(String accessToken) {
            this.props.accessToken(accessToken);
            return this;
        }

        public Builder autoBranchCreationConfig(IResolvable autoBranchCreationConfig) {
            this.props.autoBranchCreationConfig(autoBranchCreationConfig);
            return this;
        }

        public Builder autoBranchCreationConfig(AutoBranchCreationConfigProperty autoBranchCreationConfig) {
            this.props.autoBranchCreationConfig(autoBranchCreationConfig);
            return this;
        }

        public Builder basicAuthConfig(IResolvable basicAuthConfig) {
            this.props.basicAuthConfig(basicAuthConfig);
            return this;
        }

        public Builder basicAuthConfig(BasicAuthConfigProperty basicAuthConfig) {
            this.props.basicAuthConfig(basicAuthConfig);
            return this;
        }

        public Builder buildSpec(String buildSpec) {
            this.props.buildSpec(buildSpec);
            return this;
        }

        public Builder customHeaders(String customHeaders) {
            this.props.customHeaders(customHeaders);
            return this;
        }

        public Builder customRules(IResolvable customRules) {
            this.props.customRules(customRules);
            return this;
        }

        public Builder customRules(List<? extends Object> customRules) {
            this.props.customRules(customRules);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder enableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.props.enableBranchAutoDeletion(enableBranchAutoDeletion);
            return this;
        }

        public Builder enableBranchAutoDeletion(IResolvable enableBranchAutoDeletion) {
            this.props.enableBranchAutoDeletion(enableBranchAutoDeletion);
            return this;
        }

        public Builder environmentVariables(IResolvable environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }

        public Builder environmentVariables(List<? extends Object> environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }

        public Builder iamServiceRole(String iamServiceRole) {
            this.props.iamServiceRole(iamServiceRole);
            return this;
        }

        public Builder oauthToken(String oauthToken) {
            this.props.oauthToken(oauthToken);
            return this;
        }

        public Builder platform(String platform) {
            this.props.platform(platform);
            return this;
        }

        public Builder repository(String repository) {
            this.props.repository(repository);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnApp build() {
            return new CfnApp(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_amplify.CfnApp.BasicAuthConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BasicAuthConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnableBasicAuth() {
            return null;
        }

        @Nullable
        default public String getPassword() {
            return null;
        }

        @Nullable
        default public String getUsername() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BasicAuthConfigProperty> {
            Object enableBasicAuth;
            String password;
            String username;

            public Builder enableBasicAuth(Boolean enableBasicAuth) {
                this.enableBasicAuth = enableBasicAuth;
                return this;
            }

            public Builder enableBasicAuth(IResolvable enableBasicAuth) {
                this.enableBasicAuth = enableBasicAuth;
                return this;
            }

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public BasicAuthConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_amplify.CfnApp.AutoBranchCreationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoBranchCreationConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAutoBranchCreationPatterns() {
            return null;
        }

        @Nullable
        default public Object getBasicAuthConfig() {
            return null;
        }

        @Nullable
        default public String getBuildSpec() {
            return null;
        }

        @Nullable
        default public Object getEnableAutoBranchCreation() {
            return null;
        }

        @Nullable
        default public Object getEnableAutoBuild() {
            return null;
        }

        @Nullable
        default public Object getEnablePerformanceMode() {
            return null;
        }

        @Nullable
        default public Object getEnablePullRequestPreview() {
            return null;
        }

        @Nullable
        default public Object getEnvironmentVariables() {
            return null;
        }

        @Nullable
        default public String getFramework() {
            return null;
        }

        @Nullable
        default public String getPullRequestEnvironmentName() {
            return null;
        }

        @Nullable
        default public String getStage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoBranchCreationConfigProperty> {
            List<String> autoBranchCreationPatterns;
            Object basicAuthConfig;
            String buildSpec;
            Object enableAutoBranchCreation;
            Object enableAutoBuild;
            Object enablePerformanceMode;
            Object enablePullRequestPreview;
            Object environmentVariables;
            String framework;
            String pullRequestEnvironmentName;
            String stage;

            public Builder autoBranchCreationPatterns(List<String> autoBranchCreationPatterns) {
                this.autoBranchCreationPatterns = autoBranchCreationPatterns;
                return this;
            }

            public Builder basicAuthConfig(IResolvable basicAuthConfig) {
                this.basicAuthConfig = basicAuthConfig;
                return this;
            }

            public Builder basicAuthConfig(BasicAuthConfigProperty basicAuthConfig) {
                this.basicAuthConfig = basicAuthConfig;
                return this;
            }

            public Builder buildSpec(String buildSpec) {
                this.buildSpec = buildSpec;
                return this;
            }

            public Builder enableAutoBranchCreation(Boolean enableAutoBranchCreation) {
                this.enableAutoBranchCreation = enableAutoBranchCreation;
                return this;
            }

            public Builder enableAutoBranchCreation(IResolvable enableAutoBranchCreation) {
                this.enableAutoBranchCreation = enableAutoBranchCreation;
                return this;
            }

            public Builder enableAutoBuild(Boolean enableAutoBuild) {
                this.enableAutoBuild = enableAutoBuild;
                return this;
            }

            public Builder enableAutoBuild(IResolvable enableAutoBuild) {
                this.enableAutoBuild = enableAutoBuild;
                return this;
            }

            public Builder enablePerformanceMode(Boolean enablePerformanceMode) {
                this.enablePerformanceMode = enablePerformanceMode;
                return this;
            }

            public Builder enablePerformanceMode(IResolvable enablePerformanceMode) {
                this.enablePerformanceMode = enablePerformanceMode;
                return this;
            }

            public Builder enablePullRequestPreview(Boolean enablePullRequestPreview) {
                this.enablePullRequestPreview = enablePullRequestPreview;
                return this;
            }

            public Builder enablePullRequestPreview(IResolvable enablePullRequestPreview) {
                this.enablePullRequestPreview = enablePullRequestPreview;
                return this;
            }

            public Builder environmentVariables(IResolvable environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            public Builder environmentVariables(List<? extends Object> environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            public Builder framework(String framework) {
                this.framework = framework;
                return this;
            }

            public Builder pullRequestEnvironmentName(String pullRequestEnvironmentName) {
                this.pullRequestEnvironmentName = pullRequestEnvironmentName;
                return this;
            }

            public Builder stage(String stage) {
                this.stage = stage;
                return this;
            }

            public AutoBranchCreationConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

