/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisClusterOperationException;
import redis.clients.jedis.util.SafeEncoder;

public class JedisClusterInfoCache {
    private final Map<String, ConnectionPool> nodes = new HashMap<String, ConnectionPool>();
    private final Map<Integer, ConnectionPool> slots = new HashMap<Integer, ConnectionPool>();
    private final Map<Integer, HostAndPort> slotNodes = new HashMap<Integer, HostAndPort>();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    private final Lock rediscoverLock = new ReentrantLock();
    private final GenericObjectPoolConfig<Connection> poolConfig;
    private final JedisClientConfig clientConfig;
    private final Set<HostAndPort> startNodes;
    private static final int MASTER_NODE_INDEX = 2;

    @Deprecated
    public JedisClusterInfoCache(JedisClientConfig clientConfig) {
        this(clientConfig, (GenericObjectPoolConfig<Connection>)new GenericObjectPoolConfig());
    }

    @Deprecated
    public JedisClusterInfoCache(JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this(clientConfig, poolConfig, null);
    }

    public JedisClusterInfoCache(JedisClientConfig clientConfig, Set<HostAndPort> startNodes) {
        this(clientConfig, null, startNodes);
    }

    public JedisClusterInfoCache(JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig, Set<HostAndPort> startNodes) {
        this.poolConfig = poolConfig;
        this.clientConfig = clientConfig;
        this.startNodes = startNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverClusterNodesAndSlots(Connection jedis) {
        List<Object> slotsInfo = this.executeClusterSlots(jedis);
        if (slotsInfo.isEmpty()) {
            throw new JedisClusterOperationException("Cluster slots list is empty.");
        }
        this.w.lock();
        try {
            this.reset();
            for (Object slotInfoObj : slotsInfo) {
                List slotInfo = (List)slotInfoObj;
                if (slotInfo.size() <= 2) continue;
                List<Integer> slotNums = this.getAssignedSlotArray(slotInfo);
                int size = slotInfo.size();
                for (int i = 2; i < size; ++i) {
                    List hostInfos = (List)slotInfo.get(i);
                    if (hostInfos.isEmpty()) continue;
                    HostAndPort targetNode = this.generateHostAndPort(hostInfos);
                    this.setupNodeIfNotExist(targetNode);
                    if (i != 2) continue;
                    this.assignSlotsToNode(slotNums, targetNode);
                }
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public void renewClusterSlots(Connection jedis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 19[CATCHBLOCK]], but top level block is 32[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverClusterSlots(Connection jedis) {
        List<Object> slotsInfo = this.executeClusterSlots(jedis);
        if (slotsInfo.isEmpty()) {
            throw new JedisClusterOperationException("Cluster slots list is empty.");
        }
        this.w.lock();
        try {
            this.slots.clear();
            this.slotNodes.clear();
            HashSet<String> hostAndPortKeys = new HashSet<String>();
            for (Object slotInfoObj : slotsInfo) {
                List slotInfo = (List)slotInfoObj;
                if (slotInfo.size() <= 2) continue;
                List<Integer> slotNums = this.getAssignedSlotArray(slotInfo);
                int size = slotInfo.size();
                for (int i = 2; i < size; ++i) {
                    List hostInfos = (List)slotInfo.get(i);
                    if (hostInfos.isEmpty()) continue;
                    HostAndPort targetNode = this.generateHostAndPort(hostInfos);
                    hostAndPortKeys.add(JedisClusterInfoCache.getNodeKey(targetNode));
                    this.setupNodeIfNotExist(targetNode);
                    if (i != 2) continue;
                    this.assignSlotsToNode(slotNums, targetNode);
                }
            }
            Iterator<Map.Entry<String, ConnectionPool>> entryIt = this.nodes.entrySet().iterator();
            while (entryIt.hasNext()) {
                Map.Entry<String, ConnectionPool> entry = entryIt.next();
                if (hostAndPortKeys.contains(entry.getKey())) continue;
                ConnectionPool pool = entry.getValue();
                try {
                    if (pool != null) {
                        pool.destroy();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                entryIt.remove();
            }
        }
        finally {
            this.w.unlock();
        }
    }

    private HostAndPort generateHostAndPort(List<Object> hostInfos) {
        String host = SafeEncoder.encode((byte[])hostInfos.get(0));
        int port = ((Long)hostInfos.get(1)).intValue();
        return new HostAndPort(host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionPool setupNodeIfNotExist(HostAndPort node) {
        this.w.lock();
        try {
            String nodeKey = JedisClusterInfoCache.getNodeKey(node);
            ConnectionPool existingPool = this.nodes.get(nodeKey);
            if (existingPool != null) {
                ConnectionPool connectionPool = existingPool;
                return connectionPool;
            }
            ConnectionPool nodePool = this.poolConfig == null ? new ConnectionPool(node, this.clientConfig) : new ConnectionPool(node, this.clientConfig, this.poolConfig);
            this.nodes.put(nodeKey, nodePool);
            ConnectionPool connectionPool = nodePool;
            return connectionPool;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSlotToNode(int slot, HostAndPort targetNode) {
        this.w.lock();
        try {
            ConnectionPool targetPool = this.setupNodeIfNotExist(targetNode);
            this.slots.put(slot, targetPool);
            this.slotNodes.put(slot, targetNode);
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignSlotsToNode(List<Integer> targetSlots, HostAndPort targetNode) {
        this.w.lock();
        try {
            ConnectionPool targetPool = this.setupNodeIfNotExist(targetNode);
            for (Integer slot : targetSlots) {
                this.slots.put(slot, targetPool);
                this.slotNodes.put(slot, targetNode);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    public ConnectionPool getNode(String nodeKey) {
        this.r.lock();
        try {
            ConnectionPool connectionPool = this.nodes.get(nodeKey);
            return connectionPool;
        }
        finally {
            this.r.unlock();
        }
    }

    public ConnectionPool getNode(HostAndPort node) {
        return this.getNode(JedisClusterInfoCache.getNodeKey(node));
    }

    public ConnectionPool getSlotPool(int slot) {
        this.r.lock();
        try {
            ConnectionPool connectionPool = this.slots.get(slot);
            return connectionPool;
        }
        finally {
            this.r.unlock();
        }
    }

    public HostAndPort getSlotNode(int slot) {
        this.r.lock();
        try {
            HostAndPort hostAndPort = this.slotNodes.get(slot);
            return hostAndPort;
        }
        finally {
            this.r.unlock();
        }
    }

    public Map<String, ConnectionPool> getNodes() {
        this.r.lock();
        try {
            HashMap<String, ConnectionPool> hashMap = new HashMap<String, ConnectionPool>(this.nodes);
            return hashMap;
        }
        finally {
            this.r.unlock();
        }
    }

    public List<ConnectionPool> getShuffledNodesPool() {
        this.r.lock();
        try {
            ArrayList<ConnectionPool> pools = new ArrayList<ConnectionPool>(this.nodes.values());
            Collections.shuffle(pools);
            ArrayList<ConnectionPool> arrayList = pools;
            return arrayList;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.w.lock();
        try {
            for (ConnectionPool pool : this.nodes.values()) {
                try {
                    if (pool == null) continue;
                    pool.destroy();
                }
                catch (RuntimeException runtimeException) {}
            }
            this.nodes.clear();
            this.slots.clear();
            this.slotNodes.clear();
        }
        finally {
            this.w.unlock();
        }
    }

    public static String getNodeKey(HostAndPort hnp) {
        return hnp.toString();
    }

    private List<Object> executeClusterSlots(Connection jedis) {
        jedis.sendCommand((ProtocolCommand)Protocol.Command.CLUSTER, "SLOTS");
        return jedis.getObjectMultiBulkReply();
    }

    private List<Integer> getAssignedSlotArray(List<Object> slotInfo) {
        ArrayList<Integer> slotNums = new ArrayList<Integer>();
        for (int slot = ((Long)slotInfo.get(0)).intValue(); slot <= ((Long)slotInfo.get(1)).intValue(); ++slot) {
            slotNums.add(slot);
        }
        return slotNums;
    }
}

