/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import redis.clients.jedis.BroadcastResponse;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.args.FlushMode;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.providers.ConnectionProvider;
import redis.clients.jedis.search.FTCreateParams;
import redis.clients.jedis.search.IndexOptions;
import redis.clients.jedis.search.Schema;
import redis.clients.jedis.search.SearchProtocol;
import redis.clients.jedis.search.schemafields.SchemaField;
import redis.clients.jedis.util.Pool;

public class JedisBroadcast {
    private final ConnectionProvider provider;

    public JedisBroadcast(UnifiedJedis jedis) {
        this(jedis.provider);
    }

    public JedisBroadcast(ConnectionProvider provider) {
        if (provider == null) {
            throw new NullPointerException("ConnectionProvider cannot be null.");
        }
        this.provider = provider;
    }

    public final <T> Map<?, Supplier<T>> broadcastCommand(CommandObject<T> commandObject) {
        Map<?, ?> connectionMap = this.provider.getConnectionMap();
        HashMap responseMap = new HashMap(connectionMap.size(), 1.0f);
        for (Map.Entry<?, ?> entry : connectionMap.entrySet()) {
            Object key = entry.getKey();
            Object connection = entry.getValue();
            try {
                responseMap.put(key, new BroadcastResponse<T>(this.executeCommand(connection, commandObject)));
            }
            catch (RuntimeException re) {
                responseMap.put(key, new BroadcastResponse(re));
            }
        }
        return responseMap;
    }

    private <T> T executeCommand(Object connection, CommandObject<T> commandObject) {
        if (connection instanceof Connection) {
            return ((Connection)connection).executeCommand(commandObject);
        }
        if (connection instanceof Pool) {
            try (Connection _conn = (Connection)((Pool)((Object)connection)).getResource();){
                T t = _conn.executeCommand(commandObject);
                return t;
            }
        }
        throw new IllegalStateException(connection.getClass() + "is not supported.");
    }

    public Map<?, Supplier<String>> ping() {
        return this.broadcastCommand(new CommandObject<String>(new CommandArguments(Protocol.Command.PING), BuilderFactory.STRING));
    }

    public Map<?, Supplier<String>> configSet(String ... parameterValues) {
        if (parameterValues.length > 0 && parameterValues.length % 2 != 0) {
            throw new IllegalArgumentException("It requires 'pair's of config parameter-values.");
        }
        CommandArguments args = new CommandArguments(Protocol.Command.CONFIG).add(Protocol.Keyword.SET).addObjects(parameterValues);
        return this.broadcastCommand(new CommandObject<String>(args, BuilderFactory.STRING));
    }

    public Map<?, Supplier<String>> flushDB() {
        return this.broadcastCommand(new CommandObject<String>(new CommandArguments(Protocol.Command.FLUSHDB), BuilderFactory.STRING));
    }

    public Map<?, Supplier<String>> flushDB(FlushMode flushMode) {
        return this.broadcastCommand(new CommandObject<String>(new CommandArguments(Protocol.Command.FLUSHDB).add(flushMode), BuilderFactory.STRING));
    }

    public Map<?, Supplier<String>> flushAll() {
        return this.broadcastCommand(new CommandObject<String>(new CommandArguments(Protocol.Command.FLUSHALL), BuilderFactory.STRING));
    }

    public Map<?, Supplier<String>> flushAll(FlushMode flushMode) {
        return this.broadcastCommand(new CommandObject<String>(new CommandArguments(Protocol.Command.FLUSHALL).add(flushMode), BuilderFactory.STRING));
    }

    public Map<?, Supplier<Long>> waitReplicas(int replicas, long timeout) {
        CommandArguments args = new CommandArguments(Protocol.Command.WAIT).add(Protocol.toByteArray(replicas)).add(Protocol.toByteArray(timeout));
        return this.broadcastCommand(new CommandObject<Long>(args, BuilderFactory.LONG));
    }

    public Map<?, Supplier<List<Boolean>>> scriptExists(String ... sha1) {
        CommandObject<List<Boolean>> command = new CommandObject<List<Boolean>>(new CommandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.EXISTS).addObjects(sha1), BuilderFactory.BOOLEAN_LIST);
        return this.broadcastCommand(command);
    }

    public Map<?, Supplier<List<Boolean>>> scriptExists(byte[] ... sha1) {
        CommandObject<List<Boolean>> command = new CommandObject<List<Boolean>>(new CommandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.EXISTS).addObjects((Object[])sha1), BuilderFactory.BOOLEAN_LIST);
        return this.broadcastCommand(command);
    }

    public Map<?, Supplier<String>> scriptLoad(String script) {
        CommandObject<String> command = new CommandObject<String>(new CommandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.LOAD).add(script), BuilderFactory.STRING);
        return this.broadcastCommand(command);
    }

    public Map<?, Supplier<byte[]>> scriptLoad(byte[] script) {
        CommandObject<byte[]> command = new CommandObject<byte[]>(new CommandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.LOAD).add(script), BuilderFactory.BINARY);
        return this.broadcastCommand(command);
    }

    public Map<?, Supplier<String>> scriptFlush() {
        CommandObject<String> command = new CommandObject<String>(new CommandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.FLUSH), BuilderFactory.STRING);
        return this.broadcastCommand(command);
    }

    public Map<?, Supplier<String>> scriptFlush(FlushMode flushMode) {
        CommandObject<String> command = new CommandObject<String>(new CommandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.FLUSH).add(flushMode), BuilderFactory.STRING);
        return this.broadcastCommand(command);
    }

    public Map<?, Supplier<String>> scriptKill() {
        CommandObject<String> command = new CommandObject<String>(new CommandArguments(Protocol.Command.SCRIPT).add(Protocol.Keyword.KILL), BuilderFactory.STRING);
        return this.broadcastCommand(command);
    }

    public Map<?, Supplier<String>> ftCreate(String indexName, IndexOptions indexOptions, Schema schema) {
        CommandArguments args = new CommandArguments(SearchProtocol.SearchCommand.CREATE).add(indexName).addParams(indexOptions).add(SearchProtocol.SearchKeyword.SCHEMA);
        schema.fields.forEach(field -> args.addParams((IParams)field));
        return this.broadcastCommand(new CommandObject<String>(args, BuilderFactory.STRING));
    }

    public Map<?, Supplier<String>> ftCreate(String indexName, SchemaField ... schemaFields) {
        return this.ftCreate(indexName, Arrays.asList(schemaFields));
    }

    public Map<?, Supplier<String>> ftCreate(String indexName, FTCreateParams createParams, SchemaField ... schemaFields) {
        return this.ftCreate(indexName, createParams, Arrays.asList(schemaFields));
    }

    public Map<?, Supplier<String>> ftCreate(String indexName, Iterable<SchemaField> schemaFields) {
        return this.ftCreate(indexName, FTCreateParams.createParams(), schemaFields);
    }

    public Map<?, Supplier<String>> ftCreate(String indexName, FTCreateParams createParams, Iterable<SchemaField> schemaFields) {
        CommandArguments args = new CommandArguments(SearchProtocol.SearchCommand.CREATE).add(indexName).addParams(createParams).add(SearchProtocol.SearchKeyword.SCHEMA);
        schemaFields.forEach(field -> args.addParams((IParams)field));
        return this.broadcastCommand(new CommandObject<String>(args, BuilderFactory.STRING));
    }

    public Map<?, Supplier<String>> ftDropIndex(String indexName) {
        return this.broadcastCommand(new CommandObject<String>(new CommandArguments(SearchProtocol.SearchCommand.DROPINDEX).add(indexName), BuilderFactory.STRING));
    }

    public Map<?, Supplier<String>> ftDropIndexDD(String indexName) {
        return this.broadcastCommand(new CommandObject<String>(new CommandArguments(SearchProtocol.SearchCommand.DROPINDEX).add(indexName).add(SearchProtocol.SearchKeyword.DD), BuilderFactory.STRING));
    }
}

