/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git.log;

import org.apache.maven.plugin.Mojo;
import pl.project13.maven.git.log.FormattingTuple;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.log.MessageFormatter;

public class MavenLoggerBridge
implements LoggerBridge {
    private boolean verbose;
    private final Mojo mojo;

    public MavenLoggerBridge(Mojo mojo, boolean verbose) {
        this.mojo = mojo;
        this.verbose = verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.mojo.getLog().isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.mojo.getLog().isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.mojo.getLog().isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.mojo.getLog().isErrorEnabled();
    }

    @Override
    public void debug(String msg) {
        if (this.verbose) {
            this.mojo.getLog().debug((CharSequence)msg);
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.verbose) {
            this.debug(MessageFormatter.format(format, arg));
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.verbose) {
            this.debug(MessageFormatter.format(format, arg1, arg2));
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.verbose) {
            this.debug(MessageFormatter.arrayFormat(format, arguments));
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (this.verbose) {
            this.mojo.getLog().debug((CharSequence)msg, t);
        }
    }

    @Override
    public void info(String msg) {
        if (this.verbose) {
            this.mojo.getLog().info((CharSequence)msg);
        }
    }

    @Override
    public void info(String format, Object arg) {
        if (this.verbose) {
            this.info(MessageFormatter.format(format, arg));
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.verbose) {
            this.info(MessageFormatter.format(format, arg1, arg2));
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.verbose) {
            this.info(MessageFormatter.arrayFormat(format, arguments));
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        if (this.verbose) {
            this.mojo.getLog().info((CharSequence)msg, t);
        }
    }

    @Override
    public void warn(String msg) {
        if (this.verbose) {
            this.mojo.getLog().warn((CharSequence)msg);
        }
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.verbose) {
            this.warn(MessageFormatter.format(format, arg));
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.verbose) {
            this.warn(MessageFormatter.format(format, arg1, arg2));
        }
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.verbose) {
            this.warn(MessageFormatter.arrayFormat(format, arguments));
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (this.verbose) {
            this.mojo.getLog().warn((CharSequence)msg, t);
        }
    }

    @Override
    public void error(String msg) {
        if (this.verbose) {
            this.mojo.getLog().error((CharSequence)msg);
        }
    }

    @Override
    public void error(String format, Object arg) {
        if (this.verbose) {
            this.error(MessageFormatter.format(format, arg));
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.verbose) {
            this.error(MessageFormatter.format(format, arg1, arg2));
        }
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.verbose) {
            this.error(MessageFormatter.arrayFormat(format, arguments));
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        if (this.verbose) {
            this.mojo.getLog().error((CharSequence)msg, t);
        }
    }

    private void debug(FormattingTuple tuple) {
        if (null == tuple.getThrowable()) {
            this.mojo.getLog().debug((CharSequence)tuple.getMessage());
        } else {
            this.mojo.getLog().debug((CharSequence)tuple.getMessage(), tuple.getThrowable());
        }
    }

    private void info(FormattingTuple tuple) {
        if (null == tuple.getThrowable()) {
            this.mojo.getLog().info((CharSequence)tuple.getMessage());
        } else {
            this.mojo.getLog().info((CharSequence)tuple.getMessage(), tuple.getThrowable());
        }
    }

    private void warn(FormattingTuple tuple) {
        if (null == tuple.getThrowable()) {
            this.mojo.getLog().warn((CharSequence)tuple.getMessage());
        } else {
            this.mojo.getLog().warn((CharSequence)tuple.getMessage(), tuple.getThrowable());
        }
    }

    private void error(FormattingTuple tuple) {
        if (null == tuple.getThrowable()) {
            this.mojo.getLog().error((CharSequence)tuple.getMessage());
        } else {
            this.mojo.getLog().error((CharSequence)tuple.getMessage(), tuple.getThrowable());
        }
    }
}

