/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.gen;

import java.util.HashMap;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ClientApi;
import org.zaproxy.clientapi.core.ClientApiException;
import org.zaproxy.clientapi.gen.deprecated.UsersDeprecated;

public class Users
extends UsersDeprecated {
    private final ClientApi api;

    public Users(ClientApi api) {
        super(api);
        this.api = api;
    }

    public ApiResponse usersList(String contextid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (contextid != null) {
            map.put("contextId", contextid);
        }
        return this.api.callApi("users", "view", "usersList", map);
    }

    public ApiResponse getUserById(String contextid, String userid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("userId", userid);
        return this.api.callApi("users", "view", "getUserById", map);
    }

    public ApiResponse getAuthenticationCredentialsConfigParams(String contextid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        return this.api.callApi("users", "view", "getAuthenticationCredentialsConfigParams", map);
    }

    public ApiResponse getAuthenticationCredentials(String contextid, String userid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("userId", userid);
        return this.api.callApi("users", "view", "getAuthenticationCredentials", map);
    }

    public ApiResponse getAuthenticationState(String contextid, String userid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("userId", userid);
        return this.api.callApi("users", "view", "getAuthenticationState", map);
    }

    public ApiResponse getAuthenticationSession(String contextid, String userid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("userId", userid);
        return this.api.callApi("users", "view", "getAuthenticationSession", map);
    }

    public ApiResponse newUser(String contextid, String name) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("name", name);
        return this.api.callApi("users", "action", "newUser", map);
    }

    public ApiResponse removeUser(String contextid, String userid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("userId", userid);
        return this.api.callApi("users", "action", "removeUser", map);
    }

    public ApiResponse setUserEnabled(String contextid, String userid, String enabled) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("userId", userid);
        map.put("enabled", enabled);
        return this.api.callApi("users", "action", "setUserEnabled", map);
    }

    public ApiResponse setUserName(String contextid, String userid, String name) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("userId", userid);
        map.put("name", name);
        return this.api.callApi("users", "action", "setUserName", map);
    }

    public ApiResponse setAuthenticationCredentials(String contextid, String userid, String authcredentialsconfigparams) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("userId", userid);
        if (authcredentialsconfigparams != null) {
            map.put("authCredentialsConfigParams", authcredentialsconfigparams);
        }
        return this.api.callApi("users", "action", "setAuthenticationCredentials", map);
    }

    public ApiResponse authenticateAsUser(String contextid, String userid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("userId", userid);
        return this.api.callApi("users", "action", "authenticateAsUser", map);
    }

    public ApiResponse pollAsUser(String contextid, String userid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("userId", userid);
        return this.api.callApi("users", "action", "pollAsUser", map);
    }

    public ApiResponse setAuthenticationState(String contextid, String userid, String lastpollresult, String lastpolltimeinms, String requestssincelastpoll) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("userId", userid);
        if (lastpollresult != null) {
            map.put("lastPollResult", lastpollresult);
        }
        if (lastpolltimeinms != null) {
            map.put("lastPollTimeInMs", lastpolltimeinms);
        }
        if (requestssincelastpoll != null) {
            map.put("requestsSinceLastPoll", requestssincelastpoll);
        }
        return this.api.callApi("users", "action", "setAuthenticationState", map);
    }

    public ApiResponse setCookie(String contextid, String userid, String domain, String name, String value, String path, String secure) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contextId", contextid);
        map.put("userId", userid);
        map.put("domain", domain);
        map.put("name", name);
        map.put("value", value);
        if (path != null) {
            map.put("path", path);
        }
        if (secure != null) {
            map.put("secure", secure);
        }
        return this.api.callApi("users", "action", "setCookie", map);
    }
}

