/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.fields;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.xBaseJ.DBF;
import org.xBaseJ.Util;
import org.xBaseJ.xBaseJException;

public abstract class Field
implements Cloneable,
Externalizable {
    public String Name;
    public int Length = 0;
    public byte[] buffer;
    public boolean Deleted;
    public ByteBuffer bytebuffer;
    public long myoffset;
    public static String otherValidCharacters = null;

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.Name = in.readUTF();
        this.Length = in.readInt();
        in.readFully(this.buffer);
        this.Deleted = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.Name);
        out.writeInt(this.Length);
        out.write(this.buffer);
        out.writeBoolean(this.Deleted);
    }

    public Object clone() throws CloneNotSupportedException {
        Field tField = (Field)super.clone();
        tField.Name = new String(this.Name);
        tField.Length = this.Length;
        return tField;
    }

    private void validateName(String iName) throws xBaseJException {
        if (otherValidCharacters == null) {
            try {
                otherValidCharacters = Util.getxBaseJProperty("otherValidCharactersInFieldNames");
            }
            catch (IOException e) {
                otherValidCharacters = "";
            }
            if (otherValidCharacters == null) {
                otherValidCharacters = "";
            }
        }
        if (iName == null) {
            throw new xBaseJException("Missing field name");
        }
        if (iName.length() == 0) {
            throw new xBaseJException("Missing field name");
        }
        if (iName.length() > 10) {
            throw new xBaseJException("Invalid field name " + iName);
        }
        for (int i = 0; i < iName.length(); ++i) {
            if (Character.isLetter(iName.charAt(i)) || Character.isDigit(iName.charAt(i)) || iName.charAt(i) == '_' || otherValidCharacters.indexOf(iName.charAt(i)) > -1) continue;
            throw new xBaseJException("Invalid field name " + iName + ", character invalid at " + i);
        }
    }

    public Field() {
        int tlength = this.Length == 0 ? 1 : this.Length;
        this.buffer = new byte[tlength];
        this.buffer[0] = 32;
    }

    public void setField(String iName, int iLength, ByteBuffer inbuffer) throws xBaseJException {
        this.Name = iName.trim();
        this.validateName(this.Name);
        this.Length = iLength;
        this.setBuffer(inbuffer);
    }

    public void setBuffer(ByteBuffer inBuffer) {
        this.bytebuffer = inBuffer;
        this.setBufferSpace();
    }

    public void setBufferSpace() {
        this.buffer = new byte[this.Length];
    }

    public String getName() {
        return this.Name;
    }

    public int getLength() {
        return this.Length;
    }

    public abstract char getType();

    public int getDecimalPositionCount() {
        return 0;
    }

    public void read() throws IOException, xBaseJException {
        this.bytebuffer.get(this.buffer);
    }

    public String get() {
        String s;
        int k;
        for (k = 0; k < this.Length && this.buffer[k] != 0; ++k) {
        }
        if (k == 0) {
            return "";
        }
        try {
            s = new String(this.buffer, 0, k, DBF.encodedType);
        }
        catch (UnsupportedEncodingException UEE) {
            s = new String(this.buffer, 0, k);
        }
        return s;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    public void write() throws IOException, xBaseJException {
        this.bytebuffer.put(this.buffer);
    }

    public void update() throws IOException, xBaseJException {
        this.bytebuffer.put(this.buffer);
    }

    public void put(String inValue) throws xBaseJException {
        byte[] b;
        if (inValue.length() > this.Length) {
            throw new xBaseJException("Field length too long");
        }
        int i = Math.min(inValue.length(), this.Length);
        try {
            b = inValue.getBytes(DBF.encodedType);
        }
        catch (UnsupportedEncodingException UEE) {
            b = inValue.getBytes();
        }
        for (i = 0; i < b.length; ++i) {
            this.buffer[i] = b[i];
        }
        int fill = Util.fieldFilledWithSpaces() ? 32 : 0;
        for (i = inValue.length(); i < this.Length; ++i) {
            this.buffer[i] = fill;
        }
    }

    public void put(byte[] inValue) throws xBaseJException {
        int i;
        if (inValue.length > this.Length) {
            throw new xBaseJException("Field length too long");
        }
        for (i = 0; i < inValue.length; ++i) {
            this.buffer[i] = inValue[i];
        }
        while (i < this.Length) {
            this.buffer[i] = Util.fieldFilledWithSpaces() ? 32 : 0;
            ++i;
        }
    }
}

