/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import wiremock.org.eclipse.jetty.server.HttpStream;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.util.ExceptionUtil;

public class CompletionStreamWrapper
extends HttpStream.Wrapper {
    private final List<Consumer<Throwable>> _listeners = new ArrayList<Consumer<Throwable>>();

    public CompletionStreamWrapper(HttpStream stream, Consumer<Throwable> listener) {
        super(stream);
        this._listeners.add(listener);
    }

    @Override
    public void succeeded() {
        if (Request.LOG.isDebugEnabled()) {
            Request.LOG.debug("succeeded {}", (Object)this);
        }
        this.onCompletion(null);
        super.succeeded();
    }

    @Override
    public void failed(Throwable x) {
        if (Request.LOG.isDebugEnabled()) {
            Request.LOG.debug("failed {}", (Object)this, (Object)x);
        }
        this.onCompletion(x);
        super.failed(x);
    }

    public HttpStream addListener(Consumer<Throwable> listener) {
        this._listeners.add(listener);
        return this;
    }

    private void onCompletion(Throwable x) {
        int i2 = this._listeners.size();
        while (i2-- > 0) {
            Consumer<Throwable> r = this._listeners.get(i2);
            try {
                r.accept(x);
            }
            catch (Throwable t) {
                ExceptionUtil.addSuppressedIfNotAssociated(x, t);
                Request.LOG.warn("{} threw", (Object)r, (Object)t);
            }
        }
    }
}

