/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server.handler.jmx;

import java.util.Map;
import java.util.TreeMap;
import wiremock.org.eclipse.jetty.server.handler.ContextHandler;
import wiremock.org.eclipse.jetty.server.jmx.Handler;
import wiremock.org.eclipse.jetty.util.annotation.ManagedAttribute;
import wiremock.org.eclipse.jetty.util.annotation.ManagedObject;
import wiremock.org.eclipse.jetty.util.annotation.ManagedOperation;
import wiremock.org.eclipse.jetty.util.annotation.Name;

@ManagedObject(value="ContextHandler mbean wrapper")
public class ContextHandlerMBean
extends Handler.AbstractMBean {
    public ContextHandlerMBean(Object managedObject) {
        super(managedObject);
    }

    @Override
    public ContextHandler getManagedObject() {
        return (ContextHandler)super.getManagedObject();
    }

    @ManagedAttribute(value="Map of context attributes")
    public Map<String, String> getContextAttributes() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        ContextHandler.ScopedContext context = this.getManagedObject().getContext();
        for (String name : context.getAttributeNameSet()) {
            map.put(name, String.valueOf(context.getAttribute(name)));
        }
        return map;
    }

    @ManagedOperation(value="Set context attribute", impact="ACTION")
    public void setContextAttribute(@Name(value="name", description="attribute name") String name, @Name(value="value", description="attribute value") Object value) {
        this.getManagedObject().getContext().setAttribute(name, value);
    }

    @ManagedOperation(value="Set context attribute", impact="ACTION")
    public void setContextAttribute(@Name(value="name", description="attribute name") String name, @Name(value="value", description="attribute value") String value) {
        this.getManagedObject().getContext().setAttribute(name, value);
    }

    @ManagedOperation(value="Remove context attribute", impact="ACTION")
    public void removeContextAttribute(@Name(value="name", description="attribute name") String name) {
        this.getManagedObject().getContext().removeAttribute(name);
    }
}

