/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server;

import java.util.Objects;
import wiremock.org.eclipse.jetty.server.AliasCheck;
import wiremock.org.eclipse.jetty.util.component.AbstractLifeCycle;
import wiremock.org.eclipse.jetty.util.resource.Resource;

public class TrailingSlashAliasChecker
extends AbstractLifeCycle
implements AliasCheck {
    @Override
    public boolean checkAlias(String pathInContext, Resource resource) {
        String uri = resource.getURI().toString();
        if (uri.isEmpty()) {
            return false;
        }
        String realUri = resource.getRealURI().toString();
        if (uri.endsWith("/") && !realUri.endsWith("/")) {
            return Objects.equals(uri.substring(0, uri.length() - 1), realUri);
        }
        return false;
    }
}

