/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.impl.cookie;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import wiremock.org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import wiremock.org.apache.hc.client5.http.cookie.Cookie;
import wiremock.org.apache.hc.client5.http.cookie.CookieOrigin;
import wiremock.org.apache.hc.client5.http.cookie.MalformedCookieException;
import wiremock.org.apache.hc.client5.http.cookie.SetCookie;
import wiremock.org.apache.hc.client5.http.psl.PublicSuffixList;
import wiremock.org.apache.hc.client5.http.psl.PublicSuffixMatcher;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.util.Args;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public class PublicSuffixDomainFilter
implements CommonCookieAttributeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PublicSuffixDomainFilter.class);
    private final CommonCookieAttributeHandler handler;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private final Map<String, Boolean> localDomainMap;

    private static Map<String, Boolean> createLocalDomainMap() {
        ConcurrentHashMap<String, Boolean> map = new ConcurrentHashMap<String, Boolean>();
        map.put(".localhost.", Boolean.TRUE);
        map.put(".test.", Boolean.TRUE);
        map.put(".local.", Boolean.TRUE);
        map.put(".local", Boolean.TRUE);
        map.put(".localdomain", Boolean.TRUE);
        return map;
    }

    public PublicSuffixDomainFilter(CommonCookieAttributeHandler handler, PublicSuffixMatcher publicSuffixMatcher) {
        this.handler = Args.notNull(handler, "Cookie handler");
        this.publicSuffixMatcher = Args.notNull(publicSuffixMatcher, "Public suffix matcher");
        this.localDomainMap = PublicSuffixDomainFilter.createLocalDomainMap();
    }

    public PublicSuffixDomainFilter(CommonCookieAttributeHandler handler, PublicSuffixList suffixList) {
        Args.notNull(handler, "Cookie handler");
        Args.notNull(suffixList, "Public suffix list");
        this.handler = handler;
        this.publicSuffixMatcher = new PublicSuffixMatcher(suffixList.getRules(), suffixList.getExceptions());
        this.localDomainMap = PublicSuffixDomainFilter.createLocalDomainMap();
    }

    private boolean verifyHost(String host) {
        if (this.publicSuffixMatcher.verify(host)) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Public Suffix List verification failed for host '{}'", (Object)host);
        }
        return false;
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        String domain;
        String host = cookie.getDomain();
        if (host == null) {
            return false;
        }
        int i2 = host.indexOf(46);
        if (i2 >= 0 ? !this.localDomainMap.containsKey(domain = host.substring(i2)) && !this.verifyHost(host) : !host.equalsIgnoreCase(origin.getHost()) && !this.verifyHost(host)) {
            return false;
        }
        return this.handler.match(cookie, origin);
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        this.handler.parse(cookie, value);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        this.handler.validate(cookie, origin);
    }

    @Override
    public String getAttributeName() {
        return this.handler.getAttributeName();
    }

    public static CommonCookieAttributeHandler decorate(CommonCookieAttributeHandler handler, PublicSuffixMatcher publicSuffixMatcher) {
        Args.notNull(handler, "Cookie attribute handler");
        return publicSuffixMatcher != null ? new PublicSuffixDomainFilter(handler, publicSuffixMatcher) : handler;
    }
}

