/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.commons.text.similarity;

import java.util.Arrays;
import wiremock.org.apache.commons.text.similarity.EditDistance;
import wiremock.org.apache.commons.text.similarity.SimilarityInput;

public class LevenshteinDistance
implements EditDistance<Integer> {
    private static final LevenshteinDistance INSTANCE = new LevenshteinDistance();
    private final Integer threshold;

    public static LevenshteinDistance getDefaultInstance() {
        return INSTANCE;
    }

    private static <E> int limitedCompare(SimilarityInput<E> left, SimilarityInput<E> right, int threshold) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        if (threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n = left.length();
        int m = right.length();
        if (n == 0) {
            return m <= threshold ? m : -1;
        }
        if (m == 0) {
            return n <= threshold ? n : -1;
        }
        if (n > m) {
            SimilarityInput<E> tmp = left;
            left = right;
            right = tmp;
            n = m;
            m = right.length();
        }
        if (m - n > threshold) {
            return -1;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        int boundary = Math.min(n, threshold) + 1;
        for (int i2 = 0; i2 < boundary; ++i2) {
            p[i2] = i2;
        }
        Arrays.fill(p, boundary, p.length, Integer.MAX_VALUE);
        Arrays.fill(d, Integer.MAX_VALUE);
        for (int j = 1; j <= m; ++j) {
            int max;
            E rightJ = right.at(j - 1);
            d[0] = j;
            int min = Math.max(1, j - threshold);
            int n2 = max = j > Integer.MAX_VALUE - threshold ? n : Math.min(n, j + threshold);
            if (min > 1) {
                d[min - 1] = Integer.MAX_VALUE;
            }
            int lowerBound = Integer.MAX_VALUE;
            for (int i3 = min; i3 <= max; ++i3) {
                d[i3] = left.at(i3 - 1).equals(rightJ) ? p[i3 - 1] : 1 + Math.min(Math.min(d[i3 - 1], p[i3]), p[i3 - 1]);
                lowerBound = Math.min(lowerBound, d[i3]);
            }
            if (lowerBound > threshold) {
                return -1;
            }
            int[] tempD = p;
            p = d;
            d = tempD;
        }
        if (p[n] <= threshold) {
            return p[n];
        }
        return -1;
    }

    private static <E> int unlimitedCompare(SimilarityInput<E> left, SimilarityInput<E> right) {
        int i2;
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        int n = left.length();
        int m = right.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            SimilarityInput<E> tmp = left;
            left = right;
            right = tmp;
            n = m;
            m = right.length();
        }
        int[] p = new int[n + 1];
        for (i2 = 0; i2 <= n; ++i2) {
            p[i2] = i2;
        }
        for (int j = 1; j <= m; ++j) {
            int upperLeft = p[0];
            E rightJ = right.at(j - 1);
            p[0] = j;
            for (i2 = 1; i2 <= n; ++i2) {
                int upper = p[i2];
                int cost = left.at(i2 - 1).equals(rightJ) ? 0 : 1;
                p[i2] = Math.min(Math.min(p[i2 - 1] + 1, p[i2] + 1), upperLeft + cost);
                upperLeft = upper;
            }
        }
        return p[n];
    }

    @Deprecated
    public LevenshteinDistance() {
        this(null);
    }

    public LevenshteinDistance(Integer threshold) {
        if (threshold != null && threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        this.threshold = threshold;
    }

    @Override
    public Integer apply(CharSequence left, CharSequence right) {
        return this.apply(SimilarityInput.input(left), SimilarityInput.input(right));
    }

    @Override
    public <E> Integer apply(SimilarityInput<E> left, SimilarityInput<E> right) {
        if (this.threshold != null) {
            return LevenshteinDistance.limitedCompare(left, right, this.threshold);
        }
        return LevenshteinDistance.unlimitedCompare(left, right);
    }

    public Integer getThreshold() {
        return this.threshold;
    }
}

