/*
 * Decompiled with CFR 0.152.
 */
package wiremock.jakarta.servlet;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.ResourceBundle;
import wiremock.jakarta.servlet.WriteListener;

public abstract class ServletOutputStream
extends OutputStream {
    private static final String LSTRING_FILE = "wiremock.jakarta.servlet.LocalStrings";
    private static final ResourceBundle lStrings = ResourceBundle.getBundle("wiremock.jakarta.servlet.LocalStrings");

    protected ServletOutputStream() {
    }

    public void write(ByteBuffer buffer) throws IOException {
        Objects.requireNonNull(buffer);
        if (!this.isReady()) {
            throw new IllegalStateException();
        }
        if (buffer.remaining() == 0) {
            return;
        }
        byte[] b = new byte[buffer.remaining()];
        buffer.get(b);
        this.write(b);
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        int len = s.length();
        byte[] out = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            char c = s.charAt(i2);
            if ((c & 0xFF00) != 0) {
                String errMsg = lStrings.getString("err.not_iso8859_1");
                Object[] errArgs = new Object[]{Character.valueOf(c)};
                errMsg = MessageFormat.format(errMsg, errArgs);
                throw new CharConversionException(errMsg);
            }
            out[i2] = (byte)(0xFF & c);
        }
        this.write(out, 0, len);
    }

    public void print(boolean b) throws IOException {
        this.print(lStrings.getString(b ? "value.true" : "value.false"));
    }

    public void print(char c) throws IOException {
        this.print(String.valueOf(c));
    }

    public void print(int i2) throws IOException {
        this.print(String.valueOf(i2));
    }

    public void print(long l) throws IOException {
        this.print(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public void println() throws IOException {
        this.print("\r\n");
    }

    public void println(String s) throws IOException {
        this.print((String)(s == null ? "null\r\n" : s + "\r\n"));
    }

    public void println(boolean b) throws IOException {
        this.println(lStrings.getString(b ? "value.true" : "value.false"));
    }

    public void println(char c) throws IOException {
        this.println(String.valueOf(c));
    }

    public void println(int i2) throws IOException {
        this.println(String.valueOf(i2));
    }

    public void println(long l) throws IOException {
        this.println(String.valueOf(l));
    }

    public void println(float f) throws IOException {
        this.println(String.valueOf(f));
    }

    public void println(double d) throws IOException {
        this.println(String.valueOf(d));
    }

    public abstract boolean isReady();

    public abstract void setWriteListener(WriteListener var1);

    @Override
    public void close() throws IOException {
        super.close();
    }
}

