/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonType;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.TypeFactory;
import wiremock.com.networknt.schema.TypeValidator;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class UnionTypeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnionTypeValidator.class);
    private final List<JsonValidator> schemas;
    private final String error;

    public UnionTypeValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.TYPE, validationContext);
        StringBuilder errorBuilder = new StringBuilder();
        String sep = "";
        errorBuilder.append('[');
        if (!schemaNode.isArray()) {
            throw new JsonSchemaException("Expected array for type property on Union Type Definition.");
        }
        int i2 = 0;
        this.schemas = new ArrayList<JsonValidator>(schemaNode.size());
        for (JsonNode n : schemaNode) {
            JsonType t = TypeFactory.getSchemaNodeType(n);
            errorBuilder.append(sep).append((Object)t);
            sep = ", ";
            if (n.isObject()) {
                this.schemas.add(validationContext.newSchema(schemaLocation.append(ValidatorTypeCode.TYPE.getValue()), evaluationPath.append(ValidatorTypeCode.TRUE.getValue()), n, parentSchema));
            } else {
                this.schemas.add(new TypeValidator(schemaLocation.append(i2), evaluationPath.append(i2), n, parentSchema, validationContext));
            }
            ++i2;
        }
        errorBuilder.append(']');
        this.error = errorBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        UnionTypeValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        boolean valid = false;
        boolean failFast = executionContext.isFailFast();
        try {
            executionContext.setFailFast(false);
            for (JsonValidator schema : this.schemas) {
                Set<ValidationMessage> errors = schema.validate(executionContext, node, rootNode, instanceLocation);
                if (errors != null && !errors.isEmpty()) continue;
                valid = true;
                break;
            }
        }
        finally {
            executionContext.setFailFast(failFast);
        }
        if (!valid) {
            return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).type("type")).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(nodeType.toString(), this.error)).build());
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        for (JsonValidator validator : this.schemas) {
            validator.preloadJsonSchema();
        }
    }

    @Override
    public String getKeyword() {
        return "type";
    }
}

