/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.node.ArrayNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaRef;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.annotation.JsonNodeAnnotation;
import wiremock.com.networknt.schema.utils.JsonSchemaRefs;
import wiremock.com.networknt.schema.utils.SetView;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class PrefixItemsValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(PrefixItemsValidator.class);
    private final List<JsonSchema> tupleSchema;
    private Boolean hasUnevaluatedItemsValidator = null;

    public PrefixItemsValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.PREFIX_ITEMS, validationContext);
        if (schemaNode instanceof ArrayNode && !schemaNode.isEmpty()) {
            int i2 = 0;
            this.tupleSchema = new ArrayList<JsonSchema>(schemaNode.size());
            for (JsonNode s : schemaNode) {
                this.tupleSchema.add(validationContext.newSchema(schemaLocation.append(i2), evaluationPath.append(i2), s, parentSchema));
                ++i2;
            }
        } else {
            throw new IllegalArgumentException("The value of 'prefixItems' MUST be a non-empty array of valid JSON Schemas.");
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        PrefixItemsValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        if (node.isArray()) {
            SetView<ValidationMessage> errors = null;
            int count = Math.min(node.size(), this.tupleSchema.size());
            for (int i2 = 0; i2 < count; ++i2) {
                JsonNodePath path = instanceLocation.append(i2);
                Set<ValidationMessage> results = this.tupleSchema.get(i2).validate(executionContext, node.get(i2), rootNode, path);
                if (results.isEmpty()) continue;
                if (errors == null) {
                    errors = new SetView<ValidationMessage>();
                }
                errors.union(results);
            }
            if (this.collectAnnotations() || this.collectAnnotations(executionContext)) {
                int schemas;
                int items = node.isArray() ? node.size() : 1;
                if (items > (schemas = this.tupleSchema.size())) {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(schemas).build());
                } else {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
                }
            }
            return errors == null || errors.isEmpty() ? Collections.emptySet() : errors;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (node instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)node;
            int count = this.tupleSchema.size();
            for (int i2 = 0; i2 < count; ++i2) {
                JsonNode n = node.get(i2);
                if (this.validationContext.getConfig().getApplyDefaultsStrategy().shouldApplyArrayDefaults()) {
                    JsonNode defaultNode = PrefixItemsValidator.getDefaultNode(this.tupleSchema.get(i2));
                    if (n != null && n.isNull() && defaultNode != null) {
                        array.set(i2, defaultNode);
                        n = defaultNode;
                    }
                }
                this.doWalk(executionContext, validationMessages, i2, n, rootNode, instanceLocation, shouldValidateSchema);
            }
            if (this.collectAnnotations() || this.collectAnnotations(executionContext)) {
                int schemas;
                int items = node.isArray() ? node.size() : 1;
                if (items > (schemas = this.tupleSchema.size())) {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(schemas).build());
                } else {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword(this.getKeyword()).value(true).build());
                }
            }
        } else {
            int count = this.tupleSchema.size();
            for (int i3 = 0; i3 < count; ++i3) {
                this.doWalk(executionContext, validationMessages, i3, null, rootNode, instanceLocation, shouldValidateSchema);
            }
        }
        return validationMessages;
    }

    private static JsonNode getDefaultNode(JsonSchema schema) {
        JsonSchemaRef schemaRef;
        JsonNode result = schema.getSchemaNode().get("default");
        if (result == null && (schemaRef = JsonSchemaRefs.from(schema)) != null) {
            result = PrefixItemsValidator.getDefaultNode(schemaRef.getSchema());
        }
        return result;
    }

    private void doWalk(ExecutionContext executionContext, Set<ValidationMessage> validationMessages, int i2, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        this.walkSchema(executionContext, this.tupleSchema.get(i2), node, rootNode, instanceLocation.append(i2), shouldValidateSchema, validationMessages);
    }

    private void walkSchema(ExecutionContext executionContext, JsonSchema walkSchema, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema, Set<ValidationMessage> validationMessages) {
        boolean executeWalk = this.validationContext.getConfig().getItemWalkListenerRunner().runPreWalkListeners(executionContext, ValidatorTypeCode.PREFIX_ITEMS.getValue(), node, rootNode, instanceLocation, walkSchema, this);
        if (executeWalk) {
            validationMessages.addAll(walkSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema));
        }
        this.validationContext.getConfig().getItemWalkListenerRunner().runPostWalkListeners(executionContext, ValidatorTypeCode.PREFIX_ITEMS.getValue(), node, rootNode, instanceLocation, walkSchema, this, validationMessages);
    }

    public List<JsonSchema> getTupleSchema() {
        return this.tupleSchema;
    }

    private boolean collectAnnotations() {
        return this.hasUnevaluatedItemsValidator();
    }

    private boolean hasUnevaluatedItemsValidator() {
        if (this.hasUnevaluatedItemsValidator == null) {
            this.hasUnevaluatedItemsValidator = this.hasAdjacentKeywordInEvaluationPath("unevaluatedItems");
        }
        return this.hasUnevaluatedItemsValidator;
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.tupleSchema);
        this.collectAnnotations();
    }
}

