/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath.internal.filter;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import wiremock.com.jayway.jsonpath.Configuration;
import wiremock.com.jayway.jsonpath.JsonPathException;
import wiremock.com.jayway.jsonpath.Option;
import wiremock.com.jayway.jsonpath.PathNotFoundException;
import wiremock.com.jayway.jsonpath.Predicate;
import wiremock.com.jayway.jsonpath.internal.Path;
import wiremock.com.jayway.jsonpath.internal.Utils;
import wiremock.com.jayway.jsonpath.internal.filter.PatternFlag;
import wiremock.com.jayway.jsonpath.internal.filter.ValueNode;
import wiremock.com.jayway.jsonpath.internal.path.PathCompiler;
import wiremock.com.jayway.jsonpath.internal.path.PredicateContextImpl;
import wiremock.com.jayway.jsonpath.spi.json.JsonProvider;
import wiremock.net.minidev.json.parser.JSONParser;
import wiremock.net.minidev.json.parser.ParseException;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public interface ValueNodes {
    public static final NullNode NULL_NODE = new NullNode();
    public static final BooleanNode TRUE = new BooleanNode("true");
    public static final BooleanNode FALSE = new BooleanNode("false");
    public static final UndefinedNode UNDEFINED = new UndefinedNode();

    public static class PathNode
    extends ValueNode {
        private static final Logger logger = LoggerFactory.getLogger(PathNode.class);
        private final Path path;
        private final boolean existsCheck;
        private final boolean shouldExist;

        PathNode(Path path) {
            this(path, false, false);
        }

        PathNode(CharSequence charSequence, boolean existsCheck, boolean shouldExist) {
            this(PathCompiler.compile(charSequence.toString(), new Predicate[0]), existsCheck, shouldExist);
        }

        PathNode(Path path, boolean existsCheck, boolean shouldExist) {
            this.path = path;
            this.existsCheck = existsCheck;
            this.shouldExist = shouldExist;
            logger.trace("PathNode {} existsCheck: {}", (Object)path, (Object)existsCheck);
        }

        public Path getPath() {
            return this.path;
        }

        public boolean isExistsCheck() {
            return this.existsCheck;
        }

        public boolean shouldExists() {
            return this.shouldExist;
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Void.class;
        }

        @Override
        public boolean isPathNode() {
            return true;
        }

        @Override
        public PathNode asPathNode() {
            return this;
        }

        public PathNode asExistsCheck(boolean shouldExist) {
            return new PathNode(this.path, true, shouldExist);
        }

        public String toString() {
            return this.existsCheck && !this.shouldExist ? Utils.concat("!", this.path.toString()) : this.path.toString();
        }

        public ValueNode evaluate(Predicate.PredicateContext ctx) {
            if (this.isExistsCheck()) {
                try {
                    Configuration c = Configuration.builder().jsonProvider(ctx.configuration().jsonProvider()).options(Option.REQUIRE_PROPERTIES).build();
                    Object result = this.path.evaluate(ctx.item(), ctx.root(), c).getValue(false);
                    return result == JsonProvider.UNDEFINED ? FALSE : TRUE;
                }
                catch (PathNotFoundException e) {
                    return FALSE;
                }
            }
            try {
                Object res;
                if (ctx instanceof PredicateContextImpl) {
                    PredicateContextImpl ctxi = (PredicateContextImpl)ctx;
                    res = ctxi.evaluate(this.path);
                } else {
                    Object doc = this.path.isRootPath() ? ctx.root() : ctx.item();
                    res = this.path.evaluate(doc, ctx.root(), ctx.configuration()).getValue();
                }
                res = ctx.configuration().jsonProvider().unwrap(res);
                if (res instanceof Number) {
                    return ValueNode.createNumberNode(res.toString());
                }
                if (res instanceof String) {
                    return ValueNode.createStringNode(res.toString(), false);
                }
                if (res instanceof Boolean) {
                    return ValueNode.createBooleanNode(res.toString());
                }
                if (res instanceof OffsetDateTime) {
                    return ValueNode.createOffsetDateTimeNode(res.toString());
                }
                if (res == null) {
                    return NULL_NODE;
                }
                if (ctx.configuration().jsonProvider().isArray(res)) {
                    return ValueNode.createJsonNode(ctx.configuration().mappingProvider().map(res, List.class, ctx.configuration()));
                }
                if (ctx.configuration().jsonProvider().isMap(res)) {
                    return ValueNode.createJsonNode(ctx.configuration().mappingProvider().map(res, Map.class, ctx.configuration()));
                }
                throw new JsonPathException("Could not convert " + res.getClass().toString() + ":" + res.toString() + " to a ValueNode");
            }
            catch (PathNotFoundException e) {
                return UNDEFINED;
            }
        }
    }

    public static class ValueListNode
    extends ValueNode
    implements Iterable<ValueNode> {
        private List<ValueNode> nodes = new ArrayList<ValueNode>();

        public ValueListNode(Collection<?> values) {
            for (Object value : values) {
                this.nodes.add(ValueListNode.toValueNode(value));
            }
        }

        public boolean contains(ValueNode node) {
            return this.nodes.contains(node);
        }

        public boolean subsetof(ValueListNode right) {
            for (ValueNode leftNode : this.nodes) {
                if (right.nodes.contains(leftNode)) continue;
                return false;
            }
            return true;
        }

        public List<ValueNode> getNodes() {
            return Collections.unmodifiableList(this.nodes);
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return List.class;
        }

        @Override
        public boolean isValueListNode() {
            return true;
        }

        @Override
        public ValueListNode asValueListNode() {
            return this;
        }

        public String toString() {
            return "[" + Utils.join(",", this.nodes) + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValueListNode)) {
                return false;
            }
            ValueListNode that = (ValueListNode)o;
            return this.nodes.equals(that.nodes);
        }

        @Override
        public Iterator<ValueNode> iterator() {
            return this.nodes.iterator();
        }
    }

    public static class PredicateNode
    extends ValueNode {
        private final Predicate predicate;

        public PredicateNode(Predicate predicate) {
            this.predicate = predicate;
        }

        public Predicate getPredicate() {
            return this.predicate;
        }

        @Override
        public PredicateNode asPredicateNode() {
            return this;
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Void.class;
        }

        @Override
        public boolean isPredicateNode() {
            return true;
        }

        public boolean equals(Object o) {
            return false;
        }

        public String toString() {
            return this.predicate.toString();
        }
    }

    public static class UndefinedNode
    extends ValueNode {
        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Void.class;
        }

        @Override
        public UndefinedNode asUndefinedNode() {
            return this;
        }

        @Override
        public boolean isUndefinedNode() {
            return true;
        }

        public boolean equals(Object o) {
            return false;
        }
    }

    public static class NullNode
    extends ValueNode {
        private NullNode() {
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Void.class;
        }

        @Override
        public boolean isNullNode() {
            return true;
        }

        @Override
        public NullNode asNullNode() {
            return this;
        }

        public String toString() {
            return "null";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof NullNode;
        }
    }

    public static class ClassNode
    extends ValueNode {
        private final Class clazz;

        ClassNode(Class clazz) {
            this.clazz = clazz;
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Class.class;
        }

        @Override
        public boolean isClassNode() {
            return true;
        }

        @Override
        public ClassNode asClassNode() {
            return this;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public String toString() {
            return this.clazz.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassNode)) {
                return false;
            }
            ClassNode that = (ClassNode)o;
            return !(this.clazz == null ? that.clazz != null : !this.clazz.equals(that.clazz));
        }
    }

    public static class BooleanNode
    extends ValueNode {
        private final Boolean value;

        private BooleanNode(CharSequence boolValue) {
            this.value = Boolean.parseBoolean(boolValue.toString());
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Boolean.class;
        }

        @Override
        public boolean isBooleanNode() {
            return true;
        }

        @Override
        public BooleanNode asBooleanNode() {
            return this;
        }

        public boolean getBoolean() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BooleanNode)) {
                return false;
            }
            BooleanNode that = (BooleanNode)o;
            return !(this.value == null ? that.value != null : !this.value.equals(that.value));
        }
    }

    public static class OffsetDateTimeNode
    extends ValueNode {
        private final OffsetDateTime dateTime;

        OffsetDateTimeNode(OffsetDateTime dateTime) {
            this.dateTime = dateTime;
        }

        OffsetDateTimeNode(CharSequence date) {
            this.dateTime = OffsetDateTime.parse(date);
        }

        @Override
        public StringNode asStringNode() {
            return new StringNode(this.dateTime.toString(), false);
        }

        public OffsetDateTime getDate() {
            return this.dateTime;
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return OffsetDateTimeNode.class;
        }

        @Override
        public boolean isOffsetDateTimeNode() {
            return true;
        }

        @Override
        public OffsetDateTimeNode asOffsetDateTimeNode() {
            return this;
        }

        public String toString() {
            return this.dateTime.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OffsetDateTimeNode) && !(o instanceof StringNode)) {
                return false;
            }
            OffsetDateTimeNode that = ((ValueNode)o).asOffsetDateTimeNode();
            return this.dateTime.compareTo(that.dateTime) == 0;
        }
    }

    public static class NumberNode
    extends ValueNode {
        public static NumberNode NAN = new NumberNode((BigDecimal)null);
        private final BigDecimal number;

        NumberNode(BigDecimal number) {
            this.number = number;
        }

        NumberNode(CharSequence num) {
            this.number = new BigDecimal(num.toString());
        }

        @Override
        public StringNode asStringNode() {
            return new StringNode(this.number.toString(), false);
        }

        public BigDecimal getNumber() {
            return this.number;
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Number.class;
        }

        @Override
        public boolean isNumberNode() {
            return true;
        }

        @Override
        public NumberNode asNumberNode() {
            return this;
        }

        public String toString() {
            return this.number.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NumberNode) && !(o instanceof StringNode)) {
                return false;
            }
            NumberNode that = ((ValueNode)o).asNumberNode();
            if (that == NAN) {
                return false;
            }
            return this.number.compareTo(that.number) == 0;
        }
    }

    public static class StringNode
    extends ValueNode {
        private final String string;
        private boolean useSingleQuote = true;

        StringNode(CharSequence charSequence, boolean escape) {
            if (escape && charSequence.length() > 1) {
                char open = charSequence.charAt(0);
                char close = charSequence.charAt(charSequence.length() - 1);
                if (open == '\'' && close == '\'') {
                    charSequence = charSequence.subSequence(1, charSequence.length() - 1);
                } else if (open == '\"' && close == '\"') {
                    charSequence = charSequence.subSequence(1, charSequence.length() - 1);
                    this.useSingleQuote = false;
                }
                this.string = Utils.unescape(charSequence.toString());
            } else {
                this.string = charSequence.toString();
            }
        }

        @Override
        public NumberNode asNumberNode() {
            BigDecimal number = null;
            try {
                number = new BigDecimal(this.string);
            }
            catch (NumberFormatException nfe) {
                return NumberNode.NAN;
            }
            return new NumberNode(number);
        }

        public String getString() {
            return this.string;
        }

        public int length() {
            return this.getString().length();
        }

        public boolean isEmpty() {
            return this.getString().isEmpty();
        }

        public boolean contains(String str) {
            return this.getString().contains(str);
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return String.class;
        }

        @Override
        public boolean isStringNode() {
            return true;
        }

        @Override
        public StringNode asStringNode() {
            return this;
        }

        public String toString() {
            String quote = this.useSingleQuote ? "'" : "\"";
            return quote + Utils.escape(this.string, true) + quote;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StringNode) && !(o instanceof NumberNode)) {
                return false;
            }
            StringNode that = ((ValueNode)o).asStringNode();
            return !(this.string == null ? that.getString() != null : !this.string.equals(that.getString()));
        }
    }

    public static class JsonNode
    extends ValueNode {
        private final Object json;
        private final boolean parsed;

        JsonNode(CharSequence charSequence) {
            this.json = charSequence.toString();
            this.parsed = false;
        }

        JsonNode(Object parsedJson) {
            this.json = parsedJson;
            this.parsed = true;
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            if (this.isArray(ctx)) {
                return List.class;
            }
            if (this.isMap(ctx)) {
                return Map.class;
            }
            if (this.parse(ctx) instanceof Number) {
                return Number.class;
            }
            if (this.parse(ctx) instanceof String) {
                return String.class;
            }
            if (this.parse(ctx) instanceof Boolean) {
                return Boolean.class;
            }
            return Void.class;
        }

        @Override
        public boolean isJsonNode() {
            return true;
        }

        @Override
        public JsonNode asJsonNode() {
            return this;
        }

        public ValueNode asValueListNode(Predicate.PredicateContext ctx) {
            if (!this.isArray(ctx)) {
                return UNDEFINED;
            }
            return new ValueListNode(Collections.unmodifiableList((List)this.parse(ctx)));
        }

        public Object parse(Predicate.PredicateContext ctx) {
            try {
                return this.parsed ? this.json : new JSONParser(-1).parse(this.json.toString());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public boolean isParsed() {
            return this.parsed;
        }

        public Object getJson() {
            return this.json;
        }

        public boolean isArray(Predicate.PredicateContext ctx) {
            return this.parse(ctx) instanceof List;
        }

        public boolean isMap(Predicate.PredicateContext ctx) {
            return this.parse(ctx) instanceof Map;
        }

        public int length(Predicate.PredicateContext ctx) {
            return this.isArray(ctx) ? ((List)this.parse(ctx)).size() : -1;
        }

        public boolean isEmpty(Predicate.PredicateContext ctx) {
            if (this.isArray(ctx) || this.isMap(ctx)) {
                return ((Collection)this.parse(ctx)).size() == 0;
            }
            if (this.parse(ctx) instanceof String) {
                return ((String)this.parse(ctx)).length() == 0;
            }
            return true;
        }

        public String toString() {
            return this.json.toString();
        }

        public boolean equals(JsonNode jsonNode, Predicate.PredicateContext ctx) {
            if (this == jsonNode) {
                return true;
            }
            return !(this.json == null ? jsonNode.json != null : !this.json.equals(jsonNode.parse(ctx)));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JsonNode)) {
                return false;
            }
            JsonNode jsonNode = (JsonNode)o;
            return !(this.json == null ? jsonNode.json != null : !this.json.equals(jsonNode.json));
        }
    }

    public static class PatternNode
    extends ValueNode {
        private final String pattern;
        private final Pattern compiledPattern;
        private final String flags;

        PatternNode(CharSequence charSequence) {
            String tmp = charSequence.toString();
            int begin = tmp.indexOf(47);
            int end = tmp.lastIndexOf(47);
            this.pattern = tmp.substring(begin + 1, end);
            int flagsIndex = end + 1;
            this.flags = tmp.length() > flagsIndex ? tmp.substring(flagsIndex) : "";
            this.compiledPattern = Pattern.compile(this.pattern, PatternFlag.parseFlags(this.flags.toCharArray()));
        }

        PatternNode(Pattern pattern) {
            this.pattern = pattern.pattern();
            this.compiledPattern = pattern;
            this.flags = PatternFlag.parseFlags(pattern.flags());
        }

        Pattern getCompiledPattern() {
            return this.compiledPattern;
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Void.TYPE;
        }

        @Override
        public boolean isPatternNode() {
            return true;
        }

        @Override
        public PatternNode asPatternNode() {
            return this;
        }

        public String toString() {
            if (!this.pattern.startsWith("/")) {
                return "/" + this.pattern + "/" + this.flags;
            }
            return this.pattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PatternNode)) {
                return false;
            }
            PatternNode that = (PatternNode)o;
            return !(this.compiledPattern == null ? that.compiledPattern != null : !this.compiledPattern.equals(that.compiledPattern));
        }
    }
}

