/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class TemplatedUrlPath
extends LinkedHashMap<String, String>
implements Iterable<String> {
    private final String originalPath;

    public TemplatedUrlPath(String url, PathParams pathParams) {
        this.originalPath = Urls.getPath(url);
        this.addAllPathSegments();
        this.putAll(pathParams);
    }

    private void addAllPathSegments() {
        List<String> pathSegments = Urls.getPathSegments(this.originalPath);
        int i2 = 0;
        for (String pathNode : pathSegments) {
            if (!Strings.isNotEmpty(pathNode)) continue;
            String key = String.valueOf(i2++);
            this.put(key, pathNode);
        }
    }

    @Override
    public String toString() {
        return this.originalPath;
    }

    @Override
    public Iterator<String> iterator() {
        return Urls.getPathSegments(this.originalPath).iterator();
    }
}

