/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import java.util.List;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import wiremock.com.fasterxml.jackson.core.JsonProcessingException;
import wiremock.com.fasterxml.jackson.databind.JsonMappingException;

public class JsonException
extends InvalidInputException {
    private static final Function<JsonMappingException.Reference, String> TO_NODE_NAMES = input -> input.getFieldName() != null ? input.getFieldName() : String.valueOf(input.getIndex());

    protected JsonException(Errors errors) {
        super(errors);
    }

    public static JsonException fromJackson(JsonProcessingException processingException) {
        Throwable rootCause = JsonException.getRootCause(processingException);
        String message = rootCause.getMessage();
        if (rootCause instanceof PatternSyntaxException) {
            PatternSyntaxException patternSyntaxException = (PatternSyntaxException)rootCause;
            message = patternSyntaxException.getMessage();
        } else if (rootCause instanceof JsonMappingException) {
            message = ((JsonMappingException)rootCause).getOriginalMessage();
        } else if (rootCause instanceof InvalidInputException) {
            message = ((InvalidInputException)rootCause).getErrors().first().getDetail();
        }
        String pointer = null;
        if (processingException instanceof JsonMappingException) {
            List nodes = ((JsonMappingException)processingException).getPath().stream().map(TO_NODE_NAMES).collect(Collectors.toList());
            pointer = "/" + String.join((CharSequence)"/", nodes);
        }
        return new JsonException(Errors.single(10, pointer, "Error parsing JSON", message));
    }

    private static Throwable getRootCause(Throwable e) {
        if (e.getCause() != null) {
            return JsonException.getRootCause(e.getCause());
        }
        return e;
    }
}

