/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.util.Optional;

public class JettySettings {
    private final Integer acceptors;
    private final Integer acceptQueueSize;
    private final Integer requestHeaderSize;
    private final Integer responseHeaderSize;
    private final Long stopTimeout;
    private final Long idleTimeout;
    private final Long shutdownIdleTimeout;

    private JettySettings(Integer acceptors, Integer acceptQueueSize, Integer requestHeaderSize, Integer responseHeaderSize, Long stopTimeout, Long idleTimeout, Long shutdownIdleTimeout) {
        this.acceptors = acceptors;
        this.acceptQueueSize = acceptQueueSize;
        this.requestHeaderSize = requestHeaderSize;
        this.responseHeaderSize = responseHeaderSize;
        this.stopTimeout = stopTimeout;
        this.idleTimeout = idleTimeout;
        this.shutdownIdleTimeout = shutdownIdleTimeout;
    }

    public Optional<Integer> getAcceptors() {
        return Optional.ofNullable(this.acceptors);
    }

    public Optional<Integer> getAcceptQueueSize() {
        return Optional.ofNullable(this.acceptQueueSize);
    }

    public Optional<Integer> getRequestHeaderSize() {
        return Optional.ofNullable(this.requestHeaderSize);
    }

    public Optional<Integer> getResponseHeaderSize() {
        return Optional.ofNullable(this.responseHeaderSize);
    }

    public Optional<Long> getStopTimeout() {
        return Optional.ofNullable(this.stopTimeout);
    }

    public Optional<Long> getIdleTimeout() {
        return Optional.ofNullable(this.idleTimeout);
    }

    public Optional<Long> getShutdownIdleTimeout() {
        return Optional.ofNullable(this.shutdownIdleTimeout);
    }

    public String toString() {
        return "JettySettings{acceptors=" + this.acceptors + ", acceptQueueSize=" + this.acceptQueueSize + ", requestHeaderSize=" + this.requestHeaderSize + ", responseHeaderSize=" + this.responseHeaderSize + ", stopTimeout=" + this.stopTimeout + ", idleTimeout=" + this.idleTimeout + ", shutdownIdleTimeout=" + this.shutdownIdleTimeout + "}";
    }

    public static class Builder {
        private Integer acceptors;
        private Integer acceptQueueSize;
        private Integer requestHeaderSize;
        private Integer responseHeaderSize;
        private Long stopTimeout;
        private Long idleTimeout;
        private Long shutdownIdleTimeout;

        private Builder() {
        }

        public static Builder aJettySettings() {
            return new Builder();
        }

        public Builder withAcceptors(Integer acceptors) {
            this.acceptors = acceptors;
            return this;
        }

        public Builder withAcceptQueueSize(Integer acceptQueueSize) {
            this.acceptQueueSize = acceptQueueSize;
            return this;
        }

        public Builder withRequestHeaderSize(Integer requestHeaderSize) {
            this.requestHeaderSize = requestHeaderSize;
            return this;
        }

        public Builder withResponseHeaderSize(Integer responseHeaderSize) {
            this.responseHeaderSize = responseHeaderSize;
            return this;
        }

        public Builder withStopTimeout(Long stopTimeout) {
            this.stopTimeout = stopTimeout;
            return this;
        }

        public Builder withIdleTimeout(Long idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public Builder withShutdownIdleTimeout(Long shutdownIdleTimeout) {
            this.shutdownIdleTimeout = shutdownIdleTimeout;
            return this;
        }

        public JettySettings build() {
            return new JettySettings(this.acceptors, this.acceptQueueSize, this.requestHeaderSize, this.responseHeaderSize, this.stopTimeout, this.idleTimeout, this.shutdownIdleTimeout);
        }
    }
}

