/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.admin.model.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.admin.model.ServeEventQuery;
import com.github.tomakehurst.wiremock.admin.model.SingleStubMappingResult;
import com.github.tomakehurst.wiremock.client.BasicMappingBuilder;
import com.github.tomakehurst.wiremock.client.CountMatchingStrategy;
import com.github.tomakehurst.wiremock.client.HttpAdminClient;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.client.WireMockBuilder;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.AbsentPattern;
import com.github.tomakehurst.wiremock.matching.AfterDateTimePattern;
import com.github.tomakehurst.wiremock.matching.BeforeDateTimePattern;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.EqualToDateTimePattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.ExactMatchMultiValuePattern;
import com.github.tomakehurst.wiremock.matching.IncludesMatchMultiValuePattern;
import com.github.tomakehurst.wiremock.matching.LogicalAnd;
import com.github.tomakehurst.wiremock.matching.LogicalOr;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import com.github.tomakehurst.wiremock.matching.MatchesJsonSchemaPattern;
import com.github.tomakehurst.wiremock.matching.MatchesXPathPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePatternBuilder;
import com.github.tomakehurst.wiremock.matching.NegativeContainsPattern;
import com.github.tomakehurst.wiremock.matching.NegativeRegexPattern;
import com.github.tomakehurst.wiremock.matching.NotPattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPathTemplatePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.recording.RecordSpec;
import com.github.tomakehurst.wiremock.recording.RecordSpecBuilder;
import com.github.tomakehurst.wiremock.recording.RecordingStatusResult;
import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import com.github.tomakehurst.wiremock.security.ClientAuthenticator;
import com.github.tomakehurst.wiremock.standalone.RemoteMappingsLoader;
import com.github.tomakehurst.wiremock.store.InMemorySettingsStore;
import com.github.tomakehurst.wiremock.store.SettingsStore;
import com.github.tomakehurst.wiremock.stubbing.Scenario;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubImport;
import com.github.tomakehurst.wiremock.stubbing.StubImportBuilder;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.FindNearMissesResult;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import com.github.tomakehurst.wiremock.verification.diff.Diff;
import java.io.File;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import wiremock.com.networknt.schema.SpecVersion;

public class WireMock {
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_HOST = "localhost";
    private final Admin admin;
    private final SettingsStore settingsStore = new InMemorySettingsStore();
    private static InheritableThreadLocal<WireMock> defaultInstance = new InheritableThreadLocal<WireMock>(){

        @Override
        protected WireMock initialValue() {
            return WireMock.create().build();
        }
    };

    public static WireMockBuilder create() {
        return new WireMockBuilder();
    }

    public WireMock(Admin admin) {
        this.admin = admin;
    }

    public WireMock(int port) {
        this(DEFAULT_HOST, port);
    }

    public WireMock(String host, int port) {
        this.admin = new HttpAdminClient(host, port);
    }

    public WireMock(String host, int port, String urlPathPrefix) {
        this.admin = new HttpAdminClient(host, port, urlPathPrefix);
    }

    public WireMock(String scheme, String host, int port) {
        this.admin = new HttpAdminClient(scheme, host, port);
    }

    public WireMock(String scheme, String host) {
        this.admin = new HttpAdminClient(scheme, host);
    }

    public WireMock(String scheme, String host, int port, String urlPathPrefix) {
        this.admin = new HttpAdminClient(scheme, host, port, urlPathPrefix);
    }

    public WireMock(String scheme, String host, int port, String urlPathPrefix, String hostHeader, String proxyHost, int proxyPort, ClientAuthenticator authenticator) {
        this.admin = new HttpAdminClient(scheme, host, port, urlPathPrefix, hostHeader, proxyHost, proxyPort, authenticator);
    }

    public WireMock() {
        this.admin = new HttpAdminClient(DEFAULT_HOST, 8080);
    }

    public static StubMapping givenThat(MappingBuilder mappingBuilder) {
        return ((WireMock)defaultInstance.get()).register(mappingBuilder);
    }

    public static StubMapping stubFor(MappingBuilder mappingBuilder) {
        return WireMock.givenThat(mappingBuilder);
    }

    public static void editStub(MappingBuilder mappingBuilder) {
        ((WireMock)defaultInstance.get()).editStubMapping(mappingBuilder);
    }

    public static void removeStub(MappingBuilder mappingBuilder) {
        ((WireMock)defaultInstance.get()).removeStubMapping(mappingBuilder);
    }

    public static void removeStub(StubMapping stubMapping) {
        ((WireMock)defaultInstance.get()).removeStubMapping(stubMapping);
    }

    public static void removeStub(UUID id) {
        ((WireMock)defaultInstance.get()).removeStubMapping(id);
    }

    public static ListStubMappingsResult listAllStubMappings() {
        return ((WireMock)defaultInstance.get()).allStubMappings();
    }

    public static StubMapping getSingleStubMapping(UUID id) {
        return (StubMapping)((WireMock)defaultInstance.get()).getStubMapping(id).getItem();
    }

    public static void configureFor(int port) {
        defaultInstance.set(WireMock.create().port(port).build());
    }

    public static void configureFor(String host, int port) {
        defaultInstance.set(WireMock.create().host(host).port(port).build());
    }

    public static void configureFor(String host, int port, String urlPathPrefix) {
        defaultInstance.set(WireMock.create().host(host).port(port).urlPathPrefix(urlPathPrefix).build());
    }

    public static void configureFor(String scheme, String host, int port, String urlPathPrefix) {
        defaultInstance.set(WireMock.create().scheme(scheme).host(host).port(port).urlPathPrefix(urlPathPrefix).build());
    }

    public static void configureFor(String scheme, String host, int port) {
        defaultInstance.set(WireMock.create().scheme(scheme).host(host).port(port).build());
    }

    public static void configureFor(String scheme, String host, int port, String proxyHost, int proxyPort) {
        defaultInstance.set(WireMock.create().scheme(scheme).host(host).port(port).urlPathPrefix("").hostHeader(null).proxyHost(proxyHost).proxyPort(proxyPort).build());
    }

    public static void configureFor(WireMock client) {
        defaultInstance.set(client);
    }

    public static void configure() {
        defaultInstance.set(WireMock.create().build());
    }

    public static StringValuePattern equalTo(String value) {
        return new EqualToPattern(value);
    }

    public static BinaryEqualToPattern binaryEqualTo(byte[] content) {
        return new BinaryEqualToPattern(content);
    }

    public static BinaryEqualToPattern binaryEqualTo(String content) {
        return new BinaryEqualToPattern(content);
    }

    public static StringValuePattern equalToIgnoreCase(String value) {
        return new EqualToPattern(value, true);
    }

    public static StringValuePattern equalToJson(String value) {
        return new EqualToJsonPattern(value, null, null);
    }

    public static StringValuePattern equalToJson(String value, boolean ignoreArrayOrder, boolean ignoreExtraElements) {
        return new EqualToJsonPattern(value, (Boolean)ignoreArrayOrder, (Boolean)ignoreExtraElements);
    }

    public static StringValuePattern matchingJsonPath(String value) {
        return new MatchesJsonPathPattern(value);
    }

    public static StringValuePattern matchingJsonPath(String value, StringValuePattern valuePattern) {
        return new MatchesJsonPathPattern(value, valuePattern);
    }

    public static StringValuePattern matchingJsonSchema(String schema) {
        return new MatchesJsonSchemaPattern(schema);
    }

    public static StringValuePattern matchingJsonSchema(String schema, JsonSchemaVersion jsonSchemaVersion) {
        return new MatchesJsonSchemaPattern(schema, jsonSchemaVersion);
    }

    public static EqualToXmlPattern equalToXml(String value) {
        return new EqualToXmlPattern(value);
    }

    public static EqualToXmlPattern equalToXml(String value, EqualToXmlPattern.NamespaceAwareness namespaceAwareness) {
        return new EqualToXmlPattern(value, null, null, null, null, null, namespaceAwareness);
    }

    public static EqualToXmlPattern equalToXml(String value, boolean enablePlaceholders) {
        return WireMock.equalToXml(value, enablePlaceholders, false);
    }

    public static EqualToXmlPattern equalToXml(String value, boolean enablePlaceholders, boolean ignoreOrderOfSameNode) {
        return new EqualToXmlPattern(value, enablePlaceholders, ignoreOrderOfSameNode);
    }

    public static EqualToXmlPattern equalToXml(String value, boolean enablePlaceholders, String placeholderOpeningDelimiterRegex, String placeholderClosingDelimiterRegex) {
        return WireMock.equalToXml(value, enablePlaceholders, placeholderOpeningDelimiterRegex, placeholderClosingDelimiterRegex, false);
    }

    public static EqualToXmlPattern equalToXml(String value, boolean enablePlaceholders, String placeholderOpeningDelimiterRegex, String placeholderClosingDelimiterRegex, boolean ignoreOrderOfSameNode) {
        return WireMock.equalToXml(value, enablePlaceholders, placeholderOpeningDelimiterRegex, placeholderClosingDelimiterRegex, ignoreOrderOfSameNode, null);
    }

    public static EqualToXmlPattern equalToXml(String value, boolean enablePlaceholders, String placeholderOpeningDelimiterRegex, String placeholderClosingDelimiterRegex, boolean ignoreOrderOfSameNode, EqualToXmlPattern.NamespaceAwareness namespaceAwareness) {
        return new EqualToXmlPattern(value, enablePlaceholders, placeholderOpeningDelimiterRegex, placeholderClosingDelimiterRegex, null, ignoreOrderOfSameNode, namespaceAwareness);
    }

    public static MatchesXPathPattern matchingXPath(String value) {
        return new MatchesXPathPattern(value, Collections.emptyMap());
    }

    public static StringValuePattern matchingXPath(String value, Map<String, String> namespaces) {
        return new MatchesXPathPattern(value, namespaces);
    }

    public static StringValuePattern matchingXPath(String value, StringValuePattern valuePattern) {
        return new MatchesXPathPattern(value, valuePattern);
    }

    public static MatchesXPathPattern matchesXPathWithSubMatcher(String value, StringValuePattern valuePattern) {
        return new MatchesXPathPattern(value, valuePattern);
    }

    public static StringValuePattern containing(String value) {
        return new ContainsPattern(value);
    }

    public static StringValuePattern notContaining(String value) {
        return new NegativeContainsPattern(value);
    }

    public static StringValuePattern not(StringValuePattern unexpectedPattern) {
        return new NotPattern(unexpectedPattern);
    }

    public static StringValuePattern matching(String regex) {
        return new RegexPattern(regex);
    }

    public static StringValuePattern notMatching(String regex) {
        return new NegativeRegexPattern(regex);
    }

    public static BeforeDateTimePattern before(String dateTimeSpec) {
        return new BeforeDateTimePattern(dateTimeSpec);
    }

    public static BeforeDateTimePattern before(ZonedDateTime dateTime) {
        return new BeforeDateTimePattern(dateTime);
    }

    public static BeforeDateTimePattern before(LocalDateTime dateTime) {
        return new BeforeDateTimePattern(dateTime);
    }

    public static BeforeDateTimePattern beforeNow() {
        return new BeforeDateTimePattern("now");
    }

    public static EqualToDateTimePattern equalToDateTime(String dateTimeSpec) {
        return new EqualToDateTimePattern(dateTimeSpec);
    }

    public static EqualToDateTimePattern equalToDateTime(ZonedDateTime dateTime) {
        return new EqualToDateTimePattern(dateTime);
    }

    public static EqualToDateTimePattern equalToDateTime(LocalDateTime dateTime) {
        return new EqualToDateTimePattern(dateTime);
    }

    public static EqualToDateTimePattern isNow() {
        return new EqualToDateTimePattern("now");
    }

    public static AfterDateTimePattern after(String dateTimeSpec) {
        return new AfterDateTimePattern(dateTimeSpec);
    }

    public static AfterDateTimePattern after(ZonedDateTime dateTime) {
        return new AfterDateTimePattern(dateTime);
    }

    public static AfterDateTimePattern after(LocalDateTime dateTime) {
        return new AfterDateTimePattern(dateTime);
    }

    public static AfterDateTimePattern afterNow() {
        return new AfterDateTimePattern("now");
    }

    public static StringValuePattern absent() {
        return AbsentPattern.ABSENT;
    }

    public static StringValuePattern and(StringValuePattern ... matchers) {
        return new LogicalAnd(matchers);
    }

    public static StringValuePattern or(StringValuePattern ... matchers) {
        return new LogicalOr(matchers);
    }

    public void saveMappings() {
        this.admin.saveMappings();
    }

    public static void saveAllMappings() {
        ((WireMock)defaultInstance.get()).saveMappings();
    }

    public void removeMappings() {
        this.admin.resetMappings();
    }

    public static void removeAllMappings() {
        ((WireMock)defaultInstance.get()).removeMappings();
    }

    public void resetMappings() {
        this.admin.resetAll();
    }

    public static void reset() {
        ((WireMock)defaultInstance.get()).resetMappings();
    }

    public static void resetAllRequests() {
        ((WireMock)defaultInstance.get()).resetRequests();
    }

    public void resetRequests() {
        this.admin.resetRequests();
    }

    public void resetScenarios() {
        this.admin.resetScenarios();
    }

    public static void resetScenario(String name) {
        ((WireMock)defaultInstance.get()).resetScenarioState(name);
    }

    public void resetScenarioState(String name) {
        this.admin.resetScenario(name);
    }

    public static void setScenarioState(String name, String state) {
        ((WireMock)defaultInstance.get()).setSingleScenarioState(name, state);
    }

    public void setSingleScenarioState(String name, String state) {
        this.admin.setScenarioState(name, state);
    }

    public static List<Scenario> getAllScenarios() {
        return ((WireMock)defaultInstance.get()).getScenarios();
    }

    public List<Scenario> getScenarios() {
        return this.admin.getAllScenarios().getScenarios();
    }

    public static void resetAllScenarios() {
        ((WireMock)defaultInstance.get()).resetScenarios();
    }

    public void resetToDefaultMappings() {
        this.admin.resetToDefaultMappings();
    }

    public static void resetToDefault() {
        ((WireMock)defaultInstance.get()).resetToDefaultMappings();
    }

    public StubMapping register(MappingBuilder mappingBuilder) {
        StubMapping mapping = mappingBuilder.build();
        this.register(mapping);
        return mapping;
    }

    public void register(StubMapping mapping) {
        this.admin.addStubMapping(mapping);
    }

    public void editStubMapping(MappingBuilder mappingBuilder) {
        this.admin.editStubMapping(mappingBuilder.build());
    }

    public void removeStubMapping(MappingBuilder mappingBuilder) {
        this.admin.removeStubMapping(mappingBuilder.build());
    }

    public void removeStubMapping(StubMapping stubMapping) {
        this.admin.removeStubMapping(stubMapping);
    }

    public void removeStubMapping(UUID id) {
        this.admin.removeStubMapping(id);
    }

    public ListStubMappingsResult allStubMappings() {
        return this.admin.listAllStubMappings();
    }

    public SingleStubMappingResult getStubMapping(UUID id) {
        return this.admin.getStubMapping(id);
    }

    public static UrlPattern urlEqualTo(String testUrl) {
        return new UrlPattern(WireMock.equalTo(testUrl), false);
    }

    public static UrlPattern urlMatching(String urlRegex) {
        return new UrlPattern(WireMock.matching(urlRegex), true);
    }

    public static UrlPathPattern urlPathEqualTo(String testUrl) {
        return new UrlPathPattern(WireMock.equalTo(testUrl), false);
    }

    public static UrlPathPattern urlPathMatching(String urlRegex) {
        return new UrlPathPattern(WireMock.matching(urlRegex), true);
    }

    public static UrlPathPattern urlPathTemplate(String pathTemplate) {
        return new UrlPathTemplatePattern(pathTemplate);
    }

    public static MultiValuePattern havingExactly(StringValuePattern ... valuePatterns) {
        if (valuePatterns.length == 0) {
            return WireMock.noValues();
        }
        return new ExactMatchMultiValuePattern(Stream.of(valuePatterns).collect(Collectors.toList()));
    }

    public static MultiValuePattern havingExactly(String ... values) {
        return WireMock.havingExactly((StringValuePattern[])Stream.of(values).map(EqualToPattern::new).toArray(EqualToPattern[]::new));
    }

    public static MultiValuePattern including(StringValuePattern ... valuePatterns) {
        if (valuePatterns.length == 0) {
            return WireMock.noValues();
        }
        return new IncludesMatchMultiValuePattern(Stream.of(valuePatterns).collect(Collectors.toList()));
    }

    public static MultiValuePattern including(String ... values) {
        return WireMock.including((StringValuePattern[])Stream.of(values).map(EqualToPattern::new).toArray(EqualToPattern[]::new));
    }

    public static MultiValuePattern noValues() {
        return MultiValuePattern.of(WireMock.absent());
    }

    public static UrlPattern anyUrl() {
        return UrlPattern.ANY;
    }

    public static CountMatchingStrategy lessThan(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.LESS_THAN, expected);
    }

    public static CountMatchingStrategy lessThanOrExactly(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.LESS_THAN_OR_EQUAL, expected);
    }

    public static CountMatchingStrategy exactly(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.EQUAL_TO, expected);
    }

    public static CountMatchingStrategy moreThanOrExactly(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.GREATER_THAN_OR_EQUAL, expected);
    }

    public static CountMatchingStrategy moreThan(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.GREATER_THAN, expected);
    }

    public static MappingBuilder get(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.GET, urlPattern);
    }

    public static MappingBuilder post(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.POST, urlPattern);
    }

    public static MappingBuilder put(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.PUT, urlPattern);
    }

    public static MappingBuilder delete(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.DELETE, urlPattern);
    }

    public static MappingBuilder patch(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.PATCH, urlPattern);
    }

    public static MappingBuilder head(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.HEAD, urlPattern);
    }

    public static MappingBuilder options(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.OPTIONS, urlPattern);
    }

    public static MappingBuilder trace(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.TRACE, urlPattern);
    }

    public static MappingBuilder any(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.ANY, urlPattern);
    }

    public static MappingBuilder getOrHead(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.GET_OR_HEAD, urlPattern);
    }

    public static MappingBuilder request(String method, UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.fromString(method), urlPattern);
    }

    public static MappingBuilder requestMatching(String customRequestMatcherName) {
        return new BasicMappingBuilder(customRequestMatcherName, Parameters.empty());
    }

    public static MappingBuilder requestMatching(String customRequestMatcherName, Parameters parameters) {
        return new BasicMappingBuilder(customRequestMatcherName, parameters);
    }

    public static MappingBuilder requestMatching(ValueMatcher<Request> requestMatcher) {
        return new BasicMappingBuilder(requestMatcher);
    }

    public static ResponseDefinitionBuilder aResponse() {
        return new ResponseDefinitionBuilder();
    }

    public static ResponseDefinitionBuilder ok() {
        return WireMock.aResponse().withStatus(200);
    }

    public static ResponseDefinitionBuilder ok(String body) {
        return WireMock.aResponse().withStatus(200).withBody(body);
    }

    public static ResponseDefinitionBuilder okForContentType(String contentType, String body) {
        return WireMock.aResponse().withStatus(200).withHeader("Content-Type", contentType).withBody(body);
    }

    public static ResponseDefinitionBuilder okJson(String body) {
        return WireMock.okForContentType("application/json", body);
    }

    public static ResponseDefinitionBuilder okXml(String body) {
        return WireMock.okForContentType("application/xml", body);
    }

    public static ResponseDefinitionBuilder okTextXml(String body) {
        return WireMock.okForContentType("text/xml", body);
    }

    public static ResponseDefinitionBuilder jsonResponse(String body, int status) {
        return WireMock.aResponse().withStatus(status).withHeader("Content-Type", "application/json").withBody(body);
    }

    public static ResponseDefinitionBuilder jsonResponse(Object body, int status) {
        return WireMock.jsonResponse(Json.write(body), status);
    }

    public static MappingBuilder proxyAllTo(String url) {
        return WireMock.any(WireMock.anyUrl()).willReturn(WireMock.aResponse().proxiedFrom(url));
    }

    public static MappingBuilder get(String url) {
        return WireMock.get(WireMock.urlEqualTo(url));
    }

    public static MappingBuilder post(String url) {
        return WireMock.post(WireMock.urlEqualTo(url));
    }

    public static MappingBuilder put(String url) {
        return WireMock.put(WireMock.urlEqualTo(url));
    }

    public static MappingBuilder delete(String url) {
        return WireMock.delete(WireMock.urlEqualTo(url));
    }

    public static MappingBuilder patch(String url) {
        return WireMock.patch(WireMock.urlEqualTo(url));
    }

    public static ResponseDefinitionBuilder created() {
        return WireMock.aResponse().withStatus(201);
    }

    public static ResponseDefinitionBuilder noContent() {
        return WireMock.aResponse().withStatus(204);
    }

    public static ResponseDefinitionBuilder permanentRedirect(String location) {
        return WireMock.aResponse().withStatus(301).withHeader("Location", location);
    }

    public static ResponseDefinitionBuilder temporaryRedirect(String location) {
        return WireMock.aResponse().withStatus(302).withHeader("Location", location);
    }

    public static ResponseDefinitionBuilder seeOther(String location) {
        return WireMock.aResponse().withStatus(303).withHeader("Location", location);
    }

    public static ResponseDefinitionBuilder badRequest() {
        return WireMock.aResponse().withStatus(400);
    }

    public static ResponseDefinitionBuilder badRequestEntity() {
        return WireMock.aResponse().withStatus(422);
    }

    public static ResponseDefinitionBuilder unauthorized() {
        return WireMock.aResponse().withStatus(401);
    }

    public static ResponseDefinitionBuilder forbidden() {
        return WireMock.aResponse().withStatus(403);
    }

    public static ResponseDefinitionBuilder notFound() {
        return WireMock.aResponse().withStatus(404);
    }

    public static ResponseDefinitionBuilder serverError() {
        return WireMock.aResponse().withStatus(500);
    }

    public static ResponseDefinitionBuilder serviceUnavailable() {
        return WireMock.aResponse().withStatus(503);
    }

    public static ResponseDefinitionBuilder status(int status) {
        return WireMock.aResponse().withStatus(status);
    }

    public void verifyThat(RequestPatternBuilder requestPatternBuilder) {
        this.verifyThat(WireMock.moreThanOrExactly(1), requestPatternBuilder);
    }

    public void verifyThat(int expectedCount, RequestPatternBuilder requestPatternBuilder) {
        this.verifyThat(WireMock.exactly(expectedCount), requestPatternBuilder);
    }

    public void verifyThat(CountMatchingStrategy expectedCount, RequestPatternBuilder requestPatternBuilder) {
        int actualCount;
        RequestPattern requestPattern = requestPatternBuilder.build();
        if (requestPattern.hasInlineCustomMatcher()) {
            List<LoggedRequest> requests = this.admin.findRequestsMatching(RequestPattern.everything()).getRequests();
            actualCount = (int)requests.stream().filter(RequestPattern.thatMatch(requestPattern)).count();
        } else {
            VerificationResult result = this.admin.countRequestsMatching(requestPattern);
            result.assertRequestJournalEnabled();
            actualCount = result.getCount();
        }
        if (!expectedCount.match(actualCount)) {
            throw actualCount == 0 ? this.verificationExceptionForNearMisses(requestPatternBuilder, requestPattern) : new VerificationException(requestPattern, expectedCount, actualCount);
        }
    }

    private VerificationException verificationExceptionForNearMisses(RequestPatternBuilder requestPatternBuilder, RequestPattern requestPattern) {
        List<NearMiss> nearMisses = this.findAllNearMissesFor(requestPatternBuilder);
        if (!nearMisses.isEmpty()) {
            Diff diff = new Diff(requestPattern, (Request)nearMisses.get(0).getRequest());
            return VerificationException.forUnmatchedRequestPattern(diff);
        }
        return new VerificationException(requestPattern, this.find(RequestPatternBuilder.allRequests()));
    }

    public static void verify(RequestPatternBuilder requestPatternBuilder) {
        ((WireMock)defaultInstance.get()).verifyThat(requestPatternBuilder);
    }

    public static void verify(int count, RequestPatternBuilder requestPatternBuilder) {
        ((WireMock)defaultInstance.get()).verifyThat(count, requestPatternBuilder);
    }

    public static void verify(CountMatchingStrategy countMatchingStrategy, RequestPatternBuilder requestPatternBuilder) {
        ((WireMock)defaultInstance.get()).verifyThat(countMatchingStrategy, requestPatternBuilder);
    }

    public List<LoggedRequest> find(RequestPatternBuilder requestPatternBuilder) {
        FindRequestsResult result = this.admin.findRequestsMatching(requestPatternBuilder.build());
        result.assertRequestJournalEnabled();
        return result.getRequests();
    }

    public static List<LoggedRequest> findAll(RequestPatternBuilder requestPatternBuilder) {
        return ((WireMock)defaultInstance.get()).find(requestPatternBuilder);
    }

    public static List<ServeEvent> getAllServeEvents() {
        return ((WireMock)defaultInstance.get()).getServeEvents();
    }

    public List<ServeEvent> getServeEvents() {
        return this.admin.getServeEvents().getRequests();
    }

    public static List<ServeEvent> getAllServeEvents(ServeEventQuery query) {
        return ((WireMock)defaultInstance.get()).getServeEvents(query);
    }

    public List<ServeEvent> getServeEvents(ServeEventQuery query) {
        return this.admin.getServeEvents(query).getRequests();
    }

    public static void removeServeEvent(UUID eventId) {
        ((WireMock)defaultInstance.get()).removeEvent(eventId);
    }

    public void removeEvent(UUID eventId) {
        this.admin.removeServeEvent(eventId);
    }

    public List<ServeEvent> removeEvents(RequestPatternBuilder requestPatternBuilder) {
        return this.admin.removeServeEventsMatching(requestPatternBuilder.build()).getServeEvents();
    }

    public static List<ServeEvent> removeServeEvents(RequestPatternBuilder requestPatternBuilder) {
        return ((WireMock)defaultInstance.get()).removeEvents(requestPatternBuilder);
    }

    public static List<ServeEvent> removeEventsByStubMetadata(StringValuePattern pattern) {
        return ((WireMock)defaultInstance.get()).removeEventsByMetadata(pattern);
    }

    public List<ServeEvent> removeEventsByMetadata(StringValuePattern pattern) {
        return this.admin.removeServeEventsForStubsMatchingMetadata(pattern).getServeEvents();
    }

    public static RequestPatternBuilder getRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.GET, urlPattern);
    }

    public static RequestPatternBuilder postRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.POST, urlPattern);
    }

    public static RequestPatternBuilder putRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.PUT, urlPattern);
    }

    public static RequestPatternBuilder deleteRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.DELETE, urlPattern);
    }

    public static RequestPatternBuilder patchRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.PATCH, urlPattern);
    }

    public static RequestPatternBuilder headRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.HEAD, urlPattern);
    }

    public static RequestPatternBuilder optionsRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.OPTIONS, urlPattern);
    }

    public static RequestPatternBuilder traceRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.TRACE, urlPattern);
    }

    public static RequestPatternBuilder anyRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.ANY, urlPattern);
    }

    public static RequestPatternBuilder requestedFor(String method, UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.fromString(method), urlPattern);
    }

    public static RequestPatternBuilder requestMadeFor(String customMatcherName, Parameters parameters) {
        return RequestPatternBuilder.forCustomMatcher(customMatcherName, parameters);
    }

    public static RequestPatternBuilder requestMadeFor(ValueMatcher<Request> requestMatcher) {
        return RequestPatternBuilder.forCustomMatcher(requestMatcher);
    }

    public static void setGlobalFixedDelay(int milliseconds) {
        ((WireMock)defaultInstance.get()).setGlobalFixedDelayVariable(milliseconds);
    }

    public void setGlobalFixedDelayVariable(int milliseconds) {
        GlobalSettings settings = this.settingsStore.get().copy().fixedDelay(milliseconds).build();
        this.updateGlobalSettings(settings);
    }

    public static void setGlobalRandomDelay(DelayDistribution distribution) {
        ((WireMock)defaultInstance.get()).setGlobalRandomDelayVariable(distribution);
    }

    public void setGlobalRandomDelayVariable(DelayDistribution distribution) {
        GlobalSettings settings = this.settingsStore.get().copy().delayDistribution(distribution).build();
        this.updateGlobalSettings(settings);
    }

    public static void updateSettings(GlobalSettings settings) {
        ((WireMock)defaultInstance.get()).updateGlobalSettings(settings);
    }

    public void updateGlobalSettings(GlobalSettings settings) {
        this.settingsStore.set(settings);
        this.admin.updateGlobalSettings(settings);
    }

    public void shutdown() {
        this.admin.shutdownServer();
    }

    public static void shutdownServer() {
        ((WireMock)defaultInstance.get()).shutdown();
    }

    public static List<NearMiss> findNearMissesForAllUnmatched() {
        return ((WireMock)defaultInstance.get()).findNearMissesForAllUnmatchedRequests();
    }

    public List<NearMiss> findNearMissesForAllUnmatchedRequests() {
        FindNearMissesResult nearMissesResult = this.admin.findNearMissesForUnmatchedRequests();
        return nearMissesResult.getNearMisses();
    }

    public static List<LoggedRequest> findUnmatchedRequests() {
        return ((WireMock)defaultInstance.get()).findAllUnmatchedRequests();
    }

    public List<LoggedRequest> findAllUnmatchedRequests() {
        FindRequestsResult unmatchedResult = this.admin.findUnmatchedRequests();
        return unmatchedResult.getRequests();
    }

    public static List<NearMiss> findNearMissesFor(LoggedRequest loggedRequest) {
        return ((WireMock)defaultInstance.get()).findTopNearMissesFor(loggedRequest);
    }

    public List<NearMiss> findTopNearMissesFor(LoggedRequest loggedRequest) {
        FindNearMissesResult nearMissesResult = this.admin.findTopNearMissesFor(loggedRequest);
        return nearMissesResult.getNearMisses();
    }

    public static List<NearMiss> findNearMissesFor(RequestPatternBuilder requestPatternBuilder) {
        return ((WireMock)defaultInstance.get()).findAllNearMissesFor(requestPatternBuilder);
    }

    public List<NearMiss> findAllNearMissesFor(RequestPatternBuilder requestPatternBuilder) {
        FindNearMissesResult nearMissesResult = this.admin.findTopNearMissesFor(requestPatternBuilder.build());
        return nearMissesResult.getNearMisses();
    }

    public void loadMappingsFrom(String rootDir) {
        this.loadMappingsFrom(new File(rootDir));
    }

    public void loadMappingsFrom(File rootDir) {
        SingleRootFileSource mappingsSource = new SingleRootFileSource(rootDir);
        new RemoteMappingsLoader(mappingsSource, this).load();
    }

    public static List<StubMapping> snapshotRecord() {
        return ((WireMock)defaultInstance.get()).takeSnapshotRecording();
    }

    public static List<StubMapping> snapshotRecord(RecordSpecBuilder spec) {
        return ((WireMock)defaultInstance.get()).takeSnapshotRecording(spec);
    }

    public List<StubMapping> takeSnapshotRecording() {
        return this.admin.snapshotRecord().getStubMappings();
    }

    public List<StubMapping> takeSnapshotRecording(RecordSpecBuilder spec) {
        return this.admin.snapshotRecord(spec.build()).getStubMappings();
    }

    public static MultipartValuePatternBuilder aMultipart() {
        return new MultipartValuePatternBuilder();
    }

    public static MultipartValuePatternBuilder aMultipart(String name) {
        return new MultipartValuePatternBuilder(name);
    }

    public static void startRecording(String targetBaseUrl) {
        ((WireMock)defaultInstance.get()).startStubRecording(targetBaseUrl);
    }

    public static void startRecording() {
        ((WireMock)defaultInstance.get()).startStubRecording();
    }

    public static void startRecording(RecordSpecBuilder spec) {
        ((WireMock)defaultInstance.get()).startStubRecording(spec);
    }

    public void startStubRecording(String targetBaseUrl) {
        this.admin.startRecording(targetBaseUrl);
    }

    public void startStubRecording() {
        this.admin.startRecording(RecordSpec.DEFAULTS);
    }

    public void startStubRecording(RecordSpecBuilder spec) {
        this.admin.startRecording(spec.build());
    }

    public static SnapshotRecordResult stopRecording() {
        return ((WireMock)defaultInstance.get()).stopStubRecording();
    }

    public SnapshotRecordResult stopStubRecording() {
        return this.admin.stopRecording();
    }

    public static RecordingStatusResult getRecordingStatus() {
        return ((WireMock)defaultInstance.get()).getStubRecordingStatus();
    }

    public RecordingStatusResult getStubRecordingStatus() {
        return this.admin.getRecordingStatus();
    }

    public static RecordSpecBuilder recordSpec() {
        return new RecordSpecBuilder();
    }

    public List<StubMapping> findAllStubsByMetadata(StringValuePattern pattern) {
        return this.admin.findAllStubsByMetadata(pattern).getMappings();
    }

    public static List<StubMapping> findStubsByMetadata(StringValuePattern pattern) {
        return ((WireMock)defaultInstance.get()).findAllStubsByMetadata(pattern);
    }

    public void removeStubsByMetadataPattern(StringValuePattern pattern) {
        this.admin.removeStubsByMetadata(pattern);
    }

    public static void removeStubsByMetadata(StringValuePattern pattern) {
        ((WireMock)defaultInstance.get()).removeStubsByMetadataPattern(pattern);
    }

    public void importStubMappings(StubImport stubImport) {
        this.admin.importStubs(stubImport);
    }

    public void importStubMappings(StubImportBuilder stubImport) {
        this.importStubMappings(stubImport.build());
    }

    public static void importStubs(StubImportBuilder stubImport) {
        WireMock.importStubs(stubImport.build());
    }

    public static void importStubs(StubImport stubImport) {
        ((WireMock)defaultInstance.get()).importStubMappings(stubImport);
    }

    public void removeStubMappings(List<StubMapping> stubs) {
        this.admin.removeStubMappings(stubs);
    }

    public static void removeStubs(List<StubMapping> stubs) {
        ((WireMock)defaultInstance.get()).removeStubMappings(stubs);
    }

    public GlobalSettings getGlobalSettings() {
        return this.admin.getGlobalSettings().getSettings();
    }

    public static GlobalSettings getSettings() {
        return ((WireMock)defaultInstance.get()).getGlobalSettings();
    }

    public static enum JsonSchemaVersion {
        V4,
        V6,
        V7,
        V201909,
        V202012;

        public static final JsonSchemaVersion DEFAULT;

        public SpecVersion.VersionFlag toVersionFlag() {
            switch (this) {
                case V4: {
                    return SpecVersion.VersionFlag.V4;
                }
                case V6: {
                    return SpecVersion.VersionFlag.V6;
                }
                case V7: {
                    return SpecVersion.VersionFlag.V7;
                }
                case V201909: {
                    return SpecVersion.VersionFlag.V201909;
                }
                case V202012: {
                    return SpecVersion.VersionFlag.V202012;
                }
            }
            throw new IllegalArgumentException("Unknown schema version: " + String.valueOf((Object)this));
        }

        static {
            DEFAULT = V202012;
        }
    }
}

