/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InterruptedIOException;
import wiremock.org.apache.hc.client5.http.HttpRequestRetryStrategy;
import wiremock.org.apache.hc.client5.http.HttpRoute;
import wiremock.org.apache.hc.client5.http.classic.ExecChain;
import wiremock.org.apache.hc.client5.http.classic.ExecChainHandler;
import wiremock.org.apache.hc.client5.http.impl.classic.RequestFailedException;
import wiremock.org.apache.hc.client5.http.protocol.HttpClientContext;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.Internal;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.ClassicHttpRequest;
import wiremock.org.apache.hc.core5.http.ClassicHttpResponse;
import wiremock.org.apache.hc.core5.http.HttpEntity;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpHost;
import wiremock.org.apache.hc.core5.http.NoHttpResponseException;
import wiremock.org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import wiremock.org.apache.hc.core5.util.Args;
import wiremock.org.apache.hc.core5.util.TimeValue;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public class HttpRequestRetryExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestRetryExec.class);
    private final HttpRequestRetryStrategy retryStrategy;

    public HttpRequestRetryExec(HttpRequestRetryStrategy retryStrategy) {
        Args.notNull(retryStrategy, "retryStrategy");
        this.retryStrategy = retryStrategy;
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull(request, "request");
        Args.notNull(scope, "scope");
        String exchangeId = scope.exchangeId;
        HttpRoute route = scope.route;
        HttpHost target = route.getTargetHost();
        HttpClientContext context = scope.clientContext;
        ClassicHttpRequest currentRequest = request;
        int execCount = 1;
        while (true) {
            TimeValue delay;
            try {
                ClassicHttpResponse response = chain.proceed(currentRequest, scope);
                try {
                    HttpEntity entity = request.getEntity();
                    if (entity != null && !entity.isRepeatable()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} cannot retry non-repeatable request", (Object)exchangeId);
                        }
                        return response;
                    }
                    if (this.retryStrategy.retryRequest(response, execCount, context)) {
                        response.close();
                        delay = this.retryStrategy.getRetryInterval(response, execCount, context);
                        if (LOG.isInfoEnabled()) {
                            LOG.info("{} {} responded with status {}; request will be automatically re-executed in {} (exec count {})", exchangeId, target, response.getCode(), delay, execCount + 1);
                        }
                    } else {
                        return response;
                    }
                    HttpRequestRetryExec.pause(delay);
                    currentRequest = ClassicRequestBuilder.copy(scope.originalRequest).build();
                }
                catch (RuntimeException ex) {
                    response.close();
                    throw ex;
                }
            }
            catch (IOException ex) {
                if (scope.execRuntime.isExecutionAborted()) {
                    throw new RequestFailedException("Request aborted");
                }
                HttpEntity requestEntity = request.getEntity();
                if (requestEntity != null && !requestEntity.isRepeatable()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} cannot retry non-repeatable request", (Object)exchangeId);
                    }
                    throw ex;
                }
                if (this.retryStrategy.retryRequest(request, ex, execCount, context)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} {}", exchangeId, ex.getMessage(), ex);
                    }
                    delay = this.retryStrategy.getRetryInterval(request, ex, execCount, context);
                    if (LOG.isInfoEnabled()) {
                        LOG.info("{} recoverable I/O exception ({}) caught when sending request to {};request will be automatically re-executed in {} (exec count {})", exchangeId, ex.getClass().getName(), target, delay, execCount + 1);
                    }
                    HttpRequestRetryExec.pause(delay);
                    currentRequest = ClassicRequestBuilder.copy(scope.originalRequest).build();
                }
                if (ex instanceof NoHttpResponseException) {
                    NoHttpResponseException updatedex = new NoHttpResponseException(target.toHostString() + " failed to respond");
                    updatedex.setStackTrace(ex.getStackTrace());
                    throw updatedex;
                }
                throw ex;
            }
            ++execCount;
        }
    }

    private static void pause(TimeValue delay) throws InterruptedIOException {
        if (TimeValue.isPositive(delay)) {
            try {
                delay.sleep();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
    }
}

