/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Set;
import java.util.function.Function;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidationResult;
import wiremock.com.networknt.schema.output.HierarchicalOutputUnitFormatter;
import wiremock.com.networknt.schema.output.ListOutputUnitFormatter;
import wiremock.com.networknt.schema.output.OutputFlag;
import wiremock.com.networknt.schema.output.OutputUnit;
import wiremock.com.networknt.schema.output.OutputUnitData;

public interface OutputFormat<T> {
    public static final Default DEFAULT = new Default();
    public static final Boolean BOOLEAN = new Boolean();
    public static final Flag FLAG = new Flag();
    public static final List LIST = new List();
    public static final Hierarchical HIERARCHICAL = new Hierarchical();
    public static final Result RESULT = new Result();

    default public void customize(ExecutionContext executionContext, ValidationContext validationContext) {
    }

    public T format(JsonSchema var1, Set<ValidationMessage> var2, ExecutionContext var3, ValidationContext var4);

    public static class Default
    implements OutputFormat<Set<ValidationMessage>> {
        @Override
        public void customize(ExecutionContext executionContext, ValidationContext validationContext) {
            executionContext.getExecutionConfig().setAnnotationCollectionEnabled(false);
        }

        @Override
        public Set<ValidationMessage> format(JsonSchema jsonSchema, Set<ValidationMessage> validationMessages, ExecutionContext executionContext, ValidationContext validationContext) {
            return validationMessages;
        }
    }

    public static class Boolean
    implements OutputFormat<java.lang.Boolean> {
        @Override
        public void customize(ExecutionContext executionContext, ValidationContext validationContext) {
            executionContext.getExecutionConfig().setAnnotationCollectionEnabled(false);
            executionContext.getExecutionConfig().setFailFast(true);
        }

        @Override
        public java.lang.Boolean format(JsonSchema jsonSchema, Set<ValidationMessage> validationMessages, ExecutionContext executionContext, ValidationContext validationContext) {
            return validationMessages.isEmpty();
        }
    }

    public static class Flag
    implements OutputFormat<OutputFlag> {
        @Override
        public void customize(ExecutionContext executionContext, ValidationContext validationContext) {
            executionContext.getExecutionConfig().setAnnotationCollectionEnabled(false);
            executionContext.getExecutionConfig().setFailFast(true);
        }

        @Override
        public OutputFlag format(JsonSchema jsonSchema, Set<ValidationMessage> validationMessages, ExecutionContext executionContext, ValidationContext validationContext) {
            return new OutputFlag(validationMessages.isEmpty());
        }
    }

    public static class List
    implements OutputFormat<OutputUnit> {
        private final Function<ValidationMessage, Object> assertionMapper;

        public List() {
            this(OutputUnitData::formatAssertion);
        }

        public List(Function<ValidationMessage, Object> assertionMapper) {
            this.assertionMapper = assertionMapper;
        }

        @Override
        public void customize(ExecutionContext executionContext, ValidationContext validationContext) {
        }

        @Override
        public OutputUnit format(JsonSchema jsonSchema, Set<ValidationMessage> validationMessages, ExecutionContext executionContext, ValidationContext validationContext) {
            return ListOutputUnitFormatter.format(validationMessages, executionContext, validationContext, this.assertionMapper);
        }
    }

    public static class Hierarchical
    implements OutputFormat<OutputUnit> {
        private final Function<ValidationMessage, Object> assertionMapper;

        public Hierarchical() {
            this(OutputUnitData::formatAssertion);
        }

        public Hierarchical(Function<ValidationMessage, Object> assertionMapper) {
            this.assertionMapper = assertionMapper;
        }

        @Override
        public void customize(ExecutionContext executionContext, ValidationContext validationContext) {
        }

        @Override
        public OutputUnit format(JsonSchema jsonSchema, Set<ValidationMessage> validationMessages, ExecutionContext executionContext, ValidationContext validationContext) {
            return HierarchicalOutputUnitFormatter.format(jsonSchema, validationMessages, executionContext, validationContext, this.assertionMapper);
        }
    }

    public static class Result
    implements OutputFormat<ValidationResult> {
        @Override
        public void customize(ExecutionContext executionContext, ValidationContext validationContext) {
        }

        @Override
        public ValidationResult format(JsonSchema jsonSchema, Set<ValidationMessage> validationMessages, ExecutionContext executionContext, ValidationContext validationContext) {
            return new ValidationResult(validationMessages, executionContext);
        }
    }
}

