/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.fasterxml.jackson.datatype.jsr310.deser;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import wiremock.com.fasterxml.jackson.annotation.JsonFormat;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.core.JsonToken;
import wiremock.com.fasterxml.jackson.databind.DeserializationContext;
import wiremock.com.fasterxml.jackson.databind.DeserializationFeature;
import wiremock.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;

public class YearMonthDeserializer
extends JSR310DateTimeDeserializerBase<YearMonth> {
    private static final long serialVersionUID = 1L;
    public static final YearMonthDeserializer INSTANCE = new YearMonthDeserializer();

    public YearMonthDeserializer() {
        this(DateTimeFormatter.ofPattern("u-MM"));
    }

    public YearMonthDeserializer(DateTimeFormatter formatter) {
        super(YearMonth.class, formatter);
    }

    protected YearMonthDeserializer(YearMonthDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    public YearMonthDeserializer(YearMonthDeserializer base, Boolean leniency, DateTimeFormatter formatter, JsonFormat.Shape shape) {
        super(base, leniency, formatter, shape);
    }

    protected YearMonthDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new YearMonthDeserializer(this, (Boolean)this._isLenient, dtf, this._shape);
    }

    @Override
    protected YearMonthDeserializer withLeniency(Boolean leniency) {
        return new YearMonthDeserializer(this, leniency);
    }

    @Override
    public YearMonth deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p, ctxt, p.getText());
        }
        if (p.isExpectedStartObjectToken()) {
            String str = ctxt.extractScalarFromObject(p, this, this.handledType());
            if (str != null) {
                return this._fromString(p, ctxt, str);
            }
        } else {
            if (p.isExpectedStartArrayToken()) {
                JsonToken t = p.nextToken();
                if (t == JsonToken.END_ARRAY) {
                    return null;
                }
                if ((t == JsonToken.VALUE_STRING || t == JsonToken.VALUE_EMBEDDED_OBJECT) && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                    YearMonth parsed = this.deserialize(p, ctxt);
                    if (p.nextToken() != JsonToken.END_ARRAY) {
                        this.handleMissingEndArrayForSingle(p, ctxt);
                    }
                    return parsed;
                }
                if (t != JsonToken.VALUE_NUMBER_INT) {
                    this._reportWrongToken(ctxt, JsonToken.VALUE_NUMBER_INT, "years");
                }
                int year = p.getIntValue();
                int month = p.nextIntValue(-1);
                if (month == -1) {
                    if (!p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                        this._reportWrongToken(ctxt, JsonToken.VALUE_NUMBER_INT, "months");
                    }
                    month = p.getIntValue();
                }
                if (p.nextToken() != JsonToken.END_ARRAY) {
                    throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                }
                return YearMonth.of(year, month);
            }
            if (p.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
                return (YearMonth)p.getEmbeddedObject();
            }
        }
        return (YearMonth)this._handleUnexpectedToken(ctxt, p, JsonToken.VALUE_STRING, JsonToken.START_ARRAY);
    }

    protected YearMonth _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string = string0.trim();
        if (string.length() == 0) {
            return (YearMonth)this._fromEmptyString(p, ctxt, string);
        }
        try {
            return YearMonth.parse(string, this._formatter);
        }
        catch (DateTimeException e) {
            return (YearMonth)this._handleDateTimeException(ctxt, e, string);
        }
    }
}

