/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.github.tomakehurst.wiremock.matching.MatchesXPathPattern;
import com.github.tomakehurst.wiremock.matching.PathPatternJsonSerializer;
import com.github.tomakehurst.wiremock.matching.UnwrappedXPathPatternJsonSerializer;
import java.io.IOException;
import java.util.Map;

public class XPathPatternJsonSerializer
extends PathPatternJsonSerializer<MatchesXPathPattern> {
    public JsonSerializer<MatchesXPathPattern> unwrappingSerializer(NameTransformer unwrapper) {
        return new UnwrappedXPathPatternJsonSerializer();
    }

    @Override
    protected void serializeAdditionalFields(MatchesXPathPattern value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value.getXPathNamespaces() != null && !value.getXPathNamespaces().isEmpty()) {
            gen.writeObjectFieldStart("xPathNamespaces");
            for (Map.Entry<String, String> namespace : value.getXPathNamespaces().entrySet()) {
                gen.writeStringField(namespace.getKey(), namespace.getValue());
            }
            gen.writeEndObject();
        }
    }
}

