/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;

public class Timing {
    public static final Timing UNTIMED = Timing.create();
    private volatile Integer addedDelay;
    private volatile Integer processTime;
    private volatile Integer responseSendTime;

    public static Timing create() {
        return new Timing(null, null, null, null, null);
    }

    private Timing(@JsonProperty(value="addedDelay") Integer addedDelay, @JsonProperty(value="processTime") Integer processTime, @JsonProperty(value="responseSendTime") Integer responseSendTime, @JsonProperty(value="serveTime") Integer ignored1, @JsonProperty(value="totalTime") Integer ignored2) {
        this.addedDelay = addedDelay;
        this.processTime = processTime;
        this.responseSendTime = responseSendTime;
    }

    public Integer getAddedDelay() {
        return this.addedDelay;
    }

    public Integer getProcessTime() {
        return this.processTime;
    }

    public Integer getResponseSendTime() {
        return this.responseSendTime;
    }

    public Integer getServeTime() {
        if (this.processTime == null || this.responseSendTime == null) {
            return null;
        }
        return this.processTime + this.responseSendTime;
    }

    public Integer getTotalTime() {
        Integer serveTime = this.getServeTime();
        if (serveTime == null || this.addedDelay == null) {
            return null;
        }
        return serveTime + this.addedDelay;
    }

    public void setAddedTime(int addedDelayMillis) {
        this.addedDelay = addedDelayMillis;
    }

    public void logProcessTime(Stopwatch stopwatch) {
        this.processTime = (int)stopwatch.elapsed(TimeUnit.MILLISECONDS);
    }

    public void logResponseSendTime(Stopwatch stopwatch) {
        this.responseSendTime = (int)stopwatch.elapsed(TimeUnit.MILLISECONDS);
    }
}

