/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.distributable;

import jakarta.ejb.ConcurrentAccessTimeoutException;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.Contextual;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.distributable.RemoveListenerAdapter;
import org.jboss.ejb.client.Affinity;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.RemoveListener;

public class DistributableCache<K, V extends Identifiable<K> & Contextual<Batch>>
implements Cache<K, V> {
    private static final Object UNSET = Boolean.TRUE;
    private final BeanManager<K, V, Batch> manager;
    private final StatefulObjectFactory<V> factory;
    private final TransactionSynchronizationRegistry tsr;
    private final RemoveListener<V> listener;

    public DistributableCache(BeanManager<K, V, Batch> manager, StatefulObjectFactory<V> factory, TransactionSynchronizationRegistry tsr) {
        this.manager = manager;
        this.factory = factory;
        this.tsr = tsr;
        this.listener = new RemoveListenerAdapter(factory);
    }

    public Affinity getStrictAffinity() {
        return this.manager.getStrictAffinity();
    }

    public Affinity getWeakAffinity(K id) {
        return this.manager.getWeakAffinity(id);
    }

    @Override
    public Supplier<K> getIdentifierFactory() {
        return this.manager.getIdentifierFactory();
    }

    /*
     * Loose catch block
     */
    @Override
    public V create() {
        boolean newGroup;
        boolean bl = newGroup = CURRENT_GROUP.get() == null;
        if (newGroup) {
            CURRENT_GROUP.set(UNSET);
        }
        try {
            Identifiable identifiable;
            try (Batch batch = this.manager.getBatcher().createBatch();){
                Identifiable instance = (Identifiable)this.factory.createInstance();
                Object id = instance.getId();
                if (CURRENT_GROUP.get() == UNSET) {
                    CURRENT_GROUP.set(id);
                }
                this.manager.createBean(id, CURRENT_GROUP.get(), (Object)instance).close();
                identifiable = instance;
            }
            return (V)identifiable;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (newGroup) {
                CURRENT_GROUP.remove();
            }
        }
    }

    @Override
    public V get(K id) {
        Batcher batcher = this.manager.getBatcher();
        boolean transactional = this.tsr.getTransactionKey() != null;
        Batch existingBatch = transactional ? (Batch)this.tsr.getResource(Batch.class) : null;
        try (BatchContext context = existingBatch != null ? batcher.resumeBatch(existingBatch) : null;){
            Bean bean;
            Batch batch;
            block12: {
                V v;
                batch = batcher.createBatch();
                try {
                    bean = this.manager.findBean(id);
                    if (bean != null) break block12;
                    batch.close();
                    v = null;
                }
                catch (TimeoutException e) {
                    batch.close();
                    throw new ConcurrentAccessTimeoutException(e.getMessage());
                }
                catch (Error | RuntimeException e) {
                    batch.discard();
                    batch.close();
                    throw e;
                }
                return v;
            }
            Identifiable result = (Identifiable)bean.acquire();
            ((Contextual)((Object)result)).setCacheContext(batch);
            if (transactional && existingBatch == null) {
                this.tsr.putResource(Batch.class, (Object)batch);
            }
            Identifiable identifiable = result;
            return (V)identifiable;
        }
    }

    @Override
    public void release(V value) {
        try (BatchContext context = this.manager.getBatcher().resumeBatch((Batch)((Contextual)value).getCacheContext());
             Batch batch = (Batch)((Contextual)value).getCacheContext();){
            try {
                Bean bean = this.manager.findBean(value.getId());
                if (bean != null && bean.release()) {
                    bean.close();
                }
            }
            catch (TimeoutException e) {
                throw new ConcurrentAccessTimeoutException(e.getMessage());
            }
            catch (Error | RuntimeException e) {
                batch.discard();
                throw e;
            }
        }
    }

    @Override
    public void remove(K id) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            try {
                Bean bean = this.manager.findBean(id);
                if (bean != null) {
                    bean.remove(this.listener);
                }
            }
            catch (TimeoutException e) {
                throw new ConcurrentAccessTimeoutException(e.getMessage());
            }
            catch (Error | RuntimeException e) {
                batch.discard();
                throw e;
            }
        }
    }

    @Override
    public void discard(V value) {
        try (BatchContext context = this.manager.getBatcher().resumeBatch((Batch)((Contextual)value).getCacheContext());
             Batch batch = (Batch)((Contextual)value).getCacheContext();){
            try {
                Bean bean = this.manager.findBean(value.getId());
                if (bean != null) {
                    bean.remove(null);
                }
            }
            catch (TimeoutException e) {
                throw new ConcurrentAccessTimeoutException(e.getMessage());
            }
            catch (Error | RuntimeException e) {
                batch.discard();
                throw e;
            }
        }
    }

    @Override
    public boolean contains(K id) {
        try (Batch batch = this.manager.getBatcher().createBatch();){
            boolean bl = this.manager.containsBean(id);
            return bl;
        }
    }

    public void start() {
        this.manager.start();
    }

    public void stop() {
        this.manager.stop();
    }

    @Override
    public int getCacheSize() {
        return this.manager.getActiveCount();
    }

    @Override
    public int getPassivatedCount() {
        return this.manager.getPassiveCount();
    }

    @Override
    public int getTotalSize() {
        return this.manager.getActiveCount() + this.manager.getPassiveCount();
    }

    @Override
    public boolean isRemotable(Throwable throwable) {
        return this.manager.isRemotable(throwable);
    }
}

