/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.ejb;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.as.weld.ejb.SerializedStatefulSessionObject;
import org.jboss.ejb.client.SessionID;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class SerializedStatefulSessionObjectMarshaller
implements ProtoStreamMarshaller<SerializedStatefulSessionObject> {
    private static final int COMPONENT_SERVICE_NAME_INDEX = 1;
    private static final int SESSION_ID_INDEX = 2;
    private static final int VIEW_CLASS_INDEX = 3;
    private static final int VIEW_SERVICE_NAME_INDEX = 4;

    public Class<? extends SerializedStatefulSessionObject> getJavaClass() {
        return SerializedStatefulSessionObject.class;
    }

    public SerializedStatefulSessionObject readFrom(ProtoStreamReader reader) throws IOException {
        String componentServiceName = null;
        SessionID id = null;
        LinkedList<Class> viewClasses = new LinkedList<Class>();
        LinkedList<String> viewServiceNames = new LinkedList<String>();
        block6: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    componentServiceName = reader.readString();
                    continue block6;
                }
                case 2: {
                    id = (SessionID)reader.readObject(SessionID.class);
                    continue block6;
                }
                case 3: {
                    viewClasses.add((Class)reader.readObject(Class.class));
                    continue block6;
                }
                case 4: {
                    viewServiceNames.add(reader.readString());
                    continue block6;
                }
            }
            reader.skipField(tag);
        }
        HashMap<Class, String> views = new HashMap<Class, String>();
        Iterator classes = viewClasses.iterator();
        Iterator names = viewServiceNames.iterator();
        while (classes.hasNext() && names.hasNext()) {
            views.put((Class)classes.next(), (String)names.next());
        }
        return new SerializedStatefulSessionObject(componentServiceName, id, views);
    }

    public void writeTo(ProtoStreamWriter writer, SerializedStatefulSessionObject object) throws IOException {
        SessionID id;
        String componentServiceName = object.getComponentServiceName();
        if (componentServiceName != null) {
            writer.writeString(1, componentServiceName);
        }
        if ((id = object.getSessionID()) != null) {
            writer.writeObject(2, (Object)id);
        }
        Map views = object.getServiceNames();
        for (Map.Entry entry : views.entrySet()) {
            writer.writeObject(3, entry.getKey());
            writer.writeString(4, (String)entry.getValue());
        }
    }
}

