/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.env;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DependencyTree<T> {
    protected Map<T, Set<T>> depTree = new HashMap<T, Set<T>>();

    public void add(T parent, T child) {
        Set children = this.depTree.computeIfAbsent(parent, p -> new HashSet());
        if (!child.equals(parent)) {
            children.add(child);
        }
    }

    public void add(T parent) {
        this.depTree.computeIfAbsent(parent, p -> new HashSet());
    }

    public Collection<T> getDirectDeps() {
        return this.depTree.keySet().stream().sorted(this::comparator).collect(Collectors.toList());
    }

    protected int comparator(T first, T second) {
        return 0;
    }

    public Collection<T> getTransientDeps(T parent) {
        Set<T> deps = this.depTree.get(parent);
        if (null == deps) {
            throw new IllegalArgumentException("Unknown dependency " + parent);
        }
        return deps;
    }
}

