/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules.filter;

import java.util.Arrays;
import org.jboss.modules.filter.PathFilter;

final class MultiplePathFilter
implements PathFilter {
    private final PathFilter[] filters;
    private final boolean[] includeFlag;
    private final boolean defaultVal;
    private final int hashCode;

    MultiplePathFilter(PathFilter[] filters, boolean[] includeFlag, boolean defaultVal) {
        this.filters = filters;
        this.includeFlag = includeFlag;
        this.defaultVal = defaultVal;
        this.hashCode = Boolean.valueOf(defaultVal).hashCode() * 13 + (Arrays.hashCode(includeFlag) * 13 + Arrays.hashCode(filters));
    }

    @Override
    public boolean accept(String path) {
        int len = this.filters.length;
        for (int i = 0; i < len; ++i) {
            if (!this.filters[i].accept(path)) continue;
            return this.includeFlag[i];
        }
        return this.defaultVal;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("multi-path filter {");
        int len = this.filters.length;
        for (int i = 0; i < len; ++i) {
            PathFilter filter = this.filters[i];
            boolean include = this.includeFlag[i];
            builder.append(include ? "include " : "exclude ");
            builder.append(filter);
            builder.append(", ");
        }
        builder.append("default ").append(this.defaultVal ? "accept" : "reject");
        builder.append('}');
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof MultiplePathFilter && this.equals((MultiplePathFilter)other);
    }

    public boolean equals(MultiplePathFilter other) {
        return this == other || other != null && Arrays.equals(this.filters, other.filters) && Arrays.equals(this.includeFlag, other.includeFlag) && this.defaultVal == other.defaultVal;
    }
}

