/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import org.jboss.as.arquillian.container.ContainerDescription;

class StandardContainerDescription
implements ContainerDescription {
    static final StandardContainerDescription NULL_DESCRIPTION = new StandardContainerDescription("WildFly", null, null, null, ContainerDescription.ModelVersion.DEFAULT);
    private final String productName;
    private final String productVersion;
    private final String releaseCodename;
    private final String releaseVersion;
    private final ContainerDescription.ModelVersion modelVersion;

    StandardContainerDescription(String productName, String productVersion, String releaseCodename, String releaseVersion, ContainerDescription.ModelVersion modelVersion) {
        this.productName = productName;
        this.productVersion = productVersion;
        this.releaseCodename = releaseCodename;
        this.releaseVersion = releaseVersion;
        this.modelVersion = modelVersion;
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getProductVersion() {
        return this.productVersion;
    }

    @Override
    public String getReleaseCodename() {
        return this.releaseCodename;
    }

    @Override
    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    @Override
    public ContainerDescription.ModelVersion getModelVersion() {
        return this.modelVersion;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(64);
        result.append(this.productName);
        if (this.productVersion != null) {
            result.append(' ').append(this.productVersion);
            if (this.releaseCodename != null) {
                result.append(' ').append('\"').append(this.releaseCodename).append('\"');
            }
            if (this.releaseVersion != null) {
                result.append(" (WildFly Core ").append(this.releaseVersion).append(')');
            }
        } else {
            if (this.releaseVersion != null) {
                result.append(' ').append(this.releaseVersion);
            }
            if (this.releaseCodename != null) {
                result.append(' ').append('\"').append(this.releaseCodename).append('\"');
            }
        }
        return result.toString();
    }
}

