/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datastores.common;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.util.lang.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.datastores.common.SessionQuotaManagingDataStore;

public abstract class BaseDataStoreTest
extends Assert {
    private static final Logger log = LoggerFactory.getLogger((String)"IDataStoreTest");
    private static final Random random = new Random();
    private static final int FILE_SIZE_MIN = 204800;
    private static final int FILE_SIZE_MAX = 307200;
    private static final int SESSION_COUNT = 50;
    private static final int FILES_COUNT = 1000;
    private static final int WAIT_TIME = 1;
    private static final int THREAD_COUNT = 20;
    private static final int READ_MODULO = 100;
    private final Map<String, AtomicInteger> sessionCounter = new ConcurrentHashMap<String, AtomicInteger>();
    private final ConcurrentLinkedQueue<File> filesToSave = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<File> filesToRead1 = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<File> filesToRead2 = new ConcurrentLinkedQueue();
    private final AtomicInteger read1Count = new AtomicInteger(0);
    private final AtomicInteger read2Count = new AtomicInteger(0);
    private final AtomicInteger saveCount = new AtomicInteger(0);
    private final AtomicBoolean saveDone = new AtomicBoolean(false);
    private final AtomicBoolean read1Done = new AtomicBoolean(false);
    private final AtomicBoolean read2Done = new AtomicBoolean(false);
    private final AtomicInteger failures = new AtomicInteger();
    private final AtomicInteger bytesWritten = new AtomicInteger(0);
    private final AtomicInteger bytesRead = new AtomicInteger(0);
    private final AtomicInteger saveTime = new AtomicInteger(0);
    private volatile RuntimeException exceptionThrownByThread;
    private IDataStore dataStore;

    private String randomSessionId() {
        ArrayList<String> s = new ArrayList<String>(this.sessionCounter.keySet());
        return (String)s.get(random.nextInt(s.size()));
    }

    private int nextSessionId(String sessionId) {
        AtomicInteger i = this.sessionCounter.get(sessionId);
        return i.incrementAndGet();
    }

    private void generateFiles() {
        int i;
        for (i = 0; i < 50; ++i) {
            this.sessionCounter.put(UUID.randomUUID().toString(), new AtomicInteger(0));
        }
        for (i = 0; i < 1000; ++i) {
            String session = this.randomSessionId();
            File file = new File(session, this.nextSessionId(session));
            long now = System.nanoTime();
            this.filesToSave.add(file);
            long duration = System.nanoTime() - now;
            this.saveTime.addAndGet((int)duration);
        }
    }

    private void doTestDataStore() {
        int i;
        log.info("Starting...");
        long start = System.currentTimeMillis();
        for (i = 0; i < 20; ++i) {
            new Thread(new Read1Runnable()).start();
        }
        for (i = 0; i < 20; ++i) {
            new Thread(new Read2Runnable()).start();
        }
        for (i = 0; i < 20; ++i) {
            new Thread(new SaveRunnable()).start();
        }
        while (!(this.read1Done.get() && this.read2Done.get() && this.saveDone.get())) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (this.exceptionThrownByThread != null) {
            throw new RuntimeException("One of the worker threads failed.", this.exceptionThrownByThread);
        }
        long duration = System.currentTimeMillis() - start;
        log.info("Took: " + duration + " ms");
        log.info("Save: " + this.saveCount.intValue() + " files, " + this.bytesWritten.get() + " bytes");
        log.info("Read: " + (this.read1Count.get() + this.read2Count.get()) + " files, " + this.bytesRead.get() + " bytes");
        log.info("Average save time (ns): " + (double)this.saveTime.get() / (double)this.saveCount.get());
        BaseDataStoreTest.assertEquals((long)0L, (long)this.failures.get());
        for (String s : this.sessionCounter.keySet()) {
            this.dataStore.removeData(s);
        }
    }

    @Test
    public void load() throws Exception {
        if (this.isEnabled()) {
            this.generateFiles();
            this.dataStore = this.createDataStore();
            this.dataStore = new SessionQuotaManagingDataStore(this.dataStore, Bytes.megabytes((long)100L));
            this.doTestDataStore();
            this.dataStore.destroy();
        }
    }

    protected abstract IDataStore createDataStore() throws Exception;

    protected abstract boolean isEnabled();

    private class Read2Runnable
    extends ExceptionCapturingRunnable {
        private Read2Runnable() {
        }

        @Override
        protected void doRun() {
            File file;
            while ((file = (File)BaseDataStoreTest.this.filesToRead2.poll()) != null || !BaseDataStoreTest.this.read1Done.get()) {
                if (file != null) {
                    byte[] bytes = BaseDataStoreTest.this.dataStore.getData(file.getSessionId(), file.getId());
                    if (!file.checkData(bytes)) {
                        BaseDataStoreTest.this.failures.incrementAndGet();
                        log.error("Detected error number: " + BaseDataStoreTest.this.failures.get());
                    }
                    BaseDataStoreTest.this.read2Count.incrementAndGet();
                    BaseDataStoreTest.this.bytesRead.addAndGet(bytes.length);
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            BaseDataStoreTest.this.read2Done.set(true);
        }
    }

    private class Read1Runnable
    extends ExceptionCapturingRunnable {
        private Read1Runnable() {
        }

        @Override
        protected void doRun() {
            File file;
            while ((file = (File)BaseDataStoreTest.this.filesToRead1.poll()) != null || !BaseDataStoreTest.this.saveDone.get()) {
                if (file != null) {
                    byte[] bytes = BaseDataStoreTest.this.dataStore.getData(file.getSessionId(), file.getId());
                    if (!file.checkData(bytes)) {
                        BaseDataStoreTest.this.failures.incrementAndGet();
                        log.error("Detected error number: " + BaseDataStoreTest.this.failures.get());
                    }
                    BaseDataStoreTest.this.filesToRead2.add(file);
                    BaseDataStoreTest.this.read1Count.incrementAndGet();
                    BaseDataStoreTest.this.bytesRead.addAndGet(bytes.length);
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            BaseDataStoreTest.this.read1Done.set(true);
        }
    }

    private class SaveRunnable
    extends ExceptionCapturingRunnable {
        private SaveRunnable() {
        }

        @Override
        protected void doRun() {
            File file;
            while ((file = (File)BaseDataStoreTest.this.filesToSave.poll()) != null || BaseDataStoreTest.this.saveCount.get() < 1000) {
                if (file != null) {
                    byte[] data = file.generateData();
                    BaseDataStoreTest.this.dataStore.storeData(file.getSessionId(), file.getId(), data);
                    if (BaseDataStoreTest.this.saveCount.get() % 100 == 0) {
                        BaseDataStoreTest.this.filesToRead1.add(file);
                    }
                    BaseDataStoreTest.this.saveCount.incrementAndGet();
                    BaseDataStoreTest.this.bytesWritten.addAndGet(data.length);
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            BaseDataStoreTest.this.saveDone.set(true);
        }
    }

    private abstract class ExceptionCapturingRunnable
    implements Runnable {
        private ExceptionCapturingRunnable() {
        }

        @Override
        public final void run() {
            block2: {
                try {
                    this.doRun();
                }
                catch (RuntimeException e) {
                    if (BaseDataStoreTest.this.exceptionThrownByThread != null) break block2;
                    BaseDataStoreTest.this.exceptionThrownByThread = e;
                }
            }
        }

        protected abstract void doRun();
    }

    private static class File {
        private final String sessionId;
        private final int id;
        private byte first;
        private byte last;
        private int length;

        public File(String sessionId, int id) {
            this.sessionId = sessionId;
            this.id = id;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public int getId() {
            return this.id;
        }

        public byte[] generateData() {
            this.length = 204800 + random.nextInt(102400);
            byte[] data = new byte[this.length];
            random.nextBytes(data);
            this.first = data[0];
            this.last = data[data.length - 1];
            return data;
        }

        public boolean checkData(byte[] data) {
            if (data == null) {
                log.error("data[] should never be null");
                return false;
            }
            if (data.length != this.length) {
                log.error("data.length != length");
                return false;
            }
            if (this.first != data[0]) {
                log.error("first != data[0]");
                return false;
            }
            if (this.last != data[data.length - 1]) {
                log.error("last != data[data.length - 1]");
                return false;
            }
            return true;
        }
    }
}

