/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.event;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.wicketstuff.openlayers.IOpenLayersMap;
import org.wicketstuff.openlayers.OpenLayersMapUtils;

public abstract class DrawListenerBehavior
extends AbstractDefaultAjaxBehavior {
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderOnDomReadyJavascript(this.getJSaddListener());
    }

    protected void onBind() {
        if (!(this.getComponent() instanceof IOpenLayersMap)) {
            throw new IllegalArgumentException("must be bound to Openlayers map");
        }
    }

    public String getJSaddListener() {
        return this.getOpenLayersMap().getJSinvoke("addDrawFeature('" + this.getCallbackUrl() + "')");
    }

    protected final IOpenLayersMap getOpenLayersMap() {
        return (IOpenLayersMap)this.getComponent();
    }

    protected final void respond(AjaxRequestTarget target) {
        this.onEvent(target);
    }

    protected void onEvent(AjaxRequestTarget target) throws RuntimeException {
        Request request = RequestCycle.get().getRequest();
        String wkt = request.getParameter("wkt");
        WKTReader wktReader = new WKTReader(OpenLayersMapUtils.getGeoFactory());
        Geometry geom = null;
        try {
            geom = wktReader.read(wkt);
        }
        catch (ParseException e) {
            throw new RuntimeException("Could not parse wkt", e);
        }
        this.onDrawEnded(geom, target);
    }

    protected abstract void onDrawEnded(Geometry var1, AjaxRequestTarget var2);
}

