/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers.api;

import com.vividsolutions.jts.geom.Point;
import java.util.StringTokenizer;
import org.wicketstuff.openlayers.OpenLayersMapUtils;
import org.wicketstuff.openlayers.api.Value;
import org.wicketstuff.openlayers.js.Constructor;

public class LonLat
implements Value {
    private static final long serialVersionUID = 1L;
    private final Point point;

    public LonLat(double lng, double lat) {
        this.point = OpenLayersMapUtils.createPoint(lng, lat);
    }

    public LonLat(Point point) {
        this.point = point;
    }

    public double getLat() {
        return this.point.getY();
    }

    public double getLng() {
        return this.point.getX();
    }

    public String toString() {
        return this.getJSconstructor();
    }

    public String getJSconstructor() {
        return new Constructor("OpenLayers.LonLat").add(this.getLng()).add(this.getLat()).toJS();
    }

    public int hashCode() {
        return new Double(this.getLat()).hashCode() ^ new Double(this.getLng()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LonLat) {
            LonLat t = (LonLat)obj;
            return t.getLat() == this.getLat() && t.getLng() == this.getLng();
        }
        return false;
    }

    public Point getPoint() {
        return this.point;
    }

    public static LonLat parse(String value) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, "(, )");
            float lat = Float.valueOf(tokenizer.nextToken()).floatValue();
            float lng = Float.valueOf(tokenizer.nextToken()).floatValue();
            return new LonLat(lat, lng);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static LonLat parseWithNames(String value) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, "(, )");
            float lng = 0.0f;
            float lat = 0.0f;
            for (int i = 0; i < 2; ++i) {
                String item = tokenizer.nextToken().toLowerCase();
                if (item.startsWith("lon=")) {
                    lng = Float.parseFloat(item.substring(4));
                    continue;
                }
                if (item.startsWith("lat=")) {
                    lat = Float.parseFloat(item.substring(4));
                    continue;
                }
                return null;
            }
            return new LonLat(lng, lat);
        }
        catch (Exception e) {
            return null;
        }
    }
}

