/*
 * Decompiled with CFR 0.152.
 */
package org.webframe.test.web;

import java.net.URL;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.providers.ContextProvider;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;

public class WFJettyContextProvider
extends ContextProvider {
    public ContextHandler createContextHandler(App app) throws Exception {
        String filename = app.getOriginId();
        if (filename != null && filename.startsWith("jar:")) {
            return this.jarResourceXml(new URL(filename));
        }
        return super.createContextHandler(app);
    }

    protected void doStart() throws Exception {
        super.doStart();
        Resource resource = this.getMonitoredDirResource();
        if (resource instanceof JarResource) {
            this.fileAdded(resource.getName());
        }
    }

    protected ContextHandler jarResourceXml(URL url) throws Exception {
        XmlConfiguration xmlc = new XmlConfiguration(url);
        xmlc.getIdMap().put("Server", this.getDeploymentManager().getServer());
        if (this.getConfigurationManager() != null) {
            xmlc.getProperties().putAll(this.getConfigurationManager().getProperties());
        }
        return (ContextHandler)xmlc.configure();
    }
}

