/*
 * Decompiled with CFR 0.152.
 */
package org.webframe.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.webframe.test.web.BaseWebServerTests;

public class BaseHttpClientTests
extends BaseWebServerTests {
    protected static final String defaultEncode = "UTF-8";
    protected static final DefaultHttpClient client = new DefaultHttpClient();
    private HttpContext context = null;
    private static Map<String, Boolean> userOnceMap = new HashMap<String, Boolean>();

    protected String getBaseUrl() {
        return this.getServerURL();
    }

    protected String getUrl(String url) {
        String baseUrl = this.getBaseUrl();
        if (url == null) {
            return baseUrl;
        }
        if (url.toLowerCase().startsWith("http:") || url.toLowerCase().startsWith("https:")) {
            baseUrl = "";
        }
        return baseUrl + url;
    }

    protected final HttpGet getHttpGet(String url) {
        return new HttpGet(this.getUrl(url));
    }

    protected final HttpPost getHttpPost(String url) {
        return new HttpPost(this.getUrl(url));
    }

    protected String sendGet(String url) throws Exception {
        return this.getResponseContent(this.executeGet(url));
    }

    protected String sendPost(String url, Map<String, Object> params) throws Exception {
        return this.sendPost(url, this.getPairs(params));
    }

    protected String sendPost(String url, List<NameValuePair> params) throws Exception {
        return this.getResponseContent(this.executePost(url, params));
    }

    protected HttpResponse executeGet(String url) throws Exception {
        HttpGet httpRequest = this.getHttpGet(url);
        return client.execute((HttpUriRequest)httpRequest, this.context);
    }

    protected HttpResponse executePost(String url, Map<String, Object> params) throws Exception {
        return this.executePost(url, this.getPairs(params));
    }

    protected HttpResponse executePost(String url, List<NameValuePair> params) throws Exception {
        HttpPost httpRequest = this.getHttpPost(url);
        UrlEncodedFormEntity httpentity = new UrlEncodedFormEntity(params, defaultEncode);
        httpRequest.setEntity((HttpEntity)httpentity);
        return client.execute((HttpUriRequest)httpRequest, this.context);
    }

    protected String getResponseContent(HttpResponse res) throws Exception {
        HttpEntity httpEntity = res.getEntity();
        return EntityUtils.toString((HttpEntity)httpEntity, (String)defaultEncode);
    }

    protected String getUrlParamsString(Map<String, Object> params) {
        return this.getUrlParamsString(this.getPairs(params));
    }

    protected String getUrlParamsString(List<NameValuePair> params) {
        return URLEncodedUtils.format(params, (String)defaultEncode);
    }

    protected final List<NameValuePair> getPairs(Map<String, Object> params) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        if (params != null) {
            for (String key : params.keySet()) {
                Object value = params.get(key);
                String sv = value == null ? "null" : value.toString();
                nameValuePairs.add((NameValuePair)new BasicNameValuePair(key, sv));
            }
        }
        return nameValuePairs;
    }

    protected void setContext(HttpContext context) {
        this.context = context;
    }

    protected final HttpContext getContext() {
        return this.context;
    }

    protected final void enableAuth(String usernamePassword) {
        client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(usernamePassword));
    }

    protected void login() throws Exception {
        this.login("/j_spring_security_check", "admin:1");
    }

    protected void login(String loginUrl, String usernamePassword) throws Exception {
        if (usernamePassword == null) {
            throw new IllegalArgumentException("Username:password string may not be null!");
        }
        HashMap<String, Object> user = new HashMap<String, Object>();
        int index = usernamePassword.indexOf(58);
        if (index >= 0) {
            user.put("j_username", usernamePassword.substring(0, index));
            user.put("j_password", usernamePassword.substring(index + 1));
        } else {
            user.put("j_username", "usernamePassword");
            user.put("j_password", null);
        }
        this.login(loginUrl, user);
    }

    protected void login(String loginUrl, Map<String, Object> user) throws Exception {
        if (user == null) {
            throw new IllegalArgumentException("user map may not be null!");
        }
        if (userOnceMap.get(user.toString()) != null) {
            return;
        }
        HttpResponse response = this.executePost(loginUrl, user);
        EntityUtils.consume((HttpEntity)response.getEntity());
        userOnceMap.put(user.toString(), true);
    }
}

