/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import java.security.SignatureException;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

public interface SignatureDataOperations {
    public static final int CHAIN_ID_INC = 35;
    public static final int LOWER_REAL_V = 27;

    public Sign.SignatureData getSignatureData();

    public byte[] getEncodedTransaction(Integer var1);

    default public String getFrom() throws SignatureException {
        byte[] encodedTransaction = this.getEncodedTransaction(this.getChainId());
        BigInteger v = Numeric.toBigInt((byte[])this.getSignatureData().getV());
        byte[] r = this.getSignatureData().getR();
        byte[] s = this.getSignatureData().getS();
        Sign.SignatureData signatureDataV = new Sign.SignatureData(this.getRealV(v), r, s);
        BigInteger key = Sign.signedMessageToKey(encodedTransaction, signatureDataV);
        return "0x" + Keys.getAddress(key);
    }

    default public void verify(String from) throws SignatureException {
        String actualFrom = this.getFrom();
        if (!actualFrom.equals(from)) {
            throw new SignatureException("from mismatch");
        }
    }

    default public byte getRealV(BigInteger bv) {
        long v = bv.longValue();
        if (v == 27L || v == 28L) {
            return (byte)v;
        }
        int realV = 27;
        int inc = 0;
        if ((int)v % 2 == 0) {
            inc = 1;
        }
        return (byte)(realV + inc);
    }

    default public Integer getChainId() {
        BigInteger bv = Numeric.toBigInt((byte[])this.getSignatureData().getV());
        long v = bv.longValue();
        if (v == 27L || v == 28L) {
            return null;
        }
        Integer chainId = (int)((v - 35L) / 2L);
        return chainId;
    }
}

