/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java.javax;

import javax.usb.UsbDevice;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbServices;
import javax.usb.event.UsbServicesEvent;
import javax.usb.event.UsbServicesListener;
import org.usb4java.Loader;
import org.usb4java.javax.Config;
import org.usb4java.javax.DeviceManager;
import org.usb4java.javax.RootHub;
import org.usb4java.javax.ServicesException;
import org.usb4java.javax.ServicesListenerList;

public final class Services
implements UsbServices {
    private static final String IMP_DESCRIPTION = "usb4java";
    private static final String IMP_VERSION = "1.2.0";
    private static final String API_VERSION = "1.0.2";
    private final ServicesListenerList listeners = new ServicesListenerList();
    private final RootHub rootHub;
    private final DeviceManager deviceManager;
    private final Config config = new Config(UsbHostManager.getProperties());

    public Services() throws UsbException {
        Loader.load();
        this.rootHub = new RootHub();
        this.deviceManager = new DeviceManager(this.rootHub, this.config.getScanInterval());
        this.deviceManager.start();
    }

    public UsbHub getRootUsbHub() {
        this.deviceManager.firstScan();
        return this.rootHub;
    }

    public void addUsbServicesListener(UsbServicesListener listener) {
        this.listeners.add(listener);
    }

    public void removeUsbServicesListener(UsbServicesListener listener) {
        this.listeners.remove(listener);
    }

    public String getApiVersion() {
        return API_VERSION;
    }

    public String getImpVersion() {
        return IMP_VERSION;
    }

    public String getImpDescription() {
        return IMP_DESCRIPTION;
    }

    void usbDeviceAttached(UsbDevice device) {
        this.listeners.usbDeviceAttached(new UsbServicesEvent((UsbServices)this, device));
    }

    void usbDeviceDetached(UsbDevice device) {
        this.listeners.usbDeviceDetached(new UsbServicesEvent((UsbServices)this, device));
    }

    Config getConfig() {
        return this.config;
    }

    static Services getInstance() {
        try {
            return (Services)UsbHostManager.getUsbServices();
        }
        catch (ClassCastException e) {
            throw new ServicesException("Looks like usb4java is not the configured USB services implementation: " + e, e);
        }
        catch (UsbException e) {
            throw new ServicesException("Unable to create USB services: " + (Object)((Object)e), e);
        }
    }

    public void scan() {
        this.deviceManager.scan();
    }
}

