/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.reservation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.studentsct.model.AcademicAreaCode;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.reservation.Reservation;

public class CurriculumReservation
extends Reservation {
    private double iLimit;
    private String iAcadArea;
    private Set<String> iClassifications = new HashSet<String>();
    private Set<String> iMajors = new HashSet<String>();
    public static final int DEFAULT_PRIORITY = 500;
    public static final boolean DEFAULT_MUST_BE_USED = false;
    public static final boolean DEFAULT_CAN_ASSIGN_OVER_LIMIT = false;
    public static final boolean DEFAULT_ALLOW_OVERLAP = false;

    public CurriculumReservation(long id, double limit, Offering offering, String acadArea, Collection<String> classifications, Collection<String> majors) {
        super(id, offering, 500, false, false, false);
        this.iLimit = limit;
        this.iAcadArea = acadArea;
        if (classifications != null) {
            this.iClassifications.addAll(classifications);
        }
        if (majors != null) {
            this.iMajors.addAll(majors);
        }
    }

    @Override
    public double getReservationLimit() {
        return this.iLimit;
    }

    public void setReservationLimit(double limit) {
        this.iLimit = limit;
    }

    public String getAcademicArea() {
        return this.iAcadArea;
    }

    public Set<String> getMajors() {
        return this.iMajors;
    }

    public Set<String> getClassifications() {
        return this.iClassifications;
    }

    @Override
    public boolean isApplicable(Student student) {
        boolean match = false;
        if (student.getAcademicAreaClasiffications() == null) {
            return false;
        }
        for (AcademicAreaCode aac : student.getAcademicAreaClasiffications()) {
            if (!this.getAcademicArea().equals(aac.getArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(aac.getCode())) continue;
            match = true;
            break;
        }
        if (!match) {
            return false;
        }
        for (AcademicAreaCode aac : student.getMajors()) {
            if (!this.getAcademicArea().equals(aac.getArea()) || !this.getMajors().isEmpty() && !this.getMajors().contains(aac.getCode())) continue;
            return true;
        }
        return this.getMajors().isEmpty();
    }
}

