/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.report;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.constraint.SectionLimit;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.report.CourseSection;
import org.cpsolver.studentsct.report.StudentSectioningReport;

public class SectionConflictTable
implements StudentSectioningReport {
    private static DecimalFormat sDF1 = new DecimalFormat("0.####");
    private static DecimalFormat sDF2 = new DecimalFormat("0.0000");
    private StudentSectioningModel iModel = null;
    private Type iType;
    private boolean iOverlapsAllEnrollments = true;

    public SectionConflictTable(StudentSectioningModel model, Type type) {
        this.iModel = model;
        this.iType = type;
    }

    public SectionConflictTable(StudentSectioningModel model) {
        this(model, Type.OVERLAPS_AND_UNAVAILABILITIES);
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    private boolean canIgnore(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Section section, List<Enrollment> other) {
        block0: for (Enrollment e : other) {
            Section a = null;
            for (Section s : e.getSections()) {
                if (s.getSubpart().equals(section.getSubpart())) {
                    if (s.equals(section)) continue block0;
                    a = s;
                    continue;
                }
                if (enrollment.getSections().contains(s)) continue;
                continue block0;
            }
            if (a == null) continue;
            for (Request r : enrollment.getStudent().getRequests()) {
                Enrollment curr = assignment.getValue(r);
                if (enrollment.getRequest().equals(r) || curr == null || !(r instanceof CourseRequest) || curr.isAllowOverlap()) continue;
                for (Section b : curr.getSections()) {
                    if (b.isAllowOverlap() || b.isToIgnoreStudentConflictsWith(section.getId()) || b.getTime() == null || a.getTime() == null || a.isAllowOverlap() || !b.getTime().hasIntersection(a.getTime())) continue;
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public CSVFile createTable(Assignment<Request, Enrollment> assignment, boolean includeLastLikeStudents, boolean includeRealStudents, boolean useAmPm) {
        HashMap unavailabilities = new HashMap();
        HashMap totals = new HashMap();
        HashMap conflictingPairs = new HashMap();
        HashMap<CourseSection, Double> sectionOverlaps = new HashMap<CourseSection, Double>();
        for (Request request : new ArrayList<Request>(this.getModel().unassignedVariables(assignment))) {
            Object total;
            CourseRequest courseRequest;
            if (request.getStudent().isDummy() && !includeLastLikeStudents || !request.getStudent().isDummy() && !includeRealStudents || !(request instanceof CourseRequest) || (courseRequest = (CourseRequest)request).getStudent().isComplete(assignment)) continue;
            List<Enrollment> values = courseRequest.values(assignment);
            SectionLimit limitConstraint = null;
            for (GlobalConstraint c : this.getModel().globalConstraints()) {
                if (!(c instanceof SectionLimit)) continue;
                limitConstraint = (SectionLimit)c;
                break;
            }
            if (limitConstraint == null) {
                limitConstraint = new SectionLimit(new DataProperties());
                limitConstraint.setModel(this.getModel());
            }
            ArrayList<Enrollment> notAvailableValues = new ArrayList<Enrollment>(values.size());
            List<Object> availableValues = new ArrayList(values.size());
            for (Enrollment enrollment : values) {
                if (limitConstraint.inConflict(assignment, enrollment)) {
                    notAvailableValues.add(enrollment);
                    continue;
                }
                availableValues.add(enrollment);
            }
            if (!notAvailableValues.isEmpty() && this.iType.hasUnavailabilities()) {
                HashMap<Section, Double[]> sections;
                HashSet<CourseSection> ones;
                ArrayList<Enrollment> notOverlappingEnrollments = new ArrayList<Enrollment>(values.size());
                block3: for (Enrollment enrollment : notAvailableValues) {
                    for (Request request2 : request.getStudent().getRequests()) {
                        if (request2.equals(request) || assignment.getValue(request2) == null || request2 instanceof FreeTimeRequest || !assignment.getValue(request2).isOverlapping(enrollment)) continue;
                        continue block3;
                    }
                    notOverlappingEnrollments.add(enrollment);
                }
                if (notOverlappingEnrollments.isEmpty() && availableValues.isEmpty() && this.iOverlapsAllEnrollments) {
                    double fraction = request.getWeight() / (double)notAvailableValues.size();
                    ones = new HashSet();
                    for (Enrollment enrollment : notAvailableValues) {
                        boolean hasConflict = false;
                        for (Section s : enrollment.getSections()) {
                            if (s.getLimit() < 0 || !(s.getEnrollmentWeight(assignment, request) + request.getWeight() > (double)s.getLimit())) continue;
                            hasConflict = true;
                            break;
                        }
                        if ((sections = (Map)unavailabilities.get(enrollment.getCourse())) == null) {
                            sections = new HashMap();
                            unavailabilities.put(enrollment.getCourse(), sections);
                        }
                        for (Section s : enrollment.getSections()) {
                            if (hasConflict && s.getLimit() < 0 || s.getEnrollmentWeight(assignment, request) + request.getWeight() <= (double)s.getLimit()) continue;
                            Double[] total2 = (Double[])sections.get(s);
                            sections.put(s, new Double[]{fraction + (total2 == null ? 0.0 : total2[0]), total2 == null ? 0.0 : total2[1]});
                            ones.add(new CourseSection(enrollment.getCourse(), s));
                        }
                        total = (Set)totals.get(enrollment.getCourse());
                        if (total == null) {
                            total = new HashSet();
                            totals.put(enrollment.getCourse(), total);
                        }
                        total.add(enrollment.getStudent().getId());
                    }
                } else if (!notOverlappingEnrollments.isEmpty()) {
                    double fraction = request.getWeight() / (double)notOverlappingEnrollments.size();
                    ones = new HashSet<CourseSection>();
                    for (Enrollment enrollment : notOverlappingEnrollments) {
                        boolean hasConflict = false;
                        for (Section s : enrollment.getSections()) {
                            if (s.getLimit() < 0 || !(s.getEnrollmentWeight(assignment, request) + request.getWeight() > (double)s.getLimit())) continue;
                            hasConflict = true;
                            break;
                        }
                        if ((sections = (HashMap<Section, Double[]>)unavailabilities.get(enrollment.getCourse())) == null) {
                            sections = new HashMap<Section, Double[]>();
                            unavailabilities.put(enrollment.getCourse(), sections);
                        }
                        for (Section s : enrollment.getSections()) {
                            if (hasConflict && s.getLimit() < 0 || s.getEnrollmentWeight(assignment, request) + request.getWeight() <= (double)s.getLimit()) continue;
                            Double[] total2 = (Double[])sections.get(s);
                            sections.put(s, new Double[]{fraction + (total2 == null ? 0.0 : total2[0]), total2 == null ? 0.0 : total2[1]});
                            ones.add(new CourseSection(enrollment.getCourse(), s));
                        }
                        total = (Set)totals.get(enrollment.getCourse());
                        if (total == null) {
                            total = new HashSet<Long>();
                            totals.put(enrollment.getCourse(), total);
                        }
                        total.add(enrollment.getStudent().getId());
                    }
                    for (CourseSection courseSection : ones) {
                        Map sections2 = (Map)unavailabilities.get(courseSection.getCourse());
                        Double[] total3 = (Double[])sections2.get(courseSection.getSection());
                        sections2.put(courseSection.getSection(), new Double[]{total3 == null ? 0.0 : total3[0], request.getWeight() + (total3 == null ? 0.0 : total3[1])});
                    }
                }
            }
            if (this.iOverlapsAllEnrollments) {
                availableValues = values;
            }
            if (availableValues.isEmpty() || !this.iType.hasOverlaps()) continue;
            ArrayList conflicts = new ArrayList();
            for (Enrollment enrollment : availableValues) {
                void var20_40;
                HashMap<CourseSection, ArrayList<CourseSection>> overlaps = new HashMap<CourseSection, ArrayList<CourseSection>>();
                for (Request request3 : request.getStudent().getRequests()) {
                    Enrollment otherEnrollment = assignment.getValue(request3);
                    if (request3.equals(request) || otherEnrollment == null || request3 instanceof FreeTimeRequest || !enrollment.isOverlapping(otherEnrollment)) continue;
                    for (Section a : enrollment.getSections()) {
                        for (Section b : otherEnrollment.getSections()) {
                            if (a.getTime() == null || b.getTime() == null || a.isAllowOverlap() || b.isAllowOverlap() || a.isToIgnoreStudentConflictsWith(b.getId()) || !a.getTime().hasIntersection(b.getTime()) || this.canIgnore(assignment, enrollment, a, availableValues)) continue;
                            ArrayList<CourseSection> x = (ArrayList<CourseSection>)overlaps.get(new CourseSection(enrollment.getCourse(), a));
                            if (x == null) {
                                x = new ArrayList<CourseSection>();
                                overlaps.put(new CourseSection(enrollment.getCourse(), a), x);
                            }
                            x.add(new CourseSection(otherEnrollment.getCourse(), b));
                        }
                    }
                }
                if (overlaps.isEmpty()) continue;
                conflicts.add(overlaps);
                Set set = (Set)totals.get(enrollment.getCourse());
                if (set == null) {
                    HashSet hashSet = new HashSet();
                    totals.put(enrollment.getCourse(), hashSet);
                }
                var20_40.add(enrollment.getStudent().getId());
            }
            double fraction = request.getWeight() / (double)conflicts.size();
            for (Map map : conflicts) {
                for (Map.Entry entry : map.entrySet()) {
                    CourseSection a;
                    total = (Double)sectionOverlaps.get(a = (CourseSection)entry.getKey());
                    sectionOverlaps.put(a, fraction + (total == null ? 0.0 : (Double)total));
                    HashMap<CourseSection, Double> pair = (HashMap<CourseSection, Double>)conflictingPairs.get(a);
                    if (pair == null) {
                        pair = new HashMap<CourseSection, Double>();
                        conflictingPairs.put(a, pair);
                    }
                    Iterator<Object> i$ = ((List)entry.getValue()).iterator();
                    while (i$.hasNext()) {
                        CourseSection b;
                        Double prev = (Double)pair.get(b = (CourseSection)i$.next());
                        pair.put(b, fraction + (prev == null ? 0.0 : prev));
                    }
                }
            }
        }
        Comparator<Course> courseComparator = new Comparator<Course>(){

            @Override
            public int compare(Course a, Course b) {
                int cmp = a.getName().compareTo(b.getName());
                if (cmp != 0) {
                    return cmp;
                }
                return a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1);
            }
        };
        Comparator<Section> sectionComparator = new Comparator<Section>(){

            @Override
            public int compare(Section a, Section b) {
                int cmp = a.getSubpart().getConfig().getOffering().getName().compareTo(b.getSubpart().getConfig().getOffering().getName());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = a.getSubpart().getInstructionalType().compareTo(b.getSubpart().getInstructionalType());
                if (cmp != 0) {
                    return cmp;
                }
                return a.getId() < b.getId() ? -1 : (a.getId() == b.getId() ? 0 : 1);
            }
        };
        CSVFile csv = new CSVFile();
        ArrayList<CSVFile.CSVField> headers = new ArrayList<CSVFile.CSVField>();
        headers.add(new CSVFile.CSVField("Course"));
        headers.add(new CSVFile.CSVField("Total\nConflicts"));
        if (this.iType.hasUnavailabilities()) {
            headers.add(new CSVFile.CSVField("Course\nEnrollment"));
            headers.add(new CSVFile.CSVField("Course\nLimit"));
        }
        headers.add(new CSVFile.CSVField("Class"));
        headers.add(new CSVFile.CSVField("Meeting Time"));
        if (this.iType.hasUnavailabilities()) {
            headers.add(new CSVFile.CSVField("Availability\nConflicts"));
            headers.add(new CSVFile.CSVField("% of Total\nConflicts"));
        }
        if (this.iType.hasOverlaps()) {
            headers.add(new CSVFile.CSVField("Time\nConflicts"));
            headers.add(new CSVFile.CSVField("% of Total\nConflicts"));
        }
        if (this.iType.hasUnavailabilities()) {
            headers.add(new CSVFile.CSVField("Class\nEnrollment"));
            headers.add(new CSVFile.CSVField("Class\nLimit"));
            if (!this.iType.hasOverlaps()) {
                headers.add(new CSVFile.CSVField("Class\nPotential"));
            }
        }
        if (this.iType.hasOverlaps()) {
            headers.add(new CSVFile.CSVField("Conflicting\nClass"));
            headers.add(new CSVFile.CSVField("Conflicting\nMeeting Time"));
            headers.add(new CSVFile.CSVField("Joined\nConflicts"));
            headers.add(new CSVFile.CSVField("% of Total\nConflicts"));
        }
        csv.setHeader(headers);
        TreeSet<Course> courses = new TreeSet<Course>(courseComparator);
        courses.addAll(totals.keySet());
        for (Course course : courses) {
            Map sectionUnavailability = (Map)unavailabilities.get(course);
            Set total = (Set)totals.get(course);
            TreeSet<Section> treeSet = new TreeSet<Section>(sectionComparator);
            if (sectionUnavailability != null) {
                treeSet.addAll(sectionUnavailability.keySet());
            }
            for (Map.Entry entry : sectionOverlaps.entrySet()) {
                if (!course.equals(((CourseSection)entry.getKey()).getCourse())) continue;
                treeSet.add(((CourseSection)entry.getKey()).getSection());
            }
            boolean firstCourse = true;
            for (Section section : treeSet) {
                Double[] sectionUnavailable = sectionUnavailability == null ? null : (Double[])sectionUnavailability.get(section);
                Double sectionOverlap = (Double)sectionOverlaps.get(new CourseSection(course, section));
                Map pair = (Map)conflictingPairs.get(new CourseSection(course, section));
                if (pair == null) {
                    ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                    line.add(new CSVFile.CSVField(firstCourse ? course.getName() : ""));
                    line.add(new CSVFile.CSVField(firstCourse ? Integer.valueOf(total.size()) : ""));
                    if (this.iType.hasUnavailabilities()) {
                        line.add(new CSVFile.CSVField(firstCourse ? sDF1.format(course.getEnrollmentWeight(assignment, null)) : ""));
                        line.add(new CSVFile.CSVField(firstCourse ? (course.getLimit() < 0 ? "" : String.valueOf(course.getLimit())) : ""));
                    }
                    line.add(new CSVFile.CSVField(section.getSubpart().getName() + " " + section.getName(course.getId())));
                    line.add(new CSVFile.CSVField(section.getTime() == null ? "" : section.getTime().getDayHeader() + " " + section.getTime().getStartTimeHeader(useAmPm) + " - " + section.getTime().getEndTimeHeader(useAmPm)));
                    if (this.iType.hasUnavailabilities()) {
                        line.add(new CSVFile.CSVField(sectionUnavailable != null ? sDF2.format(sectionUnavailable[0]) : ""));
                        line.add(new CSVFile.CSVField(sectionUnavailable != null ? sDF2.format(sectionUnavailable[0] / (double)total.size()) : ""));
                    }
                    if (this.iType.hasOverlaps()) {
                        line.add(new CSVFile.CSVField(sectionOverlap != null ? sDF2.format(sectionOverlap) : ""));
                        line.add(new CSVFile.CSVField(sectionOverlap != null ? sDF2.format(sectionOverlap / (double)total.size()) : ""));
                    }
                    if (this.iType.hasUnavailabilities()) {
                        line.add(new CSVFile.CSVField(sDF1.format(section.getEnrollmentWeight(assignment, null))));
                        line.add(new CSVFile.CSVField(section.getLimit() < 0 ? "" : String.valueOf(section.getLimit())));
                        if (!this.iType.hasOverlaps()) {
                            line.add(new CSVFile.CSVField(sectionUnavailable != null ? sDF1.format(sectionUnavailable[1]) : ""));
                        }
                    }
                    csv.addLine(line);
                } else {
                    boolean firstClass = true;
                    for (CourseSection other : new TreeSet(pair.keySet())) {
                        ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                        line.add(new CSVFile.CSVField(firstCourse && firstClass ? course.getName() : ""));
                        line.add(new CSVFile.CSVField(firstCourse && firstClass ? Integer.valueOf(total.size()) : ""));
                        if (this.iType.hasUnavailabilities()) {
                            line.add(new CSVFile.CSVField(firstCourse && firstClass ? sDF1.format(course.getEnrollmentWeight(assignment, null)) : ""));
                            line.add(new CSVFile.CSVField(firstCourse && firstClass ? (course.getLimit() < 0 ? "" : String.valueOf(course.getLimit())) : ""));
                        }
                        line.add(new CSVFile.CSVField(firstClass ? section.getSubpart().getName() + " " + section.getName(course.getId()) : ""));
                        line.add(new CSVFile.CSVField(firstClass ? (section.getTime() == null ? "" : section.getTime().getDayHeader() + " " + section.getTime().getStartTimeHeader(useAmPm) + " - " + section.getTime().getEndTimeHeader(useAmPm)) : ""));
                        if (this.iType.hasUnavailabilities()) {
                            line.add(new CSVFile.CSVField(firstClass && sectionUnavailable != null ? sDF2.format(sectionUnavailable[0]) : ""));
                            line.add(new CSVFile.CSVField(sectionUnavailable != null ? sDF2.format(sectionUnavailable[0] / (double)total.size()) : ""));
                        }
                        line.add(new CSVFile.CSVField(firstClass && sectionOverlap != null ? sDF2.format(sectionOverlap) : ""));
                        line.add(new CSVFile.CSVField(firstClass && sectionOverlap != null ? sDF2.format(sectionOverlap / (double)total.size()) : ""));
                        if (this.iType.hasUnavailabilities()) {
                            line.add(new CSVFile.CSVField(firstClass ? sDF1.format(section.getEnrollmentWeight(assignment, null)) : ""));
                            line.add(new CSVFile.CSVField(firstClass ? (section.getLimit() < 0 ? "" : String.valueOf(section.getLimit())) : ""));
                        }
                        line.add(new CSVFile.CSVField(other.getCourse().getName() + " " + other.getSection().getSubpart().getName() + " " + other.getSection().getName(other.getCourse().getId())));
                        line.add(new CSVFile.CSVField(other.getSection().getTime().getDayHeader() + " " + other.getSection().getTime().getStartTimeHeader(useAmPm) + " - " + other.getSection().getTime().getEndTimeHeader(useAmPm)));
                        line.add(new CSVFile.CSVField(sDF2.format(pair.get(other))));
                        line.add(new CSVFile.CSVField(sDF2.format((Double)pair.get(other) / (double)total.size())));
                        csv.addLine(line);
                        firstClass = false;
                    }
                }
                firstCourse = false;
            }
            csv.addLine();
        }
        return csv;
    }

    @Override
    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        this.iType = Type.valueOf(properties.getProperty("type", this.iType.name()));
        this.iOverlapsAllEnrollments = properties.getPropertyBoolean("overlapsIncludeAll", true);
        return this.createTable(assignment, properties.getPropertyBoolean("lastlike", false), properties.getPropertyBoolean("real", true), properties.getPropertyBoolean("useAmPm", true));
    }

    public static enum Type {
        OVERLAPS(true, false),
        UNAVAILABILITIES(false, true),
        OVERLAPS_AND_UNAVAILABILITIES(true, true);

        boolean iOveralps;
        boolean iUnavailabilities;

        private Type(boolean overlaps, boolean unavailabilities) {
            this.iOveralps = overlaps;
            this.iUnavailabilities = unavailabilities;
        }

        public boolean hasOverlaps() {
            return this.iOveralps;
        }

        public boolean hasUnavailabilities() {
            return this.iUnavailabilities;
        }
    }
}

