/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.selection;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.selection.OnlineSectioningSelection;

public class SuggestionSelection
extends BranchBoundSelection
implements OnlineSectioningSelection {
    protected Set<FreeTimeRequest> iRequiredFreeTimes;
    protected Hashtable<CourseRequest, Config> iRequiredConfig = null;
    protected Hashtable<CourseRequest, Hashtable<Subpart, Section>> iRequiredSection = null;
    protected Hashtable<CourseRequest, Set<Section>> iPreferredSections = null;
    private double iPreferenceFactor = 0.5;

    public SuggestionSelection(DataProperties properties) {
        super(properties);
        this.iPreferenceFactor = properties.getPropertyDouble("StudentWeights.PreferenceFactor", this.iPreferenceFactor);
    }

    @Override
    public void setPreferredSections(Hashtable<CourseRequest, Set<Section>> preferredSections) {
        this.iPreferredSections = preferredSections;
    }

    @Override
    public void setRequiredSections(Hashtable<CourseRequest, Set<Section>> requiredSections) {
        this.iRequiredConfig = new Hashtable();
        this.iRequiredSection = new Hashtable();
        if (requiredSections != null) {
            for (Map.Entry<CourseRequest, Set<Section>> entry : requiredSections.entrySet()) {
                Hashtable<Subpart, Section> subSection = new Hashtable<Subpart, Section>();
                this.iRequiredSection.put(entry.getKey(), subSection);
                for (Section section : entry.getValue()) {
                    if (subSection.isEmpty()) {
                        this.iRequiredConfig.put(entry.getKey(), section.getSubpart().getConfig());
                    }
                    subSection.put(section.getSubpart(), section);
                }
            }
        }
    }

    @Override
    public void setRequiredFreeTimes(Set<FreeTimeRequest> requiredFreeTimes) {
        this.iRequiredFreeTimes = requiredFreeTimes;
    }

    @Override
    public BranchBoundSelection.BranchBoundNeighbour select(Assignment<Request, Enrollment> assignment, Student student) {
        return new Selection(student, assignment).select();
    }

    @Override
    public void setModel(OnlineSectioningModel model) {
        super.setModel(model);
    }

    public class Selection
    extends BranchBoundSelection.Selection {
        public Selection(Student student, Assignment<Request, Enrollment> assignment) {
            super(student, assignment);
        }

        public boolean isAllowed(int idx, Enrollment enrollment) {
            if (enrollment.isCourseRequest()) {
                CourseRequest request = (CourseRequest)enrollment.getRequest();
                Config reqConfig = SuggestionSelection.this.iRequiredConfig.get(request);
                if (reqConfig != null) {
                    if (!reqConfig.equals(enrollment.getConfig())) {
                        return false;
                    }
                    Hashtable<Subpart, Section> reqSections = SuggestionSelection.this.iRequiredSection.get(request);
                    for (Section section : enrollment.getSections()) {
                        Section reqSection = reqSections.get(section.getSubpart());
                        if (reqSection == null || section.equals(reqSection)) continue;
                        return false;
                    }
                }
            } else if (SuggestionSelection.this.iRequiredFreeTimes.contains(enrollment.getRequest()) && (enrollment.getAssignments() == null || enrollment.getAssignments().isEmpty())) {
                return false;
            }
            return true;
        }

        @Override
        public boolean inConflict(int idx, Enrollment enrollment) {
            return super.inConflict(idx, enrollment) || !this.isAllowed(idx, enrollment);
        }

        @Override
        public Enrollment firstConflict(int idx, Enrollment enrollment) {
            Enrollment conflict = super.firstConflict(idx, enrollment);
            if (conflict != null) {
                return conflict;
            }
            return this.isAllowed(idx, enrollment) ? null : enrollment;
        }

        @Override
        protected boolean canLeaveUnassigned(Request request) {
            return !(request instanceof CourseRequest ? SuggestionSelection.this.iRequiredConfig.get(request) != null : SuggestionSelection.this.iRequiredFreeTimes.contains(request));
        }

        @Override
        protected List<Enrollment> values(CourseRequest request) {
            return super.values(request);
        }

        @Override
        protected double getWeight(Enrollment enrollment, Set<DistanceConflict.Conflict> distanceConflicts, Set<TimeOverlapsCounter.Conflict> timeOverlappingConflicts) {
            Set<Section> preferred;
            double weight = super.getWeight(enrollment, distanceConflicts, timeOverlappingConflicts);
            if (enrollment.isCourseRequest() && SuggestionSelection.this.iPreferredSections != null && (preferred = SuggestionSelection.this.iPreferredSections.get(enrollment.getRequest())) != null && !preferred.isEmpty()) {
                double nrPreferred = 0.0;
                for (Section section : enrollment.getSections()) {
                    if (!preferred.contains(section)) continue;
                    nrPreferred += 1.0;
                }
                double preferredFraction = nrPreferred / (double)preferred.size();
                weight *= 1.0 + SuggestionSelection.this.iPreferenceFactor * preferredFraction;
            }
            return weight;
        }

        @Override
        protected double getBound(Request r) {
            Set<Section> preferred;
            double bound = super.getBound(r);
            if (r instanceof CourseRequest && (preferred = SuggestionSelection.this.iPreferredSections.get(r)) != null && !preferred.isEmpty()) {
                bound *= 1.0 + SuggestionSelection.this.iPreferenceFactor;
            }
            return bound;
        }
    }
}

