/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AbstractClassWithContext;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.CanInheritContext;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;

public class RequestGroup
extends AbstractClassWithContext<Request, Enrollment, RequestGroupContext>
implements CanInheritContext<Request, Enrollment, RequestGroupContext> {
    private long iId = -1L;
    private String iName = null;
    private Course iCourse;
    private Set<CourseRequest> iRequests = new HashSet<CourseRequest>();
    private double iTotalWeight = 0.0;

    public RequestGroup(long id, String name, Course course) {
        this.iId = id;
        this.iName = name;
        this.iCourse = course;
        this.iCourse.getRequestGroups().add(this);
    }

    public void addRequest(CourseRequest request) {
        if (this.iRequests.add(request)) {
            this.iTotalWeight += request.getWeight();
        }
    }

    public void removeRequest(CourseRequest request) {
        if (this.iRequests.remove(request)) {
            this.iTotalWeight -= request.getWeight();
        }
    }

    public Set<CourseRequest> getRequests() {
        return this.iRequests;
    }

    public double getTotalWeight() {
        return this.iTotalWeight;
    }

    public long getId() {
        return this.iId;
    }

    public String getName() {
        return this.iName;
    }

    public Course getCourse() {
        return this.iCourse;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RequestGroup)) {
            return false;
        }
        return this.getId() == ((RequestGroup)o).getId() && this.getCourse().getId() == ((RequestGroup)o).getCourse().getId();
    }

    public int hashCode() {
        return (int)(this.iId ^ this.iCourse.getId() >>> 32);
    }

    public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        ((RequestGroupContext)this.getContext(assignment)).assigned(assignment, enrollment);
    }

    public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        ((RequestGroupContext)this.getContext(assignment)).unassigned(assignment, enrollment);
    }

    public double getEnrollmentWeight(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
        return ((RequestGroupContext)this.getContext(assignment)).getEnrollmentWeight(assignment, excludeRequest);
    }

    public double getSectionWeight(Assignment<Request, Enrollment> assignment, Section section, Request excludeRequest) {
        return ((RequestGroupContext)this.getContext(assignment)).getSectionWeight(assignment, section, excludeRequest);
    }

    public double getEnrollmentSpread(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        return ((RequestGroupContext)this.getContext(assignment)).getEnrollmentSpread(assignment, enrollment);
    }

    public double getAverageSpread(Assignment<Request, Enrollment> assignment) {
        return ((RequestGroupContext)this.getContext(assignment)).getAverageSpread();
    }

    public double getSectionSpread(Assignment<Request, Enrollment> assignment, Section section) {
        return ((RequestGroupContext)this.getContext(assignment)).getSectionSpread(section);
    }

    @Override
    public RequestGroupContext createAssignmentContext(Assignment<Request, Enrollment> assignment) {
        return new RequestGroupContext(assignment);
    }

    @Override
    public RequestGroupContext inheritAssignmentContext(Assignment<Request, Enrollment> assignment, RequestGroupContext parentContext) {
        return new RequestGroupContext(parentContext);
    }

    @Override
    public Model<Request, Enrollment> getModel() {
        return this.getCourse().getModel();
    }

    public class RequestGroupContext
    implements AssignmentConstraintContext<Request, Enrollment> {
        private Set<Enrollment> iEnrollments = null;
        private double iEnrollmentWeight = 0.0;
        private Map<Long, Double> iSectionWeight = null;
        private boolean iReadOnly = false;

        public RequestGroupContext(Assignment<Request, Enrollment> assignment) {
            this.iEnrollments = new HashSet<Enrollment>();
            this.iSectionWeight = new HashMap<Long, Double>();
            for (CourseRequest request : RequestGroup.this.getCourse().getRequests()) {
                Enrollment enrollment;
                if (!request.getRequestGroups().contains(RequestGroup.this) || (enrollment = assignment.getValue(request)) == null || !RequestGroup.this.getCourse().equals(enrollment.getCourse())) continue;
                this.assigned(assignment, enrollment);
            }
        }

        public RequestGroupContext(RequestGroupContext parent) {
            this.iEnrollmentWeight = parent.iEnrollmentWeight;
            this.iEnrollments = parent.iEnrollments;
            this.iSectionWeight = parent.iSectionWeight;
            this.iReadOnly = true;
        }

        @Override
        public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            if (this.iReadOnly) {
                this.iEnrollments = new HashSet<Enrollment>(this.iEnrollments);
                this.iSectionWeight = new HashMap<Long, Double>(this.iSectionWeight);
                this.iReadOnly = false;
            }
            if (this.iEnrollments.add(enrollment)) {
                this.iEnrollmentWeight += enrollment.getRequest().getWeight();
                for (Section section : enrollment.getSections()) {
                    Double weight = this.iSectionWeight.get(section.getId());
                    this.iSectionWeight.put(section.getId(), enrollment.getRequest().getWeight() + (weight == null ? 0.0 : weight));
                }
            }
        }

        @Override
        public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            if (this.iReadOnly) {
                this.iEnrollments = new HashSet<Enrollment>(this.iEnrollments);
                this.iSectionWeight = new HashMap<Long, Double>(this.iSectionWeight);
                this.iReadOnly = false;
            }
            if (this.iEnrollments.remove(enrollment)) {
                this.iEnrollmentWeight -= enrollment.getRequest().getWeight();
                for (Section section : enrollment.getSections()) {
                    Double weight = this.iSectionWeight.get(section.getId());
                    this.iSectionWeight.put(section.getId(), weight - enrollment.getRequest().getWeight());
                }
            }
        }

        public Set<Enrollment> getEnrollments() {
            return this.iEnrollments;
        }

        public double getEnrollmentWeight(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
            Enrollment enrollment;
            double weight = this.iEnrollmentWeight;
            if (excludeRequest != null && (enrollment = assignment.getValue(excludeRequest)) != null && this.iEnrollments.contains(enrollment)) {
                weight -= excludeRequest.getWeight();
            }
            return weight;
        }

        public double getSectionWeight(Assignment<Request, Enrollment> assignment, Section section, Request excludeRequest) {
            Enrollment enrollment;
            Double weight = this.iSectionWeight.get(section.getId());
            if (excludeRequest != null && weight != null && (enrollment = assignment.getValue(excludeRequest)) != null && this.iEnrollments.contains(enrollment) && enrollment.getSections().contains(section)) {
                weight = weight - excludeRequest.getWeight();
            }
            return weight == null ? 0.0 : weight;
        }

        public double getEnrollmentSpread(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            if (RequestGroup.this.iTotalWeight <= 1.0) {
                return 1.0;
            }
            double totalEnrolled = this.getEnrollmentWeight(assignment, enrollment.getRequest());
            double totalRemaining = RequestGroup.this.iTotalWeight - totalEnrolled;
            Enrollment e = assignment.getValue(enrollment.getRequest());
            double enrollmentPairs = 0.0;
            double bestPairs = 0.0;
            for (Section section : enrollment.getSections()) {
                double potential = Math.max(Math.min(totalRemaining, section.getUnreservedSpace(assignment, enrollment.getRequest())), enrollment.getRequest().getWeight());
                Double enrolled = this.iSectionWeight.get(section.getId());
                if (enrolled != null) {
                    if (e != null && e.getSections().contains(section)) {
                        enrolled = enrolled - enrollment.getRequest().getWeight();
                    }
                    potential += enrolled.doubleValue();
                    enrollmentPairs += enrolled * (enrolled + 1.0);
                }
                if (!(potential > 1.0)) continue;
                bestPairs += 0.1 * potential * (potential - 1.0);
            }
            double pEnrl = totalEnrolled < 1.0 ? 0.0 : enrollmentPairs / (double)enrollment.getSections().size() / (totalEnrolled * (totalEnrolled + 1.0));
            double pBest = bestPairs / (double)enrollment.getSections().size() / (RequestGroup.this.iTotalWeight * (RequestGroup.this.iTotalWeight - 1.0));
            return 0.9 * pEnrl + 0.1 * pBest;
        }

        public double getAverageSpread() {
            if (this.iEnrollmentWeight <= 1.0) {
                return 1.0;
            }
            double weight = 0.0;
            for (Config config : RequestGroup.this.getCourse().getOffering().getConfigs()) {
                double pairs = 0.0;
                for (Subpart subpart : config.getSubparts()) {
                    for (Section section : subpart.getSections()) {
                        Double enrollment = this.iSectionWeight.get(section.getId());
                        if (enrollment == null || !(enrollment > 1.0)) continue;
                        pairs += enrollment * (enrollment - 1.0);
                    }
                }
                weight += pairs / (double)config.getSubparts().size() / (this.iEnrollmentWeight * (this.iEnrollmentWeight - 1.0));
            }
            return weight;
        }

        public double getSectionSpread(Section section) {
            Double w = this.iSectionWeight.get(section.getId());
            if (w != null && w > 1.0) {
                return w * (w - 1.0) / (this.iEnrollmentWeight * (this.iEnrollmentWeight - 1.0));
            }
            return 0.0;
        }
    }
}

