/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.model;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.RequestGroup;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.reservation.Reservation;

public class Enrollment
extends Value<Request, Enrollment> {
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private Request iRequest = null;
    private Config iConfig = null;
    private Course iCourse = null;
    private Set<? extends SctAssignment> iAssignments = null;
    private Double iCachedPenalty = null;
    private int iPriority = 0;
    private Reservation iReservation = null;
    private Long iTimeStamp = null;
    private String iApproval = null;

    public Enrollment(Request request, int priority, Course course, Config config, Set<? extends SctAssignment> assignments, Reservation reservation) {
        super(request);
        this.iRequest = request;
        this.iConfig = config;
        this.iAssignments = assignments;
        this.iPriority = priority;
        this.iCourse = course;
        if (this.iConfig != null && this.iCourse == null) {
            for (Course c : ((CourseRequest)this.iRequest).getCourses()) {
                if (!c.getOffering().getConfigs().contains(this.iConfig)) continue;
                this.iCourse = c;
                break;
            }
        }
        this.iReservation = reservation;
    }

    public Enrollment(Request request, int priority, Config config, Set<? extends SctAssignment> assignments, Assignment<Request, Enrollment> assignment) {
        this(request, priority, null, config, assignments, null);
        if (assignments != null && assignment != null) {
            this.guessReservation(assignment, true);
        }
    }

    public void guessReservation(Assignment<Request, Enrollment> assignment, boolean onlyAvailable) {
        if (this.iCourse != null) {
            Reservation best = null;
            for (Reservation reservation : ((CourseRequest)this.iRequest).getReservations(this.iCourse)) {
                if (!reservation.isIncluded(this) || onlyAvailable && ((Reservation.ReservationContext)reservation.getContext(assignment)).getReservedAvailableSpace(assignment, this.iRequest) < this.iRequest.getWeight() && !reservation.canBatchAssignOverLimit()) continue;
                if (best == null || best.getPriority() > reservation.getPriority()) {
                    best = reservation;
                    continue;
                }
                if (best.getPriority() != reservation.getPriority() || !(((Reservation.ReservationContext)best.getContext(assignment)).getReservedAvailableSpace(assignment, this.iRequest) < ((Reservation.ReservationContext)reservation.getContext(assignment)).getReservedAvailableSpace(assignment, this.iRequest))) continue;
                best = reservation;
            }
            this.iReservation = best;
        }
    }

    public Student getStudent() {
        return this.iRequest.getStudent();
    }

    public Request getRequest() {
        return this.iRequest;
    }

    public boolean isCourseRequest() {
        return this.iConfig != null;
    }

    public Offering getOffering() {
        return this.iConfig == null ? null : this.iConfig.getOffering();
    }

    public Config getConfig() {
        return this.iConfig;
    }

    public Course getCourse() {
        return this.iCourse;
    }

    public Set<SctAssignment> getAssignments() {
        return this.iAssignments;
    }

    public Set<Section> getSections() {
        if (this.isCourseRequest()) {
            return this.iAssignments;
        }
        return new HashSet<Section>();
    }

    public boolean isOverlapping(Enrollment enrl) {
        if (enrl == null || this.isAllowOverlap() || enrl.isAllowOverlap()) {
            return false;
        }
        for (SctAssignment a : this.getAssignments()) {
            if (!a.isOverlapping(enrl.getAssignments())) continue;
            return true;
        }
        return false;
    }

    public double percentWaitlisted() {
        if (!this.isCourseRequest()) {
            return 0.0;
        }
        CourseRequest courseRequest = (CourseRequest)this.getRequest();
        int nrWaitlisted = 0;
        for (Section section : this.getSections()) {
            if (!courseRequest.isWaitlisted(section)) continue;
            ++nrWaitlisted;
        }
        return (double)nrWaitlisted / (double)this.getAssignments().size();
    }

    public double percentSelected() {
        if (!this.isCourseRequest()) {
            return 0.0;
        }
        CourseRequest courseRequest = (CourseRequest)this.getRequest();
        int nrSelected = 0;
        for (Section section : this.getSections()) {
            if (!courseRequest.isSelected(section)) continue;
            ++nrSelected;
        }
        return (double)nrSelected / (double)this.getAssignments().size();
    }

    public double percentInitial() {
        if (!this.isCourseRequest()) {
            return 0.0;
        }
        if (this.getRequest().getInitialAssignment() == null) {
            return 0.0;
        }
        Enrollment inital = (Enrollment)this.getRequest().getInitialAssignment();
        int nrInitial = 0;
        for (Section section : this.getSections()) {
            if (!inital.getAssignments().contains(section)) continue;
            ++nrInitial;
        }
        return (double)nrInitial / (double)this.getAssignments().size();
    }

    public double percentSameTime() {
        if (!this.isCourseRequest()) {
            return 0.0;
        }
        Enrollment ie = (Enrollment)this.getRequest().getInitialAssignment();
        if (ie != null) {
            int nrInitial = 0;
            block0: for (Section section : this.getSections()) {
                for (Section initial : ie.getSections()) {
                    if (!section.getSubpart().getInstructionalType().equals(initial.getSubpart().getInstructionalType()) || !section.sameTime(initial)) continue;
                    ++nrInitial;
                    continue block0;
                }
            }
            return (double)nrInitial / (double)this.getAssignments().size();
        }
        Set<Choice> selected = ((CourseRequest)this.getRequest()).getSelectedChoices();
        if (!selected.isEmpty()) {
            int nrInitial = 0;
            block2: for (Section section : this.getSections()) {
                for (Choice choice : selected) {
                    if (!section.getChoice().sameTime(choice)) continue;
                    ++nrInitial;
                    continue block2;
                }
            }
            return (double)nrInitial / (double)this.getAssignments().size();
        }
        return 0.0;
    }

    public boolean isWaitlisted() {
        if (!this.isCourseRequest()) {
            return false;
        }
        CourseRequest courseRequest = (CourseRequest)this.getRequest();
        for (Section section : this.getAssignments()) {
            if (courseRequest.isWaitlisted(section)) continue;
            return false;
        }
        return true;
    }

    public boolean isSelected() {
        if (!this.isCourseRequest()) {
            return false;
        }
        CourseRequest courseRequest = (CourseRequest)this.getRequest();
        for (Section section : this.getSections()) {
            if (courseRequest.isSelected(section)) continue;
            return false;
        }
        return true;
    }

    public double getPenalty() {
        if (this.iCachedPenalty == null) {
            double penalty = 0.0;
            if (this.isCourseRequest()) {
                for (Section section : this.getSections()) {
                    penalty += section.getPenalty();
                }
            }
            this.iCachedPenalty = new Double(penalty / (double)this.getAssignments().size());
        }
        return this.iCachedPenalty;
    }

    @Override
    public double toDouble(Assignment<Request, Enrollment> assignment) {
        return this.toDouble(assignment, true);
    }

    public double toDouble(Assignment<Request, Enrollment> assignment, boolean precise) {
        Double value;
        if (precise) {
            return -this.getRequest().getWeight() * ((StudentSectioningModel)((Request)this.variable()).getModel()).getStudentWeights().getWeight(assignment, this, this.distanceConflicts(assignment), this.timeOverlappingConflicts(assignment));
        }
        Double d = value = assignment == null ? null : ((Request.RequestContext)((Request)this.variable()).getContext(assignment)).getLastWeight();
        if (value != null) {
            return -value.doubleValue();
        }
        return -this.getRequest().getWeight() * ((StudentSectioningModel)((Request)this.variable()).getModel()).getStudentWeights().getWeight(assignment, this);
    }

    @Override
    public String getName() {
        if (this.getRequest() instanceof CourseRequest) {
            Course course = null;
            CourseRequest courseRequest = (CourseRequest)this.getRequest();
            for (Course c : courseRequest.getCourses()) {
                if (!c.getOffering().getConfigs().contains(this.getConfig())) continue;
                course = c;
                break;
            }
            String ret = course == null ? (this.getConfig() == null ? "" : this.getConfig().getName()) : course.getName();
            Iterator<SctAssignment> i = this.getAssignments().iterator();
            while (i.hasNext()) {
                Section assignment = (Section)i.next();
                ret = ret + "\n  " + assignment.getLongName(true) + (i.hasNext() ? "," : "");
            }
            return ret;
        }
        if (this.getRequest() instanceof FreeTimeRequest) {
            return "Free Time " + ((FreeTimeRequest)this.getRequest()).getTime().getLongName(true);
        }
        String ret = "";
        Iterator<SctAssignment> i = this.getAssignments().iterator();
        while (i.hasNext()) {
            SctAssignment assignment = i.next();
            ret = ret + assignment.toString() + (i.hasNext() ? "," : "");
            if (!i.hasNext()) continue;
            ret = ret + "\n  ";
        }
        return ret;
    }

    public String toString(Assignment<Request, Enrollment> a) {
        if (this.getAssignments().isEmpty()) {
            return "not assigned";
        }
        Set<DistanceConflict.Conflict> dc = this.distanceConflicts(a);
        Set<TimeOverlapsCounter.Conflict> toc = this.timeOverlappingConflicts(a);
        int share = 0;
        if (toc != null) {
            for (TimeOverlapsCounter.Conflict c : toc) {
                share += c.getShare();
            }
        }
        String ret = this.toDouble(a) + "/" + sDF.format(this.getRequest().getBound()) + (this.getPenalty() == 0.0 ? "" : "/" + sDF.format(this.getPenalty())) + (dc == null || dc.isEmpty() ? "" : "/dc:" + dc.size()) + (share <= 0 ? "" : "/toc:" + share);
        if (this.getRequest() instanceof CourseRequest) {
            double sameGroup = 0.0;
            int groupCount = 0;
            for (RequestGroup g : ((CourseRequest)this.getRequest()).getRequestGroups()) {
                sameGroup += g.getEnrollmentSpread(a, this);
                ++groupCount;
            }
            if (groupCount > 0) {
                ret = ret + "/g:" + sDF.format(sameGroup / (double)groupCount);
            }
        }
        if (this.getRequest() instanceof CourseRequest) {
            ret = ret + " ";
            Iterator<SctAssignment> i = this.getAssignments().iterator();
            while (i.hasNext()) {
                SctAssignment assignment = i.next();
                ret = ret + assignment + (i.hasNext() ? ", " : "");
            }
        }
        if (this.getReservation() != null) {
            ret = "(r) " + ret;
        }
        return ret;
    }

    @Override
    public String toString() {
        if (this.getAssignments().isEmpty()) {
            return "not assigned";
        }
        String ret = sDF.format(this.getRequest().getBound()) + (this.getPenalty() == 0.0 ? "" : "/" + sDF.format(this.getPenalty()));
        if (this.getRequest() instanceof CourseRequest) {
            ret = ret + " ";
            Iterator<SctAssignment> i = this.getAssignments().iterator();
            while (i.hasNext()) {
                SctAssignment assignment = i.next();
                ret = ret + assignment + (i.hasNext() ? ", " : "");
            }
        }
        if (this.getReservation() != null) {
            ret = "(r) " + ret;
        }
        if (this.getRequest().isMPP()) {
            ret = ret + " [i" + sDF.format(100.0 * this.percentInitial()) + "/t" + sDF.format(100.0 * this.percentSameTime()) + "]";
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Enrollment)) {
            return false;
        }
        Enrollment e = (Enrollment)o;
        if (!ToolBox.equals(this.getConfig(), e.getConfig())) {
            return false;
        }
        if (!ToolBox.equals(this.getRequest(), e.getRequest())) {
            return false;
        }
        return ToolBox.equals(this.getAssignments(), e.getAssignments());
    }

    public Set<DistanceConflict.Conflict> distanceConflicts(Assignment<Request, Enrollment> assignment) {
        if (!this.isCourseRequest()) {
            return null;
        }
        if (this.getRequest().getModel() instanceof StudentSectioningModel) {
            DistanceConflict dc = ((StudentSectioningModel)this.getRequest().getModel()).getDistanceConflict();
            if (dc == null) {
                return null;
            }
            return dc.allConflicts(assignment, this);
        }
        return null;
    }

    public Set<TimeOverlapsCounter.Conflict> timeOverlappingConflicts(Assignment<Request, Enrollment> assignment) {
        if (this.getRequest().getModel() instanceof StudentSectioningModel) {
            TimeOverlapsCounter toc = ((StudentSectioningModel)this.getRequest().getModel()).getTimeOverlaps();
            if (toc == null) {
                return null;
            }
            return toc.allConflicts(assignment, this);
        }
        return null;
    }

    public int getPriority() {
        return this.iPriority;
    }

    public int getNrSlots() {
        int ret = 0;
        for (SctAssignment a : this.getAssignments()) {
            if (a.getTime() == null) continue;
            ret += a.getTime().getLength() * a.getTime().getNrMeetings();
        }
        return ret;
    }

    public Reservation getReservation() {
        return this.iReservation;
    }

    public void setReservation(Reservation reservation) {
        this.iReservation = reservation;
    }

    public Long getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Long timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    public String getApproval() {
        return this.iApproval;
    }

    public void setApproval(String approval) {
        this.iApproval = approval;
    }

    public boolean isAllowOverlap() {
        return this.getReservation() != null && this.getReservation().isAllowOverlap();
    }

    public int getLimit() {
        if (!this.isCourseRequest()) {
            return -1;
        }
        Integer limit = null;
        for (Section section : this.getSections()) {
            if (section.getLimit() < 0) continue;
            if (limit == null) {
                limit = section.getLimit();
                continue;
            }
            limit = Math.min(limit, section.getLimit());
        }
        return limit == null ? -1 : limit;
    }
}

