/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.studentord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.heuristics.studentord.StudentOrder;
import org.cpsolver.studentsct.model.AcademicAreaCode;
import org.cpsolver.studentsct.model.Student;

public class StudentMajorOrder
implements StudentOrder,
Comparator<Student> {
    private boolean iReverse = false;

    public StudentMajorOrder(DataProperties config) {
        this.iReverse = config.getPropertyBoolean("StudentMajorOrder.Reverse", this.iReverse);
    }

    @Override
    public List<Student> order(List<Student> students) {
        ArrayList<Student> ret = new ArrayList<Student>(students);
        Collections.sort(ret, this);
        return ret;
    }

    @Override
    public int compare(Student s1, Student s2) {
        int cmp = this.compareMajors(s1.getMajors(), s2.getMajors());
        if (cmp != 0) {
            return (this.iReverse ? -1 : 1) * cmp;
        }
        return (this.iReverse ? -1 : 1) * Double.compare(s1.getId(), s2.getId());
    }

    public int compareMajors(List<AcademicAreaCode> m1, List<AcademicAreaCode> m2) {
        if (m1.isEmpty()) {
            return m2.isEmpty() ? 0 : -1;
        }
        if (m2.isEmpty()) {
            return 1;
        }
        return this.compareMajors(m1.get(0), m2.get(0));
    }

    public int compareMajors(AcademicAreaCode m1, AcademicAreaCode m2) {
        int cmp = (m1.getArea() == null ? "" : m1.getArea()).compareTo(m2.getArea() == null ? "" : m2.getArea());
        if (cmp != 0) {
            return cmp;
        }
        return (m1.getCode() == null ? "" : m1.getCode()).compareTo(m2.getCode() == null ? "" : m2.getCode());
    }
}

