/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.constraint.LinkedSections;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.heuristics.studentord.StudentGroupsChoiceRealFirstOrder;
import org.cpsolver.studentsct.heuristics.studentord.StudentOrder;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class BranchBoundSelection
implements NeighbourSelection<Request, Enrollment> {
    private static Logger sLog = Logger.getLogger(BranchBoundSelection.class);
    private static DecimalFormat sDF = new DecimalFormat("0.00");
    protected int iTimeout = 10000;
    protected DistanceConflict iDistanceConflict = null;
    protected TimeOverlapsCounter iTimeOverlaps = null;
    protected StudentSectioningModel iModel = null;
    public static boolean sDebug = false;
    protected Queue<Student> iStudents = null;
    protected boolean iMinimizePenalty = false;
    protected StudentOrder iOrder = new StudentGroupsChoiceRealFirstOrder();
    protected double iDistConfWeight = 1.0;

    public BranchBoundSelection(DataProperties properties) {
        this.iTimeout = properties.getPropertyInt("Neighbour.BranchAndBoundTimeout", this.iTimeout);
        this.iMinimizePenalty = properties.getPropertyBoolean("Neighbour.BranchAndBoundMinimizePenalty", this.iMinimizePenalty);
        if (this.iMinimizePenalty) {
            sLog.info((Object)"Overall penalty is going to be minimized (together with the maximization of the number of assigned requests and minimization of distance conflicts).");
        }
        if (properties.getProperty("Neighbour.BranchAndBoundOrder") != null) {
            try {
                this.iOrder = (StudentOrder)Class.forName(properties.getProperty("Neighbour.BranchAndBoundOrder")).getConstructor(DataProperties.class).newInstance(properties);
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to set student order, reason:" + e.getMessage()), (Throwable)e);
            }
        }
        this.iDistConfWeight = properties.getPropertyDouble("DistanceConflict.Weight", this.iDistConfWeight);
    }

    public void init(Solver<Request, Enrollment> solver, String name) {
        this.setModel((StudentSectioningModel)solver.currentSolution().getModel());
        Progress.getInstance(solver.currentSolution().getModel()).setPhase(name, this.iModel.getStudents().size());
    }

    public void setModel(StudentSectioningModel model) {
        this.iModel = model;
        List<Student> students = this.iOrder.order(this.iModel.getStudents());
        this.iStudents = new LinkedList<Student>(students);
        this.iTimeOverlaps = model.getTimeOverlaps();
        this.iDistanceConflict = model.getDistanceConflict();
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, "Branch&bound...");
    }

    protected synchronized Student nextStudent() {
        return this.iStudents.poll();
    }

    public synchronized void addStudent(Student student) {
        if (this.iStudents != null) {
            this.iStudents.add(student);
        }
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Student student = null;
        while ((student = this.nextStudent()) != null) {
            Progress.getInstance(solution.getModel()).incProgress();
            BranchBoundNeighbour neighbour = this.getSelection(solution.getAssignment(), student).select();
            if (neighbour == null) continue;
            return neighbour;
        }
        return null;
    }

    public Selection getSelection(Assignment<Request, Enrollment> assignment, Student student) {
        return new Selection(student, assignment);
    }

    public static class BranchBoundNeighbour
    implements Neighbour<Request, Enrollment> {
        private double iValue;
        private Enrollment[] iAssignment;
        private Student iStudent;

        public BranchBoundNeighbour(Student student, double value, Enrollment[] assignment) {
            this.iValue = value;
            this.iAssignment = assignment;
            this.iStudent = student;
        }

        @Override
        public double value(Assignment<Request, Enrollment> assignment) {
            return this.iValue;
        }

        public Enrollment[] getAssignment() {
            return this.iAssignment;
        }

        public Student getStudent() {
            return this.iStudent;
        }

        @Override
        public void assign(Assignment<Request, Enrollment> assignment, long iteration) {
            for (Request r : this.iStudent.getRequests()) {
                assignment.unassign(iteration, r);
            }
            for (int i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null) continue;
                assignment.assign(iteration, this.iAssignment[i]);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("B&B{ " + this.iStudent + " " + sDF.format(-this.iValue * 100.0) + "%");
            int idx = 0;
            for (Request request : this.iStudent.getRequests()) {
                sb.append("\n  " + request);
                Enrollment enrollment = this.iAssignment[idx];
                if (enrollment == null) {
                    sb.append("  -- not assigned");
                } else {
                    sb.append("  -- " + enrollment);
                }
                ++idx;
            }
            sb.append("\n}");
            return sb.toString();
        }

        @Override
        public Map<Request, Enrollment> assignments() {
            HashMap<Request, Enrollment> ret = new HashMap<Request, Enrollment>();
            for (int i = 0; i < this.iAssignment.length; ++i) {
                ret.put(this.iStudent.getRequests().get(i), this.iAssignment[i]);
            }
            return ret;
        }
    }

    public class Selection {
        protected Student iStudent;
        protected long iT0;
        protected long iT1;
        protected boolean iTimeoutReached;
        protected Enrollment[] iAssignment;
        protected Enrollment[] iBestAssignment;
        protected double iBestValue;
        protected HashMap<CourseRequest, List<Enrollment>> iValues;
        protected Assignment<Request, Enrollment> iCurrentAssignment;

        public Selection(Student student, Assignment<Request, Enrollment> assignment) {
            this.iStudent = student;
            this.iCurrentAssignment = assignment;
        }

        public BranchBoundNeighbour select() {
            this.iT0 = JProf.currentTimeMillis();
            this.iTimeoutReached = false;
            this.iAssignment = new Enrollment[this.iStudent.getRequests().size()];
            this.iBestAssignment = null;
            this.iBestValue = 0.0;
            int i = 0;
            for (Request r : this.iStudent.getRequests()) {
                this.iAssignment[i++] = this.iCurrentAssignment.getValue(r);
            }
            this.saveBest();
            for (int j = 0; j < this.iAssignment.length; ++j) {
                this.iAssignment[j] = null;
            }
            this.iValues = new HashMap();
            this.backTrack(0);
            this.iT1 = JProf.currentTimeMillis();
            if (this.iBestAssignment == null) {
                return null;
            }
            return new BranchBoundNeighbour(this.iStudent, this.iBestValue, this.iBestAssignment);
        }

        public boolean isTimeoutReached() {
            return this.iTimeoutReached;
        }

        public long getTime() {
            return this.iT1 - this.iT0;
        }

        public Enrollment[] getBestAssignment() {
            return this.iBestAssignment;
        }

        public double getBestValue() {
            return this.iBestValue;
        }

        public int getBestNrAssigned() {
            int nrAssigned = 0;
            for (int i = 0; i < this.iBestAssignment.length; ++i) {
                if (this.iBestAssignment[i] == null) continue;
                nrAssigned += this.iBestAssignment[i].isCourseRequest() ? 10 : 1;
            }
            return nrAssigned;
        }

        public int getNrAssignedBound(int idx) {
            int bound = 0;
            int i = 0;
            int alt = 0;
            for (Request r : this.iStudent.getRequests()) {
                boolean cr = r instanceof CourseRequest;
                if (i < idx) {
                    if (this.iAssignment[i] != null) {
                        bound += cr ? 10 : 1;
                    }
                    if (r.isAlternative()) {
                        if (this.iAssignment[i] != null || cr && ((CourseRequest)r).isWaitlist()) {
                            --alt;
                        }
                    } else if (cr && !((CourseRequest)r).isWaitlist() && this.iAssignment[i] == null) {
                        ++alt;
                    }
                } else if (!r.isAlternative()) {
                    bound += cr ? 10 : 1;
                } else if (alt > 0) {
                    bound += cr ? 10 : 1;
                    --alt;
                }
                ++i;
            }
            return bound;
        }

        public Set<DistanceConflict.Conflict> getDistanceConflicts(int idx) {
            if (BranchBoundSelection.this.iDistanceConflict == null || this.iAssignment[idx] == null) {
                return null;
            }
            Set<DistanceConflict.Conflict> dist = BranchBoundSelection.this.iDistanceConflict.conflicts(this.iAssignment[idx]);
            for (int x = 0; x < idx; ++x) {
                if (this.iAssignment[x] == null) continue;
                dist.addAll(BranchBoundSelection.this.iDistanceConflict.conflicts(this.iAssignment[x], this.iAssignment[idx]));
            }
            return dist;
        }

        public Set<TimeOverlapsCounter.Conflict> getTimeOverlappingConflicts(int idx) {
            if (BranchBoundSelection.this.iTimeOverlaps == null || this.iAssignment[idx] == null) {
                return null;
            }
            HashSet<TimeOverlapsCounter.Conflict> overlaps = new HashSet<TimeOverlapsCounter.Conflict>();
            for (int x = 0; x < idx; ++x) {
                if (this.iAssignment[x] != null) {
                    overlaps.addAll(BranchBoundSelection.this.iTimeOverlaps.conflicts(this.iAssignment[x], this.iAssignment[idx]));
                    continue;
                }
                if (!(this.iStudent.getRequests().get(x) instanceof FreeTimeRequest)) continue;
                overlaps.addAll(BranchBoundSelection.this.iTimeOverlaps.conflicts(((FreeTimeRequest)this.iStudent.getRequests().get(x)).createEnrollment(), this.iAssignment[idx]));
            }
            return overlaps;
        }

        protected double getWeight(Enrollment enrollment, Set<DistanceConflict.Conflict> distanceConflicts, Set<TimeOverlapsCounter.Conflict> timeOverlappingConflicts) {
            double weight = -BranchBoundSelection.this.iModel.getStudentWeights().getWeight(this.iCurrentAssignment, enrollment);
            if (distanceConflicts != null) {
                for (DistanceConflict.Conflict conflict : distanceConflicts) {
                    Enrollment other = conflict.getE1().equals(enrollment) ? conflict.getE2() : conflict.getE1();
                    if (other.getRequest().getPriority() > enrollment.getRequest().getPriority()) continue;
                    weight += BranchBoundSelection.this.iModel.getStudentWeights().getDistanceConflictWeight(this.iCurrentAssignment, conflict);
                }
            }
            if (timeOverlappingConflicts != null) {
                for (TimeOverlapsCounter.Conflict conflict : timeOverlappingConflicts) {
                    weight += BranchBoundSelection.this.iModel.getStudentWeights().getTimeOverlapConflictWeight(this.iCurrentAssignment, enrollment, conflict);
                }
            }
            return enrollment.getRequest().getWeight() * weight;
        }

        protected double getBound(Request r) {
            return r.getBound();
        }

        public double getBound(int idx) {
            double bound = 0.0;
            int i = 0;
            int alt = 0;
            for (Request r : this.iStudent.getRequests()) {
                if (i < idx) {
                    if (this.iAssignment[i] != null) {
                        bound += this.getWeight(this.iAssignment[i], this.getDistanceConflicts(i), this.getTimeOverlappingConflicts(i));
                    }
                    if (r.isAlternative()) {
                        if (this.iAssignment[i] != null || r instanceof CourseRequest && ((CourseRequest)r).isWaitlist()) {
                            --alt;
                        }
                    } else if (r instanceof CourseRequest && !((CourseRequest)r).isWaitlist() && this.iAssignment[i] == null) {
                        ++alt;
                    }
                } else if (!r.isAlternative()) {
                    bound += this.getBound(r);
                } else if (alt > 0) {
                    bound += this.getBound(r);
                    --alt;
                }
                ++i;
            }
            return bound;
        }

        public double getValue() {
            double value = 0.0;
            for (int i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null) continue;
                value += this.getWeight(this.iAssignment[i], this.getDistanceConflicts(i), this.getTimeOverlappingConflicts(i));
            }
            return value;
        }

        protected double getAssignmentPenalty(int i) {
            return this.iAssignment[i].getPenalty() + BranchBoundSelection.this.iDistConfWeight * (double)this.getDistanceConflicts(i).size();
        }

        public double getPenalty() {
            double bestPenalty = 0.0;
            for (int i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null) continue;
                bestPenalty += this.getAssignmentPenalty(i);
            }
            return bestPenalty;
        }

        public double getPenaltyBound(int idx) {
            double bound = 0.0;
            int i = 0;
            int alt = 0;
            for (Request r : this.iStudent.getRequests()) {
                if (i < idx) {
                    if (this.iAssignment[i] != null) {
                        bound += this.getAssignmentPenalty(i);
                    }
                    if (r.isAlternative()) {
                        if (this.iAssignment[i] != null || r instanceof CourseRequest && ((CourseRequest)r).isWaitlist()) {
                            --alt;
                        }
                    } else if (r instanceof CourseRequest && !((CourseRequest)r).isWaitlist() && this.iAssignment[i] == null) {
                        ++alt;
                    }
                } else if (!r.isAlternative()) {
                    if (r instanceof CourseRequest) {
                        bound += ((CourseRequest)r).getMinPenalty();
                    }
                } else if (alt > 0) {
                    if (r instanceof CourseRequest) {
                        bound += ((CourseRequest)r).getMinPenalty();
                    }
                    --alt;
                }
                ++i;
            }
            return bound;
        }

        public void saveBest() {
            if (this.iBestAssignment == null) {
                this.iBestAssignment = new Enrollment[this.iAssignment.length];
            }
            for (int i = 0; i < this.iAssignment.length; ++i) {
                this.iBestAssignment[i] = this.iAssignment[i];
            }
            this.iBestValue = BranchBoundSelection.this.iMinimizePenalty ? this.getPenalty() : this.getValue();
        }

        public boolean inConflict(final int idx, final Enrollment enrollment) {
            for (GlobalConstraint<Request, Enrollment> globalConstraint : ((Request)enrollment.variable()).getModel().globalConstraints()) {
                if (!globalConstraint.inConflict(this.iCurrentAssignment, enrollment)) continue;
                return true;
            }
            for (LinkedSections linkedSections : this.iStudent.getLinkedSections()) {
                if (linkedSections.inConflict(enrollment, new LinkedSections.EnrollmentAssignment(){

                    @Override
                    public Enrollment getEnrollment(Request request, int index) {
                        return index == idx ? enrollment : Selection.this.iAssignment[index];
                    }
                }) == null) continue;
                return true;
            }
            for (int i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null || i == idx || !this.iAssignment[i].isOverlapping(enrollment)) continue;
                return true;
            }
            return false;
        }

        public Enrollment firstConflict(int idx, Enrollment enrollment) {
            Set<Enrollment> conflicts = ((Request)enrollment.variable()).getModel().conflictValues(this.iCurrentAssignment, enrollment);
            if (conflicts.contains(enrollment)) {
                return enrollment;
            }
            if (!conflicts.isEmpty()) {
                for (Enrollment conflict : conflicts) {
                    if (conflict.getStudent().equals(this.iStudent)) continue;
                    return conflict;
                }
            }
            for (int i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null || i == idx || !this.iAssignment[i].isOverlapping(enrollment)) continue;
                return this.iAssignment[i];
            }
            return null;
        }

        public boolean canAssign(Request request, int idx) {
            if (!request.isAlternative() || this.iAssignment[idx] != null) {
                return true;
            }
            int alt = 0;
            int i = 0;
            for (Request r : this.iStudent.getRequests()) {
                if (!r.equals(request)) {
                    if (r.isAlternative()) {
                        if (this.iAssignment[i] != null || r instanceof CourseRequest && ((CourseRequest)r).isWaitlist()) {
                            --alt;
                        }
                    } else if (r instanceof CourseRequest && !((CourseRequest)r).isWaitlist() && this.iAssignment[i] == null) {
                        ++alt;
                    }
                }
                ++i;
            }
            return alt > 0;
        }

        public int getNrAssigned() {
            int assigned = 0;
            for (int i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null) continue;
                assigned += this.iAssignment[i].isCourseRequest() ? 10 : 1;
            }
            return assigned;
        }

        protected boolean canLeaveUnassigned(Request request) {
            return true;
        }

        protected List<Enrollment> values(final CourseRequest request) {
            List<Enrollment> values = request.getAvaiableEnrollments(this.iCurrentAssignment);
            Collections.sort(values, new Comparator<Enrollment>(){
                private HashMap<Enrollment, Double> iValues = new HashMap();

                private Double value(Enrollment e) {
                    Double value = this.iValues.get(e);
                    if (value == null) {
                        value = BranchBoundSelection.this.iModel.getStudentWeights().getWeight(Selection.this.iCurrentAssignment, e, BranchBoundSelection.this.iModel.getDistanceConflict() == null ? null : BranchBoundSelection.this.iModel.getDistanceConflict().conflicts(e), BranchBoundSelection.this.iModel.getTimeOverlaps() == null ? null : BranchBoundSelection.this.iModel.getTimeOverlaps().freeTimeConflicts(e));
                        this.iValues.put(e, value);
                    }
                    return value;
                }

                @Override
                public int compare(Enrollment e1, Enrollment e2) {
                    Double v2;
                    if (e1.equals(Selection.this.iCurrentAssignment.getValue(request))) {
                        return -1;
                    }
                    if (e2.equals(Selection.this.iCurrentAssignment.getValue(request))) {
                        return 1;
                    }
                    Double v1 = this.value(e1);
                    return v1.equals(v2 = this.value(e2)) ? e1.compareTo(Selection.this.iCurrentAssignment, e2) : v2.compareTo(v1);
                }
            });
            return values;
        }

        public void backTrack(int idx) {
            if (sDebug) {
                sLog.debug((Object)("backTrack(" + this.getNrAssigned() + "/" + this.getValue() + "," + idx + ")"));
            }
            if (BranchBoundSelection.this.iTimeout > 0 && JProf.currentTimeMillis() - this.iT0 > (long)BranchBoundSelection.this.iTimeout) {
                if (sDebug) {
                    sLog.debug((Object)"  -- timeout reached");
                }
                this.iTimeoutReached = true;
                return;
            }
            if (BranchBoundSelection.this.iMinimizePenalty) {
                if (this.getBestAssignment() != null && (this.getNrAssignedBound(idx) < this.getBestNrAssigned() || this.getNrAssignedBound(idx) == this.getBestNrAssigned() && this.getPenaltyBound(idx) >= this.getBestValue())) {
                    if (sDebug) {
                        sLog.debug((Object)("  -- branch number of assigned " + this.getNrAssignedBound(idx) + "<" + this.getBestNrAssigned() + ", or penalty " + this.getPenaltyBound(idx) + ">=" + this.getBestValue()));
                    }
                    return;
                }
                if (idx == this.iAssignment.length) {
                    if (this.getBestAssignment() == null || this.getNrAssigned() > this.getBestNrAssigned() || this.getNrAssigned() == this.getBestNrAssigned() && this.getPenalty() < this.getBestValue()) {
                        if (sDebug) {
                            sLog.debug((Object)("  -- best solution found " + this.getNrAssigned() + "/" + this.getPenalty()));
                        }
                        this.saveBest();
                    }
                    return;
                }
            } else {
                if (this.getBestAssignment() != null && this.getBound(idx) >= this.getBestValue()) {
                    if (sDebug) {
                        sLog.debug((Object)("  -- branch " + this.getBound(idx) + " >= " + this.getBestValue()));
                    }
                    return;
                }
                if (idx == this.iAssignment.length) {
                    if (this.getBestAssignment() == null || this.getValue() < this.getBestValue()) {
                        if (sDebug) {
                            sLog.debug((Object)("  -- best solution found " + this.getNrAssigned() + "/" + this.getValue()));
                        }
                        this.saveBest();
                    }
                    return;
                }
            }
            Request request = this.iStudent.getRequests().get(idx);
            if (sDebug) {
                sLog.debug((Object)("  -- request: " + request));
            }
            if (!this.canAssign(request, idx)) {
                if (sDebug) {
                    sLog.debug((Object)"    -- cannot assign");
                }
                this.backTrack(idx + 1);
                return;
            }
            List<Enrollment> values = null;
            if (request instanceof CourseRequest) {
                Enrollment enrollment;
                CourseRequest courseRequest = (CourseRequest)request;
                if (courseRequest.getInitialAssignment() != null && BranchBoundSelection.this.iModel.isMPP() && !this.inConflict(idx, enrollment = (Enrollment)courseRequest.getInitialAssignment())) {
                    this.iAssignment[idx] = enrollment;
                    this.backTrack(idx + 1);
                    this.iAssignment[idx] = null;
                    return;
                }
                if (!courseRequest.getSelectedChoices().isEmpty()) {
                    if (sDebug) {
                        sLog.debug((Object)"    -- selection among selected enrollments");
                    }
                    if ((values = courseRequest.getSelectedEnrollments(this.iCurrentAssignment, true)) != null && !values.isEmpty()) {
                        boolean hasNoConflictValue = false;
                        for (Enrollment enrollment2 : values) {
                            if (this.inConflict(idx, enrollment2)) continue;
                            hasNoConflictValue = true;
                            if (sDebug) {
                                sLog.debug((Object)("      -- nonconflicting enrollment found: " + enrollment2));
                            }
                            this.iAssignment[idx] = enrollment2;
                            this.backTrack(idx + 1);
                            this.iAssignment[idx] = null;
                        }
                        if (hasNoConflictValue) {
                            return;
                        }
                    }
                }
                if ((values = this.iValues.get(courseRequest)) == null) {
                    values = this.values(courseRequest);
                    this.iValues.put(courseRequest, values);
                }
            } else {
                values = request.computeEnrollments(this.iCurrentAssignment);
            }
            if (sDebug) {
                sLog.debug((Object)("  -- nrValues: " + values.size()));
                int vIdx = 1;
                for (Enrollment enrollment : values) {
                    if (!sDebug) continue;
                    sLog.debug((Object)("    -- [" + vIdx + "]: " + enrollment));
                }
            }
            boolean hasNoConflictValue = false;
            for (Enrollment enrollment : values) {
                if (sDebug) {
                    sLog.debug((Object)("    -- enrollment: " + enrollment));
                }
                if (sDebug) {
                    Enrollment conflict = this.firstConflict(idx, enrollment);
                    if (conflict != null) {
                        sLog.debug((Object)("        -- in conflict with: " + conflict));
                        continue;
                    }
                } else if (this.inConflict(idx, enrollment)) continue;
                hasNoConflictValue = true;
                this.iAssignment[idx] = enrollment;
                this.backTrack(idx + 1);
                this.iAssignment[idx] = null;
            }
            if (this.canLeaveUnassigned(request) && (!hasNoConflictValue || request instanceof CourseRequest)) {
                this.backTrack(idx + 1);
            }
        }
    }
}

