/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics;

import java.util.ArrayList;
import java.util.Iterator;
import org.cpsolver.ifs.heuristics.BacktrackNeighbourSelection;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class RandomizedBacktrackNeighbourSelection
extends BacktrackNeighbourSelection<Request, Enrollment> {
    private int iMaxValues = 100;

    public RandomizedBacktrackNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
        this.iMaxValues = properties.getPropertyInt("Neighbour.MaxValues", this.iMaxValues);
    }

    @Override
    protected Iterator<Enrollment> values(BacktrackNeighbourSelection.BacktrackNeighbourSelectionContext context, Request variable) {
        if (this.iMaxValues > 0 && variable instanceof CourseRequest) {
            return new ArrayList<Enrollment>(((CourseRequest)variable).computeRandomEnrollments(context.getAssignment(), this.iMaxValues)).iterator();
        }
        return variable.computeEnrollments(context.getAssignment()).iterator();
    }
}

