/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.check;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;

public class InevitableStudentConflicts {
    private static Logger sLog = Logger.getLogger(InevitableStudentConflicts.class);
    private StudentSectioningModel iModel;
    private CSVFile iCSVFile = null;
    public static boolean sDebug = false;
    private boolean iDeleteInevitable;

    public InevitableStudentConflicts(StudentSectioningModel model) {
        this.iModel = model;
        this.iCSVFile = new CSVFile();
        this.iCSVFile.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField("NoGood"), new CSVFile.CSVField("NrStud"), new CSVFile.CSVField("StudWeight"), new CSVFile.CSVField("1. Course"), new CSVFile.CSVField("2. Course"), new CSVFile.CSVField("3. Course"), new CSVFile.CSVField("4. Course"), new CSVFile.CSVField("5. Course")});
        this.iDeleteInevitable = model.getProperties().getPropertyBoolean("InevitableStudentConflicts.DeleteInevitable", false);
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    public CSVFile getCSVFile() {
        return this.iCSVFile;
    }

    public boolean check(Assignment<Request, Enrollment> assignment) {
        sLog.info((Object)"Checking for inevitable student conflicts...");
        HashMap<TreeSet<Object>, Object[]> noGoods = new HashMap<TreeSet<Object>, Object[]>();
        long studentWithoutCompleteSchedule = 0L;
        long inevitableRequests = 0L;
        double inevitableRequestWeight = 0.0;
        long incompleteInevitableRequests = 0L;
        double incompleteInevitableRequestWeight = 0.0;
        long total = 0L;
        Comparator<Object> simpleCmp = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
        HashSet<Request> requests2remove = new HashSet<Request>();
        for (Student student : this.getModel().getStudents()) {
            sLog.debug((Object)("  Checking " + ++total + ". student " + student + "..."));
            if (student.isComplete(assignment)) {
                for (Request request : student.getRequests()) {
                    if (assignment.getValue(request) != null) continue;
                    ++inevitableRequests;
                    inevitableRequestWeight += request.getWeight();
                }
                continue;
            }
            StudentCheck ch = new StudentCheck(student.getRequests());
            ch.check(assignment);
            if (!ch.isBestComplete()) {
                sLog.info((Object)("    Student " + student + " cannot have a complete schedule"));
                ++studentWithoutCompleteSchedule;
            }
            int idx = 0;
            for (Request request : student.getRequests()) {
                Enrollment enrollment = ch.getBestAssignment()[idx];
                if (enrollment == null) {
                    if (!ch.isBestComplete()) {
                        List<Request> noGood = this.noGood(assignment, student, ch, idx);
                        sLog.info((Object)("      Request " + request + " cannot be assigned"));
                        for (Request r : noGood) {
                            sLog.debug((Object)("        " + r));
                            List<Enrollment> values = null;
                            values = r instanceof CourseRequest ? ((CourseRequest)r).getEnrollmentsSkipSameTime(assignment) : request.computeEnrollments(assignment);
                            for (Enrollment en : values) {
                                sLog.debug((Object)("          " + InevitableStudentConflicts.enrollment2string(en)));
                            }
                        }
                        if (this.iDeleteInevitable) {
                            requests2remove.add(request);
                            sLog.info((Object)("        -- request " + request + " picked to be removed from the model"));
                        }
                        TreeSet<Object> key = new TreeSet<Object>(simpleCmp);
                        for (Request r : noGood) {
                            if (r instanceof CourseRequest) {
                                key.add(((CourseRequest)r).getCourses().get(0));
                                continue;
                            }
                            key.add("Free " + ((FreeTimeRequest)r).getTime().getLongName(true));
                        }
                        Object[] counter = (Object[])noGoods.get(key);
                        int ir = counter == null ? 1 : (Integer)counter[0] + 1;
                        double irw = (counter == null ? 0.0 : (Double)counter[1]) + request.getWeight();
                        noGoods.put(key, new Object[]{new Integer(ir), new Double(irw)});
                        if (ch.canAssign(request, idx)) {
                            ++incompleteInevitableRequests;
                            incompleteInevitableRequestWeight += request.getWeight();
                        }
                    }
                    ++inevitableRequests;
                    inevitableRequestWeight += request.getWeight();
                }
                ++idx;
            }
        }
        for (Map.Entry entry : noGoods.entrySet()) {
            Course course;
            TreeSet noGood = (TreeSet)entry.getKey();
            Object[] counter = (Object[])entry.getValue();
            ArrayList<CSVFile.CSVField> fields = new ArrayList<CSVFile.CSVField>();
            String courseStr = "";
            Iterator j = noGood.iterator();
            while (j.hasNext()) {
                Object x = j.next();
                if (x instanceof Course) {
                    course = (Course)x;
                    courseStr = courseStr + course.getName();
                } else {
                    courseStr = courseStr + x.toString();
                }
                if (!j.hasNext()) continue;
                courseStr = courseStr + ", ";
            }
            fields.add(new CSVFile.CSVField(courseStr));
            fields.add(new CSVFile.CSVField((Integer)counter[0]));
            fields.add(new CSVFile.CSVField((Double)counter[1]));
            for (Object x : noGood) {
                if (x instanceof Course) {
                    course = (Course)x;
                    ArrayList<Course> courses = new ArrayList<Course>(1);
                    courses.add(course);
                    CourseRequest cr = new CourseRequest(-1L, 0, false, new Student(-1L), courses, false, null);
                    String field = course.getName();
                    int idx = 0;
                    Iterator<Enrollment> k = cr.getEnrollmentsSkipSameTime(assignment).iterator();
                    while (k.hasNext()) {
                        if (idx++ > 20) {
                            field = field + "\n ...";
                            break;
                        }
                        field = field + "\n  " + InevitableStudentConflicts.enrollment2string(k.next());
                    }
                    fields.add(new CSVFile.CSVField(field));
                    continue;
                }
                fields.add(new CSVFile.CSVField(x.toString()));
            }
            this.iCSVFile.addLine(fields);
        }
        if (!requests2remove.isEmpty()) {
            for (Request request : requests2remove) {
                this.removeRequest(request);
            }
        }
        sLog.info((Object)("Students that can never obtain a complete schedule: " + studentWithoutCompleteSchedule));
        sLog.info((Object)("Inevitable student requests: " + inevitableRequests));
        sLog.info((Object)("Inevitable student request weight: " + inevitableRequestWeight));
        sLog.info((Object)("Inevitable student requests of students without a complete schedule: " + incompleteInevitableRequests));
        sLog.info((Object)("Inevitable student request weight of students without a complete schedule: " + incompleteInevitableRequestWeight));
        if (this.iCSVFile.getLines() != null) {
            Collections.sort(this.iCSVFile.getLines(), new Comparator<CSVFile.CSVLine>(){

                @Override
                public int compare(CSVFile.CSVLine l1, CSVFile.CSVLine l2) {
                    int cmp = Double.compare(l2.getField(1).toDouble(), l1.getField(1).toDouble());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return l1.getField(0).toString().compareTo(l2.getField(0).toString());
                }
            });
        }
        return inevitableRequests == 0L;
    }

    private void removeRequest(Request request) {
        request.getStudent().getRequests().remove(request);
        for (Request r : request.getStudent().getRequests()) {
            if (r.getPriority() <= request.getPriority()) continue;
            r.setPriority(r.getPriority() - 1);
        }
        this.iModel.removeVariable(request);
        if (request.getStudent().getRequests().isEmpty()) {
            this.iModel.getStudents().remove(request.getStudent());
        }
    }

    private static String enrollment2string(Enrollment enrollment) {
        StringBuffer sb = new StringBuffer();
        Set<SctAssignment> assignments = enrollment.getAssignments();
        if (enrollment.isCourseRequest()) {
            assignments = new TreeSet<SctAssignment>(new Comparator<SctAssignment>(){

                @Override
                public int compare(SctAssignment a1, SctAssignment a2) {
                    Section s1 = (Section)a1;
                    Section s2 = (Section)a2;
                    return s1.getSubpart().compareTo(s2.getSubpart());
                }
            });
            assignments.addAll(enrollment.getAssignments());
        }
        Iterator i = assignments.iterator();
        while (i.hasNext()) {
            SctAssignment a = (SctAssignment)i.next();
            if (a instanceof Section) {
                sb.append(((Section)a).getSubpart().getName() + " ");
            }
            if (a.getTime() != null) {
                sb.append(a.getTime().getLongName(true));
            }
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private List<Request> noGood(Assignment<Request, Enrollment> assignment, Student student, StudentCheck ch, int idx) {
        ArrayList<Request> noGood = new ArrayList<Request>();
        Request rx = student.getRequests().get(idx);
        for (int i = 0; i < student.getRequests().size(); ++i) {
            if (i == idx) {
                noGood.add(rx);
                continue;
            }
            if (ch.getBestAssignment()[i] == null) continue;
            noGood.add(ch.getBestAssignment()[i].getRequest());
        }
        for (Request r : noGood) {
            if (r.equals(rx)) continue;
            ArrayList<Request> newNoGood = new ArrayList<Request>(noGood);
            newNoGood.remove(r);
            StudentCheck chx = new StudentCheck(newNoGood);
            chx.check(assignment);
            if (chx.isBestComplete()) continue;
            noGood = newNoGood;
        }
        return noGood;
    }

    public static class StudentCheck {
        private List<Request> iRequests;
        private Enrollment[] iAssignment;
        private Enrollment[] iBestAssignment;
        private HashMap<Request, List<Enrollment>> iValues;
        private int iBestNrAssigned = 0;
        private boolean iBestComplete = false;

        public StudentCheck(List<Request> requests) {
            this.iRequests = requests;
        }

        public void check(Assignment<Request, Enrollment> assignment) {
            this.iAssignment = new Enrollment[this.iRequests.size()];
            this.iBestAssignment = null;
            this.iBestNrAssigned = 0;
            this.iBestComplete = false;
            this.iValues = new HashMap();
            this.backTrack(assignment, 0);
        }

        public Enrollment[] getBestAssignment() {
            return this.iBestAssignment;
        }

        public int getBestNrAssigned() {
            return this.iBestNrAssigned;
        }

        public int getNrAssignedBound(int idx) {
            int bound = 0;
            int i = 0;
            int alt = 0;
            for (Request r : this.iRequests) {
                if (i < idx) {
                    if (this.iAssignment[i] != null) {
                        ++bound;
                    }
                    if (r.isAlternative()) {
                        if (this.iAssignment[i] != null || r instanceof CourseRequest && ((CourseRequest)r).isWaitlist()) {
                            --alt;
                        }
                    } else if (r instanceof CourseRequest && !((CourseRequest)r).isWaitlist() && this.iAssignment[i] == null) {
                        ++alt;
                    }
                } else if (!r.isAlternative()) {
                    ++bound;
                } else if (alt > 0) {
                    ++bound;
                    --alt;
                }
                ++i;
            }
            return bound;
        }

        public boolean isBestComplete() {
            return this.iBestComplete;
        }

        public void saveBest() {
            if (this.iBestAssignment == null) {
                this.iBestAssignment = new Enrollment[this.iAssignment.length];
            }
            this.iBestNrAssigned = 0;
            for (int i = 0; i < this.iAssignment.length; ++i) {
                this.iBestAssignment[i] = this.iAssignment[i];
                if (this.iBestAssignment[i] == null) continue;
                ++this.iBestNrAssigned;
            }
            int nrRequests = 0;
            int nrAssignedRequests = 0;
            int idx = 0;
            for (Request r : this.iRequests) {
                if (!(r instanceof CourseRequest)) {
                    ++idx;
                    continue;
                }
                if (!r.isAlternative()) {
                    ++nrRequests;
                }
                if (this.iBestAssignment[idx] != null) {
                    ++nrAssignedRequests;
                }
                ++idx;
            }
            this.iBestComplete = nrAssignedRequests == nrRequests;
        }

        public Enrollment firstConflict(Enrollment enrollment) {
            for (int i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null || !this.iAssignment[i].isOverlapping(enrollment)) continue;
                return this.iAssignment[i];
            }
            return null;
        }

        public boolean canAssign(Request request, int idx) {
            if (!request.isAlternative() || this.iAssignment[idx] != null) {
                return true;
            }
            int alt = 0;
            int i = 0;
            for (Request r : this.iRequests) {
                if (!r.equals(request)) {
                    if (r.isAlternative()) {
                        if (this.iAssignment[i] != null || r instanceof CourseRequest && ((CourseRequest)r).isWaitlist()) {
                            --alt;
                        }
                    } else if (r instanceof CourseRequest && !((CourseRequest)r).isWaitlist() && this.iAssignment[i] == null) {
                        ++alt;
                    }
                }
                ++i;
            }
            return alt > 0;
        }

        public int getNrAssigned() {
            int assigned = 0;
            for (int i = 0; i < this.iAssignment.length; ++i) {
                if (this.iAssignment[i] == null) continue;
                ++assigned;
            }
            return assigned;
        }

        public void backTrack(Assignment<Request, Enrollment> assignment, int idx) {
            if (sDebug) {
                sLog.debug((Object)("BT[" + idx + "]:  -- assigned:" + this.getNrAssigned() + ", bound:" + this.getNrAssignedBound(idx) + ", best:" + this.getBestNrAssigned()));
            }
            if (idx == this.iAssignment.length) {
                if (this.iBestAssignment == null || this.getNrAssigned() > this.getBestNrAssigned()) {
                    this.saveBest();
                    if (sDebug) {
                        sLog.debug((Object)("BT[" + idx + "]:    -- BEST " + this.getBestNrAssigned()));
                    }
                }
                return;
            }
            if (this.isBestComplete() || this.getNrAssignedBound(idx) <= this.getBestNrAssigned()) {
                if (sDebug) {
                    sLog.debug((Object)("BT[" + idx + "]:    -- BOUND " + this.getNrAssignedBound(idx) + " <= " + this.getBestNrAssigned()));
                }
                return;
            }
            Request request = this.iRequests.get(idx);
            if (sDebug) {
                sLog.debug((Object)("BT[" + idx + "]:    -- REQUEST " + request));
            }
            if (!this.canAssign(request, idx)) {
                if (sDebug) {
                    sLog.debug((Object)("BT[" + idx + "]:      -- CANNOT ASSIGN"));
                }
                this.backTrack(assignment, idx + 1);
                return;
            }
            List<Enrollment> values = null;
            if (request instanceof CourseRequest) {
                CourseRequest courseRequest = (CourseRequest)request;
                values = this.iValues.get(courseRequest);
                if (values == null) {
                    values = courseRequest.getEnrollmentsSkipSameTime(assignment);
                    this.iValues.put(courseRequest, values);
                }
            } else {
                values = request.computeEnrollments(assignment);
            }
            if (sDebug) {
                sLog.debug((Object)("BT[" + idx + "]:    -- VALUES: " + values.size()));
            }
            boolean hasNoConflictValue = false;
            Iterator<Enrollment> i = values.iterator();
            while (i.hasNext() && !this.isBestComplete()) {
                Enrollment conflict;
                Enrollment enrollment = i.next();
                if (sDebug) {
                    sLog.debug((Object)("BT[" + idx + "]:      -- " + InevitableStudentConflicts.enrollment2string(enrollment)));
                }
                if ((conflict = this.firstConflict(enrollment)) != null) {
                    if (!sDebug) continue;
                    sLog.debug((Object)("BT[" + idx + "]:        -- conflict with " + conflict.getRequest() + " " + InevitableStudentConflicts.enrollment2string(conflict)));
                    continue;
                }
                hasNoConflictValue = true;
                this.iAssignment[idx] = enrollment;
                this.backTrack(assignment, idx + 1);
                this.iAssignment[idx] = null;
            }
            if (!hasNoConflictValue || request instanceof CourseRequest) {
                if (sDebug) {
                    sLog.debug((Object)("BT[" + idx + "]:      -- without assignment"));
                }
                this.backTrack(assignment, idx + 1);
            }
        }
    }
}

