/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.check;

import java.text.DecimalFormat;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;

public class CourseLimitCheck {
    private static Logger sLog = Logger.getLogger(CourseLimitCheck.class);
    private static DecimalFormat sDF = new DecimalFormat("0.0");
    private StudentSectioningModel iModel;
    private CSVFile iCSVFile = null;
    private boolean iFixUnlimited = false;
    private boolean iUpZeroLimits = false;
    private boolean iUpNonZeroLimits = false;

    public CourseLimitCheck(StudentSectioningModel model) {
        this.iModel = model;
        this.iCSVFile = new CSVFile();
        this.iCSVFile.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField("Course"), new CSVFile.CSVField("Limit"), new CSVFile.CSVField("Students"), new CSVFile.CSVField("Real"), new CSVFile.CSVField("Last-like")});
        this.iFixUnlimited = model.getProperties().getPropertyBoolean("CourseLimitCheck.FixUnlimited", this.iFixUnlimited);
        this.iUpZeroLimits = model.getProperties().getPropertyBoolean("CourseLimitCheck.UpZeroLimits", this.iUpZeroLimits);
        this.iUpNonZeroLimits = model.getProperties().getPropertyBoolean("CourseLimitCheck.UpNonZeroLimits", this.iUpNonZeroLimits);
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    public CSVFile getCSVFile() {
        return this.iCSVFile;
    }

    public boolean check() {
        sLog.info((Object)"Checking for course limits...");
        boolean ret = true;
        for (Offering offering : this.getModel().getOfferings()) {
            boolean hasUnlimitedSection = false;
            if (this.iFixUnlimited) {
                for (Config config : offering.getConfigs()) {
                    for (Subpart subpart : config.getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            if (section.getLimit() >= 0) continue;
                            hasUnlimitedSection = true;
                        }
                    }
                }
            }
            int offeringLimit = 0;
            int nrStudents = 0;
            for (Course course : offering.getCourses()) {
                if (course.getLimit() < 0) {
                    offeringLimit = -1;
                    continue;
                }
                if (this.iFixUnlimited && hasUnlimitedSection) {
                    sLog.info((Object)("Course " + course + " made unlimited."));
                    course.setLimit(-1);
                    offeringLimit = -1;
                    continue;
                }
                double total = 0.0;
                double lastLike = 0.0;
                double real = 0.0;
                for (Request request : this.getModel().variables()) {
                    if (!(request instanceof CourseRequest) || !((CourseRequest)request).getCourses().contains(course)) continue;
                    total += request.getWeight();
                    if (request.getStudent().isDummy()) {
                        lastLike += request.getWeight();
                        continue;
                    }
                    real += request.getWeight();
                }
                nrStudents = (int)((long)nrStudents + Math.round(total));
                offeringLimit += course.getLimit();
                if (Math.round(total) <= (long)course.getLimit()) continue;
                sLog.error((Object)("Course " + course + " is requested by " + sDF.format(total) + " students, but its limit is only " + course.getLimit()));
                ret = false;
                this.iCSVFile.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(course.getName()), new CSVFile.CSVField(course.getLimit()), new CSVFile.CSVField(total), new CSVFile.CSVField(real), new CSVFile.CSVField(lastLike)});
                if (this.iUpZeroLimits && course.getLimit() == 0) {
                    int oldLimit = course.getLimit();
                    course.setLimit((int)Math.round(total));
                    sLog.info((Object)("  -- limit of course " + course + " increased to " + course.getLimit() + " (was " + oldLimit + ")"));
                    continue;
                }
                if (!this.iUpNonZeroLimits || course.getLimit() <= 0) continue;
                int oldLimit = course.getLimit();
                course.setLimit((int)Math.round(total));
                sLog.info((Object)("  -- limit of course " + course + " increased to " + course.getLimit() + " (was " + oldLimit + ")"));
            }
            if (this.iUpZeroLimits && offeringLimit == 0 && nrStudents > 0) {
                for (Config config : offering.getConfigs()) {
                    for (Subpart subpart : config.getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            int oldLimit = section.getLimit();
                            section.setLimit(Math.max(section.getLimit(), (int)Math.ceil(nrStudents / subpart.getSections().size())));
                            sLog.info((Object)("    -- limit of section " + section + " increased to " + section.getLimit() + " (was " + oldLimit + ")"));
                        }
                    }
                }
            } else if (this.iUpNonZeroLimits && offeringLimit >= 0 && nrStudents > offeringLimit) {
                double fact = (double)nrStudents / (double)offeringLimit;
                for (Config config : offering.getConfigs()) {
                    for (Subpart subpart : config.getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            int oldLimit = section.getLimit();
                            section.setLimit((int)Math.ceil(fact * (double)section.getLimit()));
                            sLog.info((Object)("    -- limit of section " + section + " increased to " + section.getLimit() + " (was " + oldLimit + ")"));
                        }
                    }
                }
            }
            if (offeringLimit < 0) continue;
            int totalSectionLimit = 0;
            for (Config config : offering.getConfigs()) {
                int configLimit = -1;
                for (Subpart subpart : config.getSubparts()) {
                    int subpartLimit = 0;
                    for (Section section : subpart.getSections()) {
                        subpartLimit += section.getLimit();
                    }
                    if (configLimit < 0) {
                        configLimit = subpartLimit;
                        continue;
                    }
                    configLimit = Math.min(configLimit, subpartLimit);
                }
                totalSectionLimit += configLimit;
            }
            if (totalSectionLimit >= offeringLimit) continue;
            sLog.error((Object)("Offering limit of " + offering + " is " + offeringLimit + ", but total section limit is only " + totalSectionLimit));
            if (this.iUpZeroLimits && totalSectionLimit == 0) {
                for (Config config : offering.getConfigs()) {
                    for (Subpart subpart : config.getSubparts()) {
                        for (Section section : subpart.getSections()) {
                            int oldLimit = section.getLimit();
                            section.setLimit(Math.max(section.getLimit(), (int)Math.ceil((double)offeringLimit / (double)subpart.getSections().size())));
                            sLog.info((Object)("    -- limit of section " + section + " increased to " + section.getLimit() + " (was " + oldLimit + ")"));
                        }
                    }
                }
                continue;
            }
            if (!this.iUpNonZeroLimits || totalSectionLimit <= 0) continue;
            double fact = (double)offeringLimit / (double)totalSectionLimit;
            for (Config config : offering.getConfigs()) {
                for (Subpart subpart : config.getSubparts()) {
                    for (Section section : subpart.getSections()) {
                        int oldLimit = section.getLimit();
                        section.setLimit((int)Math.ceil(fact * (double)section.getLimit()));
                        sLog.info((Object)("    -- limit of section " + section + " increased to " + section.getLimit() + " (was " + oldLimit + ")"));
                    }
                }
            }
        }
        return ret;
    }
}

