/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct;

import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import org.cpsolver.ifs.util.JProf;

public class OnlineSectProof {
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    public static String[] sOnlineAlgs = new String[]{"Max(Available)", "Min(Used/Limit)", "Min(Expected-Available)", "Min(Expected/Available)", "Min((Expected-Available)/Limit)", "Min(Expected/(Available*Limit))"};

    public static boolean skip(boolean computeExpectations, int alg, boolean allTheSame) {
        switch (alg) {
            case 0: {
                return !computeExpectations;
            }
            case 1: {
                return !computeExpectations;
            }
        }
        return false;
    }

    public static double onlineObjective(double limit, double used, double expected, int alg) {
        double available = limit - used;
        switch (alg) {
            case 0: {
                return -available;
            }
            case 1: {
                return used / limit;
            }
            case 2: {
                return expected - available;
            }
            case 3: {
                return expected / available;
            }
            case 4: {
                return (expected - available) / limit;
            }
            case 5: {
                return expected / (available * limit);
            }
        }
        return 0.0;
    }

    public static int checkOnline(StudentSequence sq, boolean computeExpectations, int alg, boolean debug) {
        int i;
        int[] used = new int[sq.nrColumns()];
        double[] exp = new double[sq.nrColumns()];
        for (i = 0; i < sq.nrColumns(); ++i) {
            used[i] = 0;
            exp[i] = 0.0;
        }
        if (computeExpectations) {
            for (i = 0; i < sq.size(); ++i) {
                int x = sq.seq(i);
                double ex = 1.0 / (double)sq.nrAllow(x);
                for (int c = 0; c < sq.nrColumns(); ++c) {
                    if (!sq.allow(x, c)) continue;
                    int n = c;
                    exp[n] = exp[n] + ex;
                }
            }
        }
        if (debug) {
            StringBuffer sbExp = new StringBuffer();
            StringBuffer sbUse = new StringBuffer();
            for (int c = 0; c < sq.nrColumns(); ++c) {
                if (c > 0) {
                    sbExp.append(",");
                    sbUse.append(",");
                }
                sbExp.append(sDF.format(exp[c]));
                sbUse.append(used[c]);
            }
            System.out.println("      -- initial USE:[" + sbUse + "], EXP:[" + sbExp + "], SQ:" + sq.toString() + ", ALG:" + sOnlineAlgs[alg]);
        }
        int ret = 0;
        for (int i2 = 0; i2 < sq.size(); ++i2) {
            int x = sq.seq(i2);
            int bestCol = -1;
            double bestObj = 0.0;
            for (int c = 0; c < sq.nrColumns(); ++c) {
                if (!sq.allow(x, c) || used[c] >= sq.limit(c)) continue;
                double obj = OnlineSectProof.onlineObjective(sq.limit(c), used[c], exp[c], alg);
                if (debug) {
                    System.out.println("      -- test " + (char)(65 + x) + " --> " + (c + 1) + " (OBJ=" + sDF.format(obj) + ")");
                }
                if (bestCol >= 0 && !(bestObj > obj)) continue;
                bestCol = c;
                bestObj = obj;
            }
            if (bestCol >= 0) {
                int n = bestCol;
                used[n] = used[n] + 1;
                double ex = 1.0 / (double)sq.nrAllow(x);
                for (int c = 0; c < sq.nrColumns(); ++c) {
                    if (!sq.allow(x, c)) continue;
                    int n2 = c;
                    exp[n2] = exp[n2] - ex;
                }
                if (!debug) continue;
                StringBuffer sbExp = new StringBuffer();
                StringBuffer sbUse = new StringBuffer();
                for (int c = 0; c < sq.nrColumns(); ++c) {
                    if (c > 0) {
                        sbExp.append(",");
                        sbUse.append(",");
                    }
                    sbExp.append(sDF.format(exp[c]));
                    sbUse.append(used[c]);
                }
                System.out.println("    " + (char)(65 + x) + " --> " + (bestCol + 1) + " (OBJ=" + sDF.format(bestObj) + ", USE:[" + sbUse + "], EXP:[" + sbExp + "])");
                continue;
            }
            if (debug) {
                System.out.println("    " + (char)(65 + x) + " --> FAIL");
            }
            ++ret;
        }
        return ret;
    }

    public static void main(String[] args) {
        int i;
        long t0;
        int i2;
        int[] x = new int[args.length];
        for (int i3 = 0; i3 < args.length; ++i3) {
            x[i3] = Integer.parseInt(args[i3]);
        }
        if (args.length == 0) {
            x = new int[]{5, 5};
        }
        boolean categories = "true".equals(System.getProperty("cat", "true"));
        boolean allTheSameSize = true;
        String filter = System.getProperty("filter");
        StudentSequence sq = new StudentSequence(x);
        System.out.println("base: " + sq.base());
        System.out.println("columns:");
        int sameSize = -1;
        for (int col = 0; col < x.length; ++col) {
            System.out.println("  " + (col + 1) + ". column of limit " + sq.limit(col));
            if (sameSize < 0) {
                sameSize = sq.limit(col);
                continue;
            }
            if (sameSize == sq.limit(col)) continue;
            allTheSameSize = false;
        }
        System.out.println("combinations:");
        for (i2 = 0; i2 < sq.base(); ++i2) {
            System.out.println("  case " + (char)(65 + i2) + ": ");
            System.out.println("    max: " + sq.maxCnt(i2));
            for (int col = 0; col < x.length; ++col) {
                if (!sq.allow(i2, col)) continue;
                System.out.println("      " + (col + 1) + ". column allowed");
            }
        }
        if (System.getProperty("check") != null) {
            sq.set(System.getProperty("check"));
            if (System.getProperty("case") != null) {
                i2 = Integer.parseInt(System.getProperty("case")) - 1;
                System.out.println("Online sectioning #" + (i2 + 1) + " " + sOnlineAlgs[i2 / 2] + (i2 % 2 == 0 ? "" : " w/o precomputed expectations"));
                OnlineSectProof.checkOnline(sq, i2 % 2 == 0, i2 / 2, true);
            } else {
                for (i2 = 0; i2 < 2 * sOnlineAlgs.length; ++i2) {
                    if (OnlineSectProof.skip(i2 % 2 == 0, i2 / 2, allTheSameSize)) continue;
                    System.out.println("Online sectioning #" + (i2 + 1) + " " + sOnlineAlgs[i2 / 2] + (i2 % 2 == 0 ? "" : " w/o precomputed expectations"));
                    OnlineSectProof.checkOnline(sq, i2 % 2 == 0, i2 / 2, true);
                }
            }
            return;
        }
        TreeSet[] worstCaseSq = new TreeSet[2 * sOnlineAlgs.length];
        int[] worstCase = new int[2 * sOnlineAlgs.length];
        int[] total = new int[2 * sOnlineAlgs.length];
        HashMap[] worstCaseSqCat = new HashMap[2 * sOnlineAlgs.length];
        HashMap[] worstCaseCat = new HashMap[2 * sOnlineAlgs.length];
        HashMap[] totalCat = new HashMap[2 * sOnlineAlgs.length];
        HashMap[] countCat = new HashMap[2 * sOnlineAlgs.length];
        for (int i4 = 0; i4 < 2 * sOnlineAlgs.length; ++i4) {
            total[i4] = 0;
            worstCase[i4] = -1;
            worstCaseSq[i4] = null;
            worstCaseSqCat[i4] = new HashMap();
            worstCaseCat[i4] = new HashMap();
            totalCat[i4] = new HashMap();
            countCat[i4] = new HashMap();
        }
        long nrCases = 0L;
        System.out.println("N=" + sDF.format(Math.pow(sq.base(), sq.size())));
        long mark = t0 = JProf.currentTimeMillis();
        long nc = 0L;
        long hc = 0L;
        do {
            if ((filter == null || filter.equals(sq.cat())) && sq.check()) {
                for (i = 0; i < 2 * sOnlineAlgs.length; ++i) {
                    if (OnlineSectProof.skip(i % 2 == 0, i / 2, allTheSameSize)) continue;
                    int onl = OnlineSectProof.checkOnline(sq, i % 2 == 0, i / 2, false);
                    int n = i;
                    total[n] = total[n] + onl;
                    if (worstCaseSq[i] == null || worstCase[i] < onl) {
                        if (worstCaseSq[i] == null) {
                            worstCaseSq[i] = new TreeSet();
                        } else {
                            worstCaseSq[i].clear();
                        }
                        worstCaseSq[i].add(sq.toString());
                        worstCase[i] = onl;
                    } else if (worstCase[i] == onl && onl > 0 && worstCaseSq[i].size() < 100) {
                        worstCaseSq[i].add(sq.toString());
                    }
                    if (!categories) continue;
                    String cat = sq.cat();
                    Counter cc = (Counter)countCat[i].get(cat);
                    if (cc == null) {
                        countCat[i].put(cat, new Counter(1));
                    } else {
                        cc.inc();
                    }
                    if (onl <= 0) continue;
                    Counter tc = (Counter)totalCat[i].get(cat);
                    if (tc == null) {
                        totalCat[i].put(cat, new Counter(onl));
                    } else {
                        tc.inc(onl);
                    }
                    Integer wc = (Integer)worstCaseCat[i].get(cat);
                    if (wc != null && wc >= onl) continue;
                    worstCaseCat[i].put(cat, new Integer(onl));
                    worstCaseSqCat[i].put(cat, sq.toString());
                }
                ++nrCases;
                ++hc;
            }
            if (++nc % 1000000L != 0L) continue;
            mark = JProf.currentTimeMillis();
            double progress = sq.progress();
            double exp = (1.0 - progress) / progress * (double)(mark - t0);
            System.out.println("  " + sDF.format(100.0 * progress) + "% done in " + sDF.format((double)(mark - t0) / 60000.0) + " min (" + sDF.format(exp / 60000.0) + " min to go, hit " + sDF.format(100.0 * (double)hc / (double)nc) + "%)");
        } while (sq.inc());
        System.out.println("Number of combinations:" + nrCases + " (hit " + sDF.format(100.0 * (double)hc / (double)nc) + "%)");
        for (i = 0; i < 2 * sOnlineAlgs.length; ++i) {
            if (OnlineSectProof.skip(i % 2 == 0, i / 2, allTheSameSize)) continue;
            System.out.println("Online sectioning #" + (i + 1) + " " + sOnlineAlgs[i / 2] + (i % 2 == 0 ? "" : " w/o precomputed expectations"));
            System.out.println("  worst case: " + sDF.format(100.0 * (double)worstCase[i] / (double)sq.size()) + "% (" + worstCase[i] + " of " + sq.size() + ", sequence " + worstCaseSq[i] + ")");
            System.out.println("  average case: " + sDF.format(100.0 * (double)total[i] / (double)((long)sq.size() * nrCases)) + "%");
            sq.set((String)worstCaseSq[i].first());
            OnlineSectProof.checkOnline(sq, i % 2 == 0, i / 2, true);
            TreeSet<String> cats = new TreeSet<String>(new CatCmp(countCat[i], totalCat[i], worstCaseCat[i]));
            cats.addAll(totalCat[i].keySet());
            for (String cat : cats) {
                int cc = ((Counter)countCat[i].get(cat)).intValue();
                int tc = ((Counter)totalCat[i].get(cat)).intValue();
                int wc = (Integer)worstCaseCat[i].get(cat);
                String wcsq = (String)worstCaseSqCat[i].get(cat);
                System.out.println("  Category " + cat + " (size=" + cc + ")");
                System.out.println("    worst case: " + sDF.format(100.0 * (double)wc / (double)sq.size()) + "% (" + wc + " of " + sq.size() + ", sequence " + wcsq + ")");
                System.out.println("    average case: " + sDF.format(100.0 * (double)tc / (double)(sq.size() * cc)) + "%");
            }
        }
    }

    public static class CatCmp
    implements Comparator<String> {
        HashMap<String, Integer> iWorstCaseCat;
        HashMap<String, Counter> iTotalCat;
        HashMap<String, Counter> iCountCat;

        public CatCmp(HashMap<String, Counter> countCat, HashMap<String, Counter> totalCat, HashMap<String, Integer> worstCaseCat) {
            this.iWorstCaseCat = worstCaseCat;
            this.iTotalCat = totalCat;
            this.iCountCat = countCat;
        }

        @Override
        public int compare(String c1, String c2) {
            int wc1 = this.iWorstCaseCat.get(c1);
            int wc2 = this.iWorstCaseCat.get(c2);
            int cmp = Double.compare(wc2, wc1);
            if (cmp != 0) {
                return cmp;
            }
            int cc1 = this.iCountCat.get(c1).intValue();
            int tc1 = this.iTotalCat.get(c1).intValue();
            int cc2 = this.iCountCat.get(c2).intValue();
            int tc2 = this.iTotalCat.get(c2).intValue();
            cmp = Double.compare((double)tc2 / (double)cc2, (double)tc1 / (double)cc1);
            if (cmp != 0) {
                return cmp;
            }
            return c1.compareTo(c2);
        }
    }

    public static class Counter {
        private int iCnt = 0;

        public Counter() {
        }

        public Counter(int init) {
            this.iCnt = init;
        }

        public void inc() {
            ++this.iCnt;
        }

        public void inc(int val) {
            this.iCnt += val;
        }

        public int intValue() {
            return this.iCnt;
        }
    }

    public static class StudentSequence
    extends Sequence {
        private int[] iColumns;
        private int[] iMaxCnt;

        public StudentSequence(int[] columns) {
            super(StudentSequence.length(columns), StudentSequence.base(columns.length));
            this.iColumns = columns;
            this.iMaxCnt = new int[this.base()];
            for (int i = 0; i < this.iMaxCnt.length; ++i) {
                this.iMaxCnt[i] = this.maxCnt(i);
            }
        }

        public int nrColumns() {
            return this.iColumns.length;
        }

        public int limit(int col) {
            return this.iColumns[col];
        }

        public boolean check() {
            for (int i = 0; i < this.base(); ++i) {
                if (this.maxCnt(i) >= this.count(i)) continue;
                return false;
            }
            for (int c = 0; c < this.nrColumns(); ++c) {
                int allowed = 0;
                for (int i = 0; i < this.size() && allowed < this.limit(c); ++i) {
                    if (!this.allow(this.seq(i), c)) continue;
                    ++allowed;
                }
                if (allowed >= this.limit(c)) continue;
                return false;
            }
            return true;
        }

        private static int length(int[] columns) {
            int len = 0;
            for (int i = 0; i < columns.length; ++i) {
                len += columns[i];
            }
            return len;
        }

        private static int base(int nrColumns) {
            return (1 << nrColumns) - 1;
        }

        public boolean allow(int x, int col) {
            return (x + 1 & 1 << col) != 0;
        }

        public int nrAllow(int x) {
            int ret = 0;
            for (int i = 0; i < this.nrColumns(); ++i) {
                if (!this.allow(x, i)) continue;
                ++ret;
            }
            return ret;
        }

        public int maxCnt(int x) {
            int ret = 0;
            for (int i = 0; i < this.nrColumns(); ++i) {
                if (!this.allow(x, i)) continue;
                ret += this.limit(i);
            }
            return ret;
        }
    }

    public static class Sequence {
        private int iBase;
        private int[] iSequence;
        private int[] iCnt;

        public Sequence(int length, int base) {
            int i;
            this.iSequence = new int[length];
            for (i = 0; i < this.iSequence.length; ++i) {
                this.iSequence[i] = 0;
            }
            this.iCnt = new int[base];
            for (i = 0; i < this.iCnt.length; ++i) {
                this.iCnt[i] = 0;
            }
            this.iCnt[0] = length;
            this.iBase = base;
        }

        public boolean inc() {
            return this.inc(0);
        }

        public int base() {
            return this.iBase;
        }

        private boolean inc(int pos) {
            if (pos >= this.iSequence.length) {
                return false;
            }
            int n = this.iSequence[pos];
            this.iCnt[n] = this.iCnt[n] - 1;
            this.iSequence[pos] = (this.iSequence[pos] + 1) % this.iBase;
            int n2 = this.iSequence[pos];
            this.iCnt[n2] = this.iCnt[n2] + 1;
            if (this.iSequence[pos] == 0) {
                return this.inc(pos + 1);
            }
            return true;
        }

        public int count(int i) {
            return this.iCnt[i];
        }

        public int size() {
            return this.iSequence.length;
        }

        public int seq(int i) {
            return this.iSequence[i];
        }

        public void set(String seq) {
            int i;
            for (i = 0; i < this.iCnt.length; ++i) {
                this.iCnt[i] = 0;
            }
            for (i = 0; i < this.iSequence.length; ++i) {
                this.iSequence[i] = seq.charAt(i) - 65;
                int n = this.iSequence[i];
                this.iCnt[n] = this.iCnt[n] + 1;
            }
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < this.iSequence.length; ++i) {
                s.append((char)(65 + this.iSequence[i]));
            }
            return s.toString();
        }

        public double progress() {
            double ret = 0.0;
            double mx = 1.0;
            for (int i = this.size() - 1; i >= 0; --i) {
                ret += mx * (double)this.iSequence[i] / (double)this.iBase;
                mx *= 1.0 / (double)this.iBase;
            }
            return ret;
        }

        public String cat() {
            StringBuffer s = new StringBuffer();
            for (int i = 0; i < this.iBase; ++i) {
                if (this.iCnt[i] <= 0) continue;
                s.append((char)(65 + i));
                s.append(this.iCnt[i]);
            }
            return s.toString();
        }
    }
}

