/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class DataProperties
extends Properties {
    private boolean iSaveDefaults = false;
    private static final long serialVersionUID = 1L;

    public DataProperties() {
    }

    public DataProperties(Properties defaults) {
        super(defaults);
        this.iSaveDefaults = this.getPropertyBoolean("General.SaveDefaultProperties", false);
    }

    public DataProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
        this.iSaveDefaults = this.getPropertyBoolean("General.SaveDefaultProperties", false);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (!this.iSaveDefaults || this.containsPropery(key)) {
            return super.getProperty(key, defaultValue);
        }
        if (defaultValue != null) {
            this.setProperty(key, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public Object setProperty(String key, String value) {
        if (value == null) {
            String ret = this.getProperty(key);
            this.remove(key);
            return ret;
        }
        Object ret = super.setProperty(key, value);
        if ("General.SaveDefaultProperties".equals(key)) {
            this.iSaveDefaults = this.getPropertyBoolean("General.SaveDefaultProperties", false);
        }
        return ret;
    }

    public int getPropertyInt(String key, int defaultValue) {
        try {
            if (this.containsPropery(key)) {
                return Integer.parseInt(this.getProperty(key));
            }
            if (this.iSaveDefaults) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
        catch (NumberFormatException nfe) {
            if (this.iSaveDefaults) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
    }

    public long getPropertyLong(String key, long defaultValue) {
        try {
            if (this.containsPropery(key)) {
                return Long.parseLong(this.getProperty(key));
            }
            if (this.iSaveDefaults) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
        catch (NumberFormatException nfe) {
            if (this.iSaveDefaults) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
    }

    public Integer getPropertyInteger(String key, Integer defaultValue) {
        try {
            if (this.containsPropery(key)) {
                return Integer.valueOf(this.getProperty(key));
            }
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
        catch (NumberFormatException nfe) {
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
    }

    public Long getPropertyLong(String key, Long defaultValue) {
        try {
            if (this.containsPropery(key)) {
                return Long.valueOf(this.getProperty(key));
            }
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
        catch (NumberFormatException nfe) {
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
    }

    public boolean containsPropery(String key) {
        return this.getProperty(key) != null;
    }

    public boolean getPropertyBoolean(String key, boolean defaultValue) {
        try {
            if (this.containsPropery(key)) {
                return this.getProperty(key).equalsIgnoreCase("on") || this.getProperty(key).equalsIgnoreCase("true");
            }
            if (this.iSaveDefaults) {
                this.setProperty(key, defaultValue ? "true" : "false");
            }
            return defaultValue;
        }
        catch (Exception nfe) {
            if (this.iSaveDefaults) {
                this.setProperty(key, defaultValue ? "true" : "false");
            }
            return defaultValue;
        }
    }

    public double getPropertyDouble(String key, double defaultValue) {
        try {
            if (this.containsPropery(key)) {
                return Double.parseDouble(this.getProperty(key));
            }
            if (this.iSaveDefaults) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
        catch (NumberFormatException nfe) {
            if (this.iSaveDefaults) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
    }

    public float getPropertyFloat(String key, float defaultValue) {
        try {
            if (this.containsPropery(key)) {
                return Float.parseFloat(this.getProperty(key));
            }
            if (this.iSaveDefaults) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
        catch (NumberFormatException nfe) {
            if (this.iSaveDefaults) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
    }

    public Boolean getPropertyBoolean(String key, Boolean defaultValue) {
        try {
            if (this.containsPropery(key)) {
                return new Boolean(this.getProperty(key).equalsIgnoreCase("on") || this.getProperty(key).equalsIgnoreCase("true"));
            }
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, defaultValue != false ? "true" : "false");
            }
            return defaultValue;
        }
        catch (Exception nfe) {
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, defaultValue != false ? "true" : "false");
            }
            return defaultValue;
        }
    }

    public Double getPropertyDouble(String key, Double defaultValue) {
        try {
            if (this.containsPropery(key)) {
                return Double.valueOf(this.getProperty(key));
            }
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
        catch (NumberFormatException nfe) {
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
    }

    public Float getPropertyFloat(String key, Float defaultValue) {
        try {
            if (this.containsPropery(key)) {
                return Float.valueOf(this.getProperty(key));
            }
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
        catch (NumberFormatException nfe) {
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, String.valueOf(defaultValue));
            }
            return defaultValue;
        }
    }

    public void setProperty(String key, Object[] value) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(value[i] == null ? "null" : value[i].toString());
        }
        this.setProperty(key, sb.toString());
    }

    public Long[] getPropertyLongArry(String key, Long[] defaultValue) {
        try {
            if (this.containsPropery(key)) {
                StringTokenizer stk = new StringTokenizer(this.getProperty(key), ",");
                Long[] ret = new Long[stk.countTokens()];
                int i = 0;
                while (stk.hasMoreTokens()) {
                    String t = stk.nextToken();
                    ret[i] = "null".equals(t) ? null : Long.valueOf(t);
                    ++i;
                }
                return ret;
            }
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, defaultValue);
            }
            return defaultValue;
        }
        catch (NumberFormatException nfe) {
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, defaultValue);
            }
            return defaultValue;
        }
    }

    public Integer[] getPropertyIntegerArry(String key, Integer[] defaultValue) {
        try {
            if (this.containsPropery(key)) {
                StringTokenizer stk = new StringTokenizer(this.getProperty(key), ",");
                Integer[] ret = new Integer[stk.countTokens()];
                int i = 0;
                while (stk.hasMoreTokens()) {
                    String t = stk.nextToken();
                    ret[i] = "null".equals(t) ? null : Integer.valueOf(t);
                    ++i;
                }
                return ret;
            }
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, defaultValue);
            }
            return defaultValue;
        }
        catch (NumberFormatException nfe) {
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, defaultValue);
            }
            return defaultValue;
        }
    }

    public Double[] getPropertyDoubleArry(String key, Double[] defaultValue) {
        try {
            if (this.containsPropery(key)) {
                StringTokenizer stk = new StringTokenizer(this.getProperty(key), ",");
                Double[] ret = new Double[stk.countTokens()];
                int i = 0;
                while (stk.hasMoreTokens()) {
                    String t = stk.nextToken();
                    ret[i] = "null".equals(t) ? null : Double.valueOf(t);
                    ++i;
                }
                return ret;
            }
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, defaultValue);
            }
            return defaultValue;
        }
        catch (NumberFormatException nfe) {
            if (this.iSaveDefaults && defaultValue != null) {
                this.setProperty(key, defaultValue);
            }
            return defaultValue;
        }
    }

    public Map<String, String> toMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String prop = this.getProperty(key);
            if (key == null || prop == null) continue;
            ret.put(key, prop);
        }
        return ret;
    }

    private void expand(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            return;
        }
        int done = -1;
        int idx = -1;
        while ((idx = value.indexOf(37, done + 1)) >= 0) {
            int idx2 = value.indexOf(37, idx + 1);
            if (idx2 < 0) {
                return;
            }
            String subString = value.substring(idx + 1, idx2);
            if (this.containsPropery(subString)) {
                value = value.substring(0, idx) + this.getProperty(subString) + value.substring(idx2 + 1);
                continue;
            }
            done = idx;
        }
        this.setProperty(key, value);
    }

    public void expand() {
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            this.expand((String)e.nextElement());
        }
    }

    @Override
    public void load(InputStream inputStream) throws IOException {
        super.load(inputStream);
        this.expand();
        this.iSaveDefaults = this.getPropertyBoolean("General.SaveDefaultProperties", false);
    }
}

