/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.EmptyAssignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.VariableListener;
import org.cpsolver.ifs.util.IdGenerator;

public class Variable<V extends Variable<V, T>, T extends Value<V, T>>
implements Comparable<V> {
    private static IdGenerator iIdGenerator = new IdGenerator();
    protected long iId = -1L;
    private Model<V, T> iModel = null;
    private T iInitialValue = null;
    protected T iValue = null;
    private Value<V, T>[] iAssignedValues = (Value[])Array.newInstance(Value.class, 17);
    private T iBestValue = null;
    private long iBestAssignmentIteration = 0L;
    private List<T> iValues = null;
    private T iRecentlyRemovedValue = null;
    private long iLastIteration = 0L;
    private Object iExtra = null;
    private List<Constraint<V, T>> iConstraints = new ArrayList<Constraint<V, T>>();
    private List<Constraint<V, T>> iHardConstraints = new ArrayList<Constraint<V, T>>();
    private List<Constraint<V, T>> iSoftConstraints = new ArrayList<Constraint<V, T>>();
    private List<VariableListener<T>> iVariableListeners = null;
    private Map<V, List<Constraint<V, T>>> iConstraintVariables = null;
    protected int iIndex = -1;

    public Variable() {
        this(null);
    }

    public Variable(T initialValue) {
        this.iId = iIdGenerator.newId();
        this.setInitialAssignment(initialValue);
    }

    public Model<V, T> getModel() {
        return this.iModel;
    }

    public void setModel(Model<V, T> model) {
        this.iModel = model;
    }

    @Deprecated
    public List<T> values() {
        return this.values(new EmptyAssignment());
    }

    public List<T> values(Assignment<V, T> assignment) {
        return this.iValues;
    }

    protected void setValues(List<T> values) {
        this.iValues = values;
    }

    @Deprecated
    public boolean hasValues() {
        return !this.values().isEmpty();
    }

    @Deprecated
    public T getAssignment() {
        return this.iValue;
    }

    @Deprecated
    public boolean hasAssignment() {
        return this.iValue != null;
    }

    public T getAssignment(Assignment<V, T> assignment) {
        return assignment.getValue(this);
    }

    public boolean hasAssignment(Assignment<V, T> assignment) {
        return this.getAssignment(assignment) != null;
    }

    @Deprecated
    public void setAssignment(T value) {
        this.iValue = value;
    }

    @Deprecated
    public Value<V, T>[] getAssignments() {
        return this.iAssignedValues;
    }

    public T getInitialAssignment() {
        return this.iInitialValue;
    }

    public void setInitialAssignment(T initialValue) {
        this.iInitialValue = initialValue;
        if (this.iInitialValue != null && ((Value)this.iInitialValue).variable() == null) {
            ((Value)this.iInitialValue).setVariable(this);
        }
        if (this.iModel != null) {
            this.iModel.invalidateVariablesWithInitialValueCache();
        }
    }

    public boolean hasInitialAssignment() {
        return this.iInitialValue != null;
    }

    @Deprecated
    public void assign(int iteration, T value) {
        if (this.iRecentlyRemovedValue != null && ((Value)this.iRecentlyRemovedValue).equals(value)) {
            this.iRecentlyRemovedValue = null;
            return;
        }
        this.getModel().getDefaultAssignment().assign(iteration, value);
    }

    @Deprecated
    public void unassign(int iteration) {
        this.getModel().getDefaultAssignment().unassign(iteration, this);
    }

    @Deprecated
    public long getLastIteration() {
        return this.iLastIteration;
    }

    @Deprecated
    public void setLastIteration(long iteration) {
        this.iLastIteration = iteration;
    }

    public void variableAssigned(Assignment<V, T> assignment, long iteration, T value) {
        if (this.iVariableListeners != null) {
            for (VariableListener<T> listener : this.iVariableListeners) {
                listener.variableAssigned(assignment, iteration, value);
            }
        }
    }

    public void variableUnassigned(Assignment<V, T> assignment, long iteration, T oldValue) {
        if (this.iVariableListeners != null) {
            for (VariableListener<T> listener : this.iVariableListeners) {
                listener.variableUnassigned(assignment, iteration, oldValue);
            }
        }
    }

    public void addContstraint(Constraint<V, T> constraint) {
        this.iConstraints.add(constraint);
        if (constraint.isHard()) {
            this.iHardConstraints.add(constraint);
            this.iConstraintVariables = null;
        } else {
            this.iSoftConstraints.add(constraint);
        }
    }

    public void removeContstraint(Constraint<V, T> constraint) {
        this.iConstraints.remove(constraint);
        if (this.iHardConstraints.contains(constraint)) {
            this.iHardConstraints.remove(constraint);
            this.iConstraintVariables = null;
        } else {
            this.iSoftConstraints.remove(constraint);
        }
    }

    public List<Constraint<V, T>> constraints() {
        return this.iConstraints;
    }

    public List<Constraint<V, T>> hardConstraints() {
        return this.iHardConstraints;
    }

    public List<Constraint<V, T>> softConstraints() {
        return this.iSoftConstraints;
    }

    public String toString() {
        return this.getName();
    }

    public long getId() {
        return this.iId;
    }

    public int hashCode() {
        return (int)this.iId;
    }

    public String getName() {
        return String.valueOf(this.iId);
    }

    public String getDescription() {
        return null;
    }

    public void setBestAssignment(T value, long iteration) {
        this.iBestValue = value;
        this.iBestAssignmentIteration = iteration;
    }

    public T getBestAssignment() {
        return this.iBestValue;
    }

    public long getBestAssignmentIteration() {
        return this.iBestAssignmentIteration;
    }

    @Override
    public int compareTo(V variable) {
        if (variable == null) {
            return -1;
        }
        int cmp = this.getName().compareTo(((Variable)variable).getName());
        if (cmp != 0) {
            return cmp;
        }
        return Double.compare(this.getId(), ((Variable)variable).getId());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Variable)) {
            return false;
        }
        return this.getId() == ((Variable)o).getId();
    }

    public void addVariableListener(VariableListener<T> listener) {
        if (this.iVariableListeners == null) {
            this.iVariableListeners = new ArrayList<VariableListener<T>>();
        }
        this.iVariableListeners.add(listener);
    }

    public void removeVariableListener(VariableListener<T> listener) {
        if (this.iVariableListeners != null) {
            this.iVariableListeners.remove(listener);
        }
    }

    public List<VariableListener<T>> getVariableListeners() {
        return this.iVariableListeners;
    }

    public <X> void setExtra(X object) {
        this.iExtra = object;
    }

    public <X> X getExtra() {
        try {
            return (X)this.iExtra;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public void removeValue(long iteration, T value) {
        if (((Value)value).equals(this.getModel().getDefaultAssignment().getValue(this))) {
            this.getModel().getDefaultAssignment().unassign(iteration, this);
        }
        if (this.iValues == null) {
            return;
        }
        this.iValues.remove(value);
        if (this.iInitialValue != null && ((Value)this.iInitialValue).equals(value)) {
            this.iInitialValue = null;
            if (this.iModel != null) {
                this.iModel.invalidateVariablesWithInitialValueCache();
            }
        }
        if (this.iVariableListeners != null) {
            for (VariableListener<T> listener : this.iVariableListeners) {
                listener.valueRemoved(iteration, value);
            }
        }
        this.iRecentlyRemovedValue = value;
    }

    public Map<V, List<Constraint<V, T>>> constraintVariables() {
        if (this.iConstraintVariables == null) {
            this.iConstraintVariables = new HashMap<V, List<Constraint<V, T>>>();
            for (Constraint<V, T> constraint : this.constraints()) {
                for (Variable variable : constraint.variables()) {
                    if (variable.equals(this)) continue;
                    List<Constraint<V, T>> constraints = this.iConstraintVariables.get(variable);
                    if (constraints == null) {
                        constraints = new ArrayList<Constraint<V, T>>();
                        this.iConstraintVariables.put((List<Constraint<V, T>>)((Object)variable), (List<Constraint<List<Constraint<V, T>>, T>>)constraints);
                    }
                    constraints.add(constraint);
                }
            }
        }
        return this.iConstraintVariables;
    }

    public void removeInitialValue() {
        if (this.iInitialValue == null) {
            return;
        }
        if (this.iValues == null) {
            return;
        }
        this.iValues.remove(this.iInitialValue);
        if (this.iModel != null) {
            this.iModel.invalidateVariablesWithInitialValueCache();
        }
        this.iInitialValue = null;
    }

    public void setIndex(int index) {
        this.iIndex = index;
    }

    public int getIndex() {
        return this.iIndex;
    }
}

